/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.concurrent;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.concurrent.LockType;
import net.sf.ehcache.concurrent.Sync;

public class ReadWriteLockSync
implements Sync {
    private final ReentrantReadWriteLock rrwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rrwl.readLock();
    private final Lock writeLock = this.rrwl.writeLock();

    public void lock(LockType type) {
        if (type == LockType.WRITE && !this.rrwl.isWriteLockedByCurrentThread()) {
            this.getLock(type).lock();
        } else if (type != LockType.WRITE) {
            this.getLock(type).lock();
        }
    }

    public boolean tryLock(LockType type, long msec) throws InterruptedException {
        return this.getLock(type).tryLock(msec, TimeUnit.MILLISECONDS);
    }

    public void unlock(LockType type) {
        Lock lock = this.getLock(type);
        if (type == LockType.WRITE && this.rrwl.isWriteLockedByCurrentThread()) {
            lock.unlock();
        } else if (type != LockType.WRITE) {
            lock.unlock();
        }
    }

    private Lock getLock(LockType type) {
        switch (type) {
            case READ: {
                return this.readLock;
            }
            case WRITE: {
                return this.writeLock;
            }
        }
        throw new IllegalArgumentException("We don't support any other lock type than READ or WRITE!");
    }
}

