/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.config.CacheWriterConfiguration;
import net.sf.ehcache.config.DiskStoreConfiguration;
import net.sf.ehcache.config.FactoryConfiguration;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.TerracottaConfiguration;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheConfiguration
implements Cloneable {
    public static final long DEFAULT_EXPIRY_THREAD_INTERVAL_SECONDS = 120L;
    public static final int DEFAULT_SPOOL_BUFFER_SIZE = 30;
    public static final MemoryStoreEvictionPolicy DEFAULT_MEMORY_STORE_EVICTION_POLICY = MemoryStoreEvictionPolicy.LRU;
    private static final Logger LOG = LoggerFactory.getLogger((String)CacheConfiguration.class.getName());
    protected String name;
    protected int maxElementsInMemory;
    protected int maxElementsOnDisk;
    protected MemoryStoreEvictionPolicy memoryStoreEvictionPolicy = DEFAULT_MEMORY_STORE_EVICTION_POLICY;
    protected boolean clearOnFlush = true;
    protected boolean eternal;
    protected long timeToIdleSeconds;
    protected long timeToLiveSeconds;
    protected boolean overflowToDisk;
    protected boolean diskPersistent;
    protected String diskStorePath = DiskStoreConfiguration.getDefaultPath();
    protected int diskSpoolBufferSizeMB = 30;
    protected long diskExpiryThreadIntervalSeconds = 120L;
    protected boolean loggingEnabled;
    protected volatile List<CacheEventListenerFactoryConfiguration> cacheEventListenerConfigurations = new ArrayList<CacheEventListenerFactoryConfiguration>();
    protected volatile List<CacheExtensionFactoryConfiguration> cacheExtensionConfigurations = new ArrayList<CacheExtensionFactoryConfiguration>();
    protected BootstrapCacheLoaderFactoryConfiguration bootstrapCacheLoaderFactoryConfiguration;
    protected CacheExceptionHandlerFactoryConfiguration cacheExceptionHandlerFactoryConfiguration;
    protected TerracottaConfiguration terracottaConfiguration;
    protected CacheWriterConfiguration cacheWriterConfiguration = new CacheWriterConfiguration();
    protected volatile List<CacheLoaderFactoryConfiguration> cacheLoaderConfigurations = new ArrayList<CacheLoaderFactoryConfiguration>();
    protected volatile Set<CacheConfigurationListener> listeners = new CopyOnWriteArraySet<CacheConfigurationListener>();
    private volatile boolean frozen;
    private TransactionalMode transactionalMode = TransactionalMode.OFF;

    CacheConfiguration() {
    }

    public CacheConfiguration(String name, int maxElementsInMemory) {
        this.name = name;
        this.maxElementsInMemory = maxElementsInMemory;
    }

    public CacheConfiguration clone() {
        CacheConfiguration config;
        try {
            config = (CacheConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        this.cloneCacheEventListenerConfigurations(config);
        this.cloneCacheExtensionConfigurations(config);
        if (this.bootstrapCacheLoaderFactoryConfiguration != null) {
            config.bootstrapCacheLoaderFactoryConfiguration = (BootstrapCacheLoaderFactoryConfiguration)this.bootstrapCacheLoaderFactoryConfiguration.clone();
        }
        if (this.cacheExceptionHandlerFactoryConfiguration != null) {
            config.cacheExceptionHandlerFactoryConfiguration = (CacheExceptionHandlerFactoryConfiguration)this.cacheExceptionHandlerFactoryConfiguration.clone();
        }
        if (this.terracottaConfiguration != null) {
            config.terracottaConfiguration = this.terracottaConfiguration.clone();
        }
        if (this.cacheWriterConfiguration != null) {
            config.cacheWriterConfiguration = this.cacheWriterConfiguration.clone();
        }
        this.cloneCacheLoaderConfigurations(config);
        config.listeners = new CopyOnWriteArraySet<CacheConfigurationListener>();
        return config;
    }

    private void cloneCacheEventListenerConfigurations(CacheConfiguration config) {
        if (this.cacheEventListenerConfigurations.size() > 0) {
            ArrayList<CacheEventListenerFactoryConfiguration> copy = new ArrayList<CacheEventListenerFactoryConfiguration>();
            for (CacheEventListenerFactoryConfiguration item : this.cacheEventListenerConfigurations) {
                copy.add((CacheEventListenerFactoryConfiguration)item.clone());
            }
            config.cacheEventListenerConfigurations = copy;
        }
    }

    private void cloneCacheExtensionConfigurations(CacheConfiguration config) {
        if (this.cacheExtensionConfigurations.size() > 0) {
            ArrayList<CacheExtensionFactoryConfiguration> copy = new ArrayList<CacheExtensionFactoryConfiguration>();
            for (CacheExtensionFactoryConfiguration item : this.cacheExtensionConfigurations) {
                copy.add((CacheExtensionFactoryConfiguration)item.clone());
            }
            config.cacheExtensionConfigurations = copy;
        }
    }

    private void cloneCacheLoaderConfigurations(CacheConfiguration config) {
        if (this.cacheLoaderConfigurations.size() > 0) {
            ArrayList<CacheLoaderFactoryConfiguration> copy = new ArrayList<CacheLoaderFactoryConfiguration>();
            for (CacheLoaderFactoryConfiguration item : this.cacheLoaderConfigurations) {
                copy.add((CacheLoaderFactoryConfiguration)item.clone());
            }
            config.cacheLoaderConfigurations = copy;
        }
    }

    public final void setName(String name) {
        this.checkDynamicChange();
        if (name == null) {
            throw new IllegalArgumentException("Cache name cannot be null.");
        }
        this.name = name;
    }

    public final CacheConfiguration name(String name) {
        this.setName(name);
        return this;
    }

    public final void setLoggingEnabled(boolean enable) {
        this.checkDynamicChange();
        boolean oldLoggingEnabled = this.loggingEnabled;
        this.loggingEnabled = enable;
        this.fireLoggingEnabledChanged(oldLoggingEnabled, enable);
    }

    public final CacheConfiguration loggingEnabled(boolean enable) {
        this.setLoggingEnabled(enable);
        return this;
    }

    public final void setMaxElementsInMemory(int maxElementsInMemory) {
        this.checkDynamicChange();
        int oldCapacity = this.maxElementsInMemory;
        int newCapacity = maxElementsInMemory;
        this.maxElementsInMemory = maxElementsInMemory;
        this.fireMemoryCapacityChanged(oldCapacity, newCapacity);
    }

    public final CacheConfiguration maxElementsInMemory(int maxElementsInMemory) {
        this.setMaxElementsInMemory(maxElementsInMemory);
        return this;
    }

    public final void setMemoryStoreEvictionPolicy(String memoryStoreEvictionPolicy) {
        this.setMemoryStoreEvictionPolicyFromObject(MemoryStoreEvictionPolicy.fromString(memoryStoreEvictionPolicy));
    }

    public final CacheConfiguration memoryStoreEvictionPolicy(String memoryStoreEvictionPolicy) {
        this.setMemoryStoreEvictionPolicy(memoryStoreEvictionPolicy);
        return this;
    }

    public final void setMemoryStoreEvictionPolicyFromObject(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        this.checkDynamicChange();
        this.memoryStoreEvictionPolicy = null == memoryStoreEvictionPolicy ? DEFAULT_MEMORY_STORE_EVICTION_POLICY : memoryStoreEvictionPolicy;
    }

    public final CacheConfiguration memoryStoreEvictionPolicy(MemoryStoreEvictionPolicy memoryStoreEvictionPolicy) {
        this.setMemoryStoreEvictionPolicyFromObject(memoryStoreEvictionPolicy);
        return this;
    }

    public final void setClearOnFlush(boolean clearOnFlush) {
        this.checkDynamicChange();
        this.clearOnFlush = clearOnFlush;
    }

    public final CacheConfiguration clearOnFlush(boolean clearOnFlush) {
        this.setClearOnFlush(clearOnFlush);
        return this;
    }

    public final void setEternal(boolean eternal) {
        this.checkDynamicChange();
        this.eternal = eternal;
        if (eternal) {
            this.setTimeToIdleSeconds(0L);
            this.setTimeToLiveSeconds(0L);
        }
    }

    public final CacheConfiguration eternal(boolean eternal) {
        this.setEternal(eternal);
        return this;
    }

    public final void setTimeToIdleSeconds(long timeToIdleSeconds) {
        this.checkDynamicChange();
        long oldTti = this.timeToIdleSeconds;
        long newTti = timeToIdleSeconds;
        this.timeToIdleSeconds = timeToIdleSeconds;
        this.fireTtiChanged(oldTti, newTti);
    }

    public final CacheConfiguration timeToIdleSeconds(long timeToIdleSeconds) {
        this.setTimeToIdleSeconds(timeToIdleSeconds);
        return this;
    }

    public final void setTimeToLiveSeconds(long timeToLiveSeconds) {
        this.checkDynamicChange();
        long oldTtl = this.timeToLiveSeconds;
        long newTtl = timeToLiveSeconds;
        this.timeToLiveSeconds = timeToLiveSeconds;
        this.fireTtlChanged(oldTtl, newTtl);
    }

    public final CacheConfiguration timeToLiveSeconds(long timeToLiveSeconds) {
        this.setTimeToLiveSeconds(timeToLiveSeconds);
        return this;
    }

    public final void setOverflowToDisk(boolean overflowToDisk) {
        this.checkDynamicChange();
        this.overflowToDisk = overflowToDisk;
        this.validateConfiguration();
    }

    public final CacheConfiguration overflowToDisk(boolean overflowToDisk) {
        this.setOverflowToDisk(overflowToDisk);
        return this;
    }

    public final void setDiskPersistent(boolean diskPersistent) {
        this.checkDynamicChange();
        this.diskPersistent = diskPersistent;
        this.validateConfiguration();
    }

    public final CacheConfiguration diskPersistent(boolean diskPersistent) {
        this.setDiskPersistent(diskPersistent);
        return this;
    }

    public final void setDiskStorePath(String diskStorePath) {
        this.checkDynamicChange();
        if (null == diskStorePath) {
            this.diskStorePath = DiskStoreConfiguration.getDefaultPath();
        }
        this.diskStorePath = diskStorePath;
        this.validateConfiguration();
    }

    public final CacheConfiguration diskStorePath(String diskStorePath) {
        this.setDiskStorePath(diskStorePath);
        return this;
    }

    public void setDiskSpoolBufferSizeMB(int diskSpoolBufferSizeMB) {
        this.checkDynamicChange();
        this.diskSpoolBufferSizeMB = diskSpoolBufferSizeMB <= 0 ? 30 : diskSpoolBufferSizeMB;
    }

    public final CacheConfiguration diskSpoolBufferSizeMB(int diskSpoolBufferSizeMB) {
        this.setDiskSpoolBufferSizeMB(diskSpoolBufferSizeMB);
        return this;
    }

    public void setMaxElementsOnDisk(int maxElementsOnDisk) {
        this.checkDynamicChange();
        int oldCapacity = this.maxElementsOnDisk;
        int newCapacity = maxElementsOnDisk;
        this.maxElementsOnDisk = maxElementsOnDisk;
        this.fireDiskCapacityChanged(oldCapacity, newCapacity);
    }

    public final CacheConfiguration maxElementsOnDisk(int maxElementsOnDisk) {
        this.setMaxElementsOnDisk(maxElementsOnDisk);
        return this;
    }

    public final void setDiskExpiryThreadIntervalSeconds(long diskExpiryThreadIntervalSeconds) {
        this.checkDynamicChange();
        this.diskExpiryThreadIntervalSeconds = diskExpiryThreadIntervalSeconds <= 0L ? 120L : diskExpiryThreadIntervalSeconds;
    }

    public final CacheConfiguration diskExpiryThreadIntervalSeconds(long diskExpiryThreadIntervalSeconds) {
        this.setDiskExpiryThreadIntervalSeconds(diskExpiryThreadIntervalSeconds);
        return this;
    }

    public void freezeConfiguration() {
        this.frozen = true;
    }

    public final void addCacheEventListenerFactory(CacheEventListenerFactoryConfiguration factory) {
        this.checkDynamicChange();
        this.cacheEventListenerConfigurations.add(factory);
        this.validateConfiguration();
    }

    public final CacheConfiguration cacheEventListenerFactory(CacheEventListenerFactoryConfiguration factory) {
        this.addCacheEventListenerFactory(factory);
        return this;
    }

    public final void addCacheExtensionFactory(CacheExtensionFactoryConfiguration factory) {
        this.checkDynamicChange();
        this.cacheExtensionConfigurations.add(factory);
    }

    public final CacheConfiguration cacheExtensionFactory(CacheExtensionFactoryConfiguration factory) {
        this.addCacheExtensionFactory(factory);
        return this;
    }

    public final void addBootstrapCacheLoaderFactory(BootstrapCacheLoaderFactoryConfiguration factory) {
        this.checkDynamicChange();
        this.bootstrapCacheLoaderFactoryConfiguration = factory;
    }

    public final CacheConfiguration bootstrapCacheLoaderFactory(BootstrapCacheLoaderFactoryConfiguration factory) {
        this.addBootstrapCacheLoaderFactory(factory);
        return this;
    }

    public final void addCacheExceptionHandlerFactory(CacheExceptionHandlerFactoryConfiguration factory) {
        this.checkDynamicChange();
        this.cacheExceptionHandlerFactoryConfiguration = factory;
    }

    public final CacheConfiguration cacheExceptionHandlerFactory(CacheExceptionHandlerFactoryConfiguration factory) {
        this.addCacheExceptionHandlerFactory(factory);
        return this;
    }

    public final void addCacheLoaderFactory(CacheLoaderFactoryConfiguration factory) {
        this.checkDynamicChange();
        this.cacheLoaderConfigurations.add(factory);
    }

    public final CacheConfiguration cacheLoaderFactory(CacheLoaderFactoryConfiguration factory) {
        this.addCacheLoaderFactory(factory);
        return this;
    }

    public final void addTerracotta(TerracottaConfiguration terracottaConfiguration) {
        this.terracottaConfiguration = terracottaConfiguration;
        this.validateConfiguration();
    }

    public final CacheConfiguration terracotta(TerracottaConfiguration terracottaConfiguration) {
        this.addTerracotta(terracottaConfiguration);
        return this;
    }

    public final void addCacheWriter(CacheWriterConfiguration cacheWriterConfiguration) {
        this.cacheWriterConfiguration = null == cacheWriterConfiguration ? new CacheWriterConfiguration() : cacheWriterConfiguration;
    }

    public final CacheConfiguration cacheWriter(CacheWriterConfiguration cacheWriterConfiguration) {
        this.addCacheWriter(cacheWriterConfiguration);
        return this;
    }

    public final void setTransactionalMode(String transactionalMode) {
        if (null == transactionalMode) {
            throw new IllegalArgumentException("TransactionalMode value must be non-null");
        }
        this.transactionalMode = TransactionalMode.valueOf(transactionalMode.toUpperCase());
    }

    public final CacheConfiguration transactionalMode(String transactionalMode) {
        this.setTransactionalMode(transactionalMode);
        return this;
    }

    public final CacheConfiguration transactionalMode(TransactionalMode transactionalMode) {
        if (null == transactionalMode) {
            throw new IllegalArgumentException("TransactionalMode value must be non-null");
        }
        this.transactionalMode = transactionalMode;
        return this;
    }

    private void validateConfiguration() {
        if (this.terracottaConfiguration != null && this.terracottaConfiguration.isClustered()) {
            if (this.overflowToDisk) {
                throw new InvalidConfigurationException("overflowToDisk isn't supported for a clustered Terracotta cache");
            }
            if (this.diskPersistent) {
                throw new InvalidConfigurationException("diskPersistent isn't supported for a clustered Terracotta cache");
            }
            if (this.cacheEventListenerConfigurations != null) {
                for (CacheEventListenerFactoryConfiguration listenerConfig : this.cacheEventListenerConfigurations) {
                    if (null == listenerConfig.getFullyQualifiedClassPath()) continue;
                    if (listenerConfig.getFullyQualifiedClassPath().startsWith("net.sf.ehcache.distribution.")) {
                        throw new InvalidConfigurationException("cache replication isn't supported for a clustered Terracotta cache");
                    }
                    if (!listenerConfig.getFullyQualifiedClassPath().startsWith("net.sf.ehcache.") || !LOG.isWarnEnabled()) continue;
                    LOG.warn("A non-standard CacheEventListenerFactory is used with a clustered Terracotta cache, if the purpose of this listener is replication it is not supported in a clustered context");
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public int getMaxElementsInMemory() {
        return this.maxElementsInMemory;
    }

    public int getMaxElementsOnDisk() {
        return this.maxElementsOnDisk;
    }

    public MemoryStoreEvictionPolicy getMemoryStoreEvictionPolicy() {
        return this.memoryStoreEvictionPolicy;
    }

    public boolean isClearOnFlush() {
        return this.clearOnFlush;
    }

    public boolean isEternal() {
        return this.eternal;
    }

    public long getTimeToIdleSeconds() {
        return this.timeToIdleSeconds;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public boolean isOverflowToDisk() {
        return this.overflowToDisk;
    }

    public boolean isDiskPersistent() {
        return this.diskPersistent;
    }

    public String getDiskStorePath() {
        return this.diskStorePath;
    }

    public int getDiskSpoolBufferSizeMB() {
        return this.diskSpoolBufferSizeMB;
    }

    public long getDiskExpiryThreadIntervalSeconds() {
        return this.diskExpiryThreadIntervalSeconds;
    }

    public boolean isLoggingEnabled() {
        return this.loggingEnabled;
    }

    public List getCacheEventListenerConfigurations() {
        return this.cacheEventListenerConfigurations;
    }

    public List getCacheExtensionConfigurations() {
        return this.cacheExtensionConfigurations;
    }

    public List getCacheLoaderConfigurations() {
        return this.cacheLoaderConfigurations;
    }

    public BootstrapCacheLoaderFactoryConfiguration getBootstrapCacheLoaderFactoryConfiguration() {
        return this.bootstrapCacheLoaderFactoryConfiguration;
    }

    public CacheExceptionHandlerFactoryConfiguration getCacheExceptionHandlerFactoryConfiguration() {
        return this.cacheExceptionHandlerFactoryConfiguration;
    }

    public TerracottaConfiguration getTerracottaConfiguration() {
        return this.terracottaConfiguration;
    }

    public CacheWriterConfiguration getCacheWriterConfiguration() {
        return this.cacheWriterConfiguration;
    }

    public boolean isTerracottaClustered() {
        return this.terracottaConfiguration != null && this.terracottaConfiguration.isClustered();
    }

    public final TransactionalMode getTransactionalMode() {
        return this.transactionalMode;
    }

    public boolean isTransactional() {
        return this.transactionalMode.isTransactional();
    }

    public boolean addConfigurationListener(CacheConfigurationListener listener) {
        boolean added = this.listeners.add(listener);
        if (added) {
            listener.registered(this);
        }
        return added;
    }

    public boolean removeConfigurationListener(CacheConfigurationListener listener) {
        boolean removed = this.listeners.remove(listener);
        if (removed) {
            listener.deregistered(this);
        }
        return removed;
    }

    private void fireTtiChanged(long oldTti, long newTti) {
        if (oldTti != newTti) {
            for (CacheConfigurationListener l : this.listeners) {
                l.timeToIdleChanged(oldTti, newTti);
            }
        }
    }

    private void fireTtlChanged(long oldTtl, long newTtl) {
        if (oldTtl != newTtl) {
            for (CacheConfigurationListener l : this.listeners) {
                l.timeToLiveChanged(oldTtl, newTtl);
            }
        }
    }

    private void fireLoggingEnabledChanged(boolean oldValue, boolean newValue) {
        if (oldValue != newValue) {
            for (CacheConfigurationListener l : this.listeners) {
                l.loggingEnabledChanged(oldValue, newValue);
            }
        }
    }

    private void fireDiskCapacityChanged(int oldCapacity, int newCapacity) {
        if (oldCapacity != newCapacity) {
            for (CacheConfigurationListener l : this.listeners) {
                l.diskCapacityChanged(oldCapacity, newCapacity);
            }
        }
    }

    private void fireMemoryCapacityChanged(int oldCapacity, int newCapacity) {
        if (oldCapacity != newCapacity) {
            for (CacheConfigurationListener l : this.listeners) {
                l.memoryCapacityChanged(oldCapacity, newCapacity);
            }
        }
    }

    private void checkDynamicChange() {
        if (this.frozen) {
            throw new CacheException("Dynamic configuration changes are disabled for this cache");
        }
    }

    public void internalSetTimeToIdle(long timeToIdle) {
        this.timeToIdleSeconds = timeToIdle;
    }

    public void internalSetTimeToLive(long timeToLive) {
        this.timeToLiveSeconds = timeToLive;
    }

    public void internalSetMemCapacity(int capacity) {
        this.maxElementsInMemory = capacity;
    }

    public void internalSetDiskCapacity(int capacity) {
        this.maxElementsOnDisk = capacity;
    }

    public void internalSetCoherent(boolean coherent) {
        if (this.isTerracottaClustered()) {
            this.getTerracottaConfiguration().setCoherent(coherent);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransactionalMode {
        OFF(false),
        XA(true);

        private final boolean transactional;

        private TransactionalMode(boolean transactional) {
            this.transactional = transactional;
        }

        public boolean isTransactional() {
            return this.transactional;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CacheLoaderFactoryConfiguration
    extends FactoryConfiguration<CacheLoaderFactoryConfiguration> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CacheExceptionHandlerFactoryConfiguration
    extends FactoryConfiguration<CacheExceptionHandlerFactoryConfiguration> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class BootstrapCacheLoaderFactoryConfiguration
    extends FactoryConfiguration<BootstrapCacheLoaderFactoryConfiguration> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CacheExtensionFactoryConfiguration
    extends FactoryConfiguration<CacheExtensionFactoryConfiguration> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class CacheEventListenerFactoryConfiguration
    extends FactoryConfiguration<CacheEventListenerFactoryConfiguration> {
    }
}

