/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.event;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.CacheReplicator;
import net.sf.ehcache.event.CacheEventListener;

public class RegisteredEventListeners {
    private final Set<CacheEventListener> cacheEventListeners = new CopyOnWriteArraySet<CacheEventListener>();
    private final Ehcache cache;
    private AtomicLong elementsRemovedCounter = new AtomicLong(0L);
    private AtomicLong elementsPutCounter = new AtomicLong(0L);
    private AtomicLong elementsUpdatedCounter = new AtomicLong(0L);
    private AtomicLong elementsExpiredCounter = new AtomicLong(0L);
    private AtomicLong elementsEvictedCounter = new AtomicLong(0L);
    private AtomicLong elementsRemoveAllCounter = new AtomicLong(0L);

    public RegisteredEventListeners(Ehcache cache) {
        this.cache = cache;
    }

    public final void notifyElementRemoved(Element element, boolean remoteEvent) throws CacheException {
        this.elementsRemovedCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementRemoved(this.cache, element);
            }
        }
    }

    public final void notifyElementPut(Element element, boolean remoteEvent) throws CacheException {
        this.elementsPutCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementPut(this.cache, element);
            }
        }
    }

    public final void notifyElementUpdated(Element element, boolean remoteEvent) {
        this.elementsUpdatedCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementUpdated(this.cache, element);
            }
        }
    }

    public final void notifyElementExpiry(Element element, boolean remoteEvent) {
        this.elementsExpiredCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementExpired(this.cache, element);
            }
        }
    }

    public final boolean hasCacheEventListeners() {
        return this.cacheEventListeners.size() > 0;
    }

    public void notifyElementEvicted(Element element, boolean remoteEvent) {
        this.elementsEvictedCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyElementEvicted(this.cache, element);
            }
        }
    }

    public void notifyRemoveAll(boolean remoteEvent) {
        this.elementsRemoveAllCounter.incrementAndGet();
        if (this.hasCacheEventListeners()) {
            for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
                if (RegisteredEventListeners.isCircularNotification(remoteEvent, cacheEventListener)) continue;
                cacheEventListener.notifyRemoveAll(this.cache);
            }
        }
    }

    private static boolean isCircularNotification(boolean remoteEvent, CacheEventListener cacheEventListener) {
        return remoteEvent && cacheEventListener instanceof CacheReplicator;
    }

    public final boolean registerListener(CacheEventListener cacheEventListener) {
        if (cacheEventListener == null) {
            return false;
        }
        return this.cacheEventListeners.add(cacheEventListener);
    }

    public final boolean unregisterListener(CacheEventListener cacheEventListener) {
        return this.cacheEventListeners.remove(cacheEventListener);
    }

    public final Set getCacheEventListeners() {
        return this.cacheEventListeners;
    }

    public final void dispose() {
        for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
            cacheEventListener.dispose();
        }
        this.cacheEventListeners.clear();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(" cacheEventListeners: ");
        for (CacheEventListener cacheEventListener : this.cacheEventListeners) {
            sb.append(cacheEventListener.getClass().getName()).append(" ");
        }
        return sb.toString();
    }

    public void clearCounters() {
        this.elementsRemovedCounter.set(0L);
        this.elementsPutCounter.set(0L);
        this.elementsUpdatedCounter.set(0L);
        this.elementsExpiredCounter.set(0L);
        this.elementsEvictedCounter.set(0L);
        this.elementsRemoveAllCounter.set(0L);
    }

    public long getElementsRemovedCounter() {
        return this.elementsRemovedCounter.get();
    }

    public long getElementsPutCounter() {
        return this.elementsPutCounter.get();
    }

    public long getElementsUpdatedCounter() {
        return this.elementsUpdatedCounter.get();
    }

    public long getElementsExpiredCounter() {
        return this.elementsExpiredCounter.get();
    }

    public long getElementsEvictedCounter() {
        return this.elementsEvictedCounter.get();
    }

    public long getElementsRemoveAllCounter() {
        return this.elementsRemoveAllCounter.get();
    }
}

