/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.management.sampled;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.hibernate.management.impl.BaseEmitterBean;
import net.sf.ehcache.management.sampled.SampledCacheMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampledCache
extends BaseEmitterBean
implements SampledCacheMBean {
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;
    private final Ehcache cache;
    private final String immutableCacheName;

    public SampledCache(Ehcache cache) throws NotCompliantMBeanException {
        super(SampledCacheMBean.class);
        this.cache = cache;
        this.immutableCacheName = cache.getName();
    }

    String getImmutableCacheName() {
        return this.immutableCacheName;
    }

    @Override
    public boolean isEnabled() {
        return !this.cache.isDisabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.cache.setDisabled(!enabled);
        this.sendNotification("CacheEnabled", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isCoherent() {
        return this.cache.isCoherent();
    }

    @Override
    public void setCoherent(boolean coherent) {
        this.cache.setCoherent(coherent);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public void flush() {
        this.cache.flush();
        this.sendNotification("CacheFlushed", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public String getCacheName() {
        return this.cache.getName();
    }

    @Override
    public String getStatus() {
        return this.cache.getStatus().toString();
    }

    @Override
    public void removeAll() {
        this.cache.removeAll();
        this.sendNotification("CacheCleared", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public long getAverageGetTimeMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getAverageGetTimeMostRecentSample();
    }

    @Override
    public long getCacheElementEvictedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementEvictedMostRecentSample();
    }

    @Override
    public long getCacheElementExpiredMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementExpiredMostRecentSample();
    }

    @Override
    public long getCacheElementPutMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementPutMostRecentSample();
    }

    @Override
    public long getCacheElementRemovedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementRemovedMostRecentSample();
    }

    @Override
    public long getCacheElementUpdatedMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheElementUpdatedMostRecentSample();
    }

    @Override
    public long getCacheHitInMemoryMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitInMemoryMostRecentSample();
    }

    @Override
    public long getCacheHitMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitMostRecentSample();
    }

    @Override
    public long getCacheHitOnDiskMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheHitOnDiskMostRecentSample();
    }

    @Override
    public long getCacheMissExpiredMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissExpiredMostRecentSample();
    }

    @Override
    public long getCacheMissMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissMostRecentSample();
    }

    @Override
    public long getCacheMissNotFoundMostRecentSample() {
        return this.cache.getSampledCacheStatistics().getCacheMissNotFoundMostRecentSample();
    }

    @Override
    public int getStatisticsAccuracy() {
        return this.cache.getSampledCacheStatistics().getStatisticsAccuracy();
    }

    @Override
    public String getStatisticsAccuracyDescription() {
        return this.cache.getSampledCacheStatistics().getStatisticsAccuracyDescription();
    }

    @Override
    public void clearStatistics() {
        this.cache.clearStatistics();
        this.sendNotification("CacheStatisticsReset", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.cache.isStatisticsEnabled();
    }

    @Override
    public boolean isSampledStatisticsEnabled() {
        return this.cache.getSampledCacheStatistics().isSampledStatisticsEnabled();
    }

    @Override
    public boolean isTerracottaClustered() {
        return this.cache.getCacheConfiguration().isTerracottaClustered();
    }

    @Override
    public void enableStatistics() {
        this.cache.setStatisticsEnabled(true);
        this.sendNotification("CacheStatisticsEnabled", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public void disableStatistics() {
        this.cache.setStatisticsEnabled(false);
        this.sendNotification("CacheStatisticsEnabled", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public void enableSampledStatistics() {
        this.cache.setSampledStatisticsEnabled(true);
        this.sendNotification("CacheStatisticsEnabled", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public void disableSampledStatistics() {
        this.cache.setSampledStatisticsEnabled(false);
        this.sendNotification("CacheStatisticsEnabled", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public float getAverageGetTimeMillis() {
        return this.cache.getLiveCacheStatistics().getAverageGetTimeMillis();
    }

    @Override
    public long getMaxGetTimeMillis() {
        return this.cache.getLiveCacheStatistics().getMaxGetTimeMillis();
    }

    @Override
    public long getMinGetTimeMillis() {
        return this.cache.getLiveCacheStatistics().getMinGetTimeMillis();
    }

    @Override
    public long getCacheHitCount() {
        return this.cache.getLiveCacheStatistics().getCacheHitCount();
    }

    @Override
    public long getCacheMissCount() {
        return this.cache.getLiveCacheStatistics().getCacheMissCount();
    }

    @Override
    public long getCacheMissCountExpired() {
        return this.cache.getLiveCacheStatistics().getCacheMissCountExpired();
    }

    @Override
    public long getConfigDiskExpiryThreadIntervalSeconds() {
        return this.cache.getCacheConfiguration().getDiskExpiryThreadIntervalSeconds();
    }

    @Override
    public void setConfigDiskExpiryThreadIntervalSeconds(long seconds) {
        this.cache.getCacheConfiguration().setDiskExpiryThreadIntervalSeconds(seconds);
    }

    @Override
    public int getConfigMaxElementsInMemory() {
        return this.cache.getCacheConfiguration().getMaxElementsInMemory();
    }

    @Override
    public void setConfigMaxElementsInMemory(int maxElements) {
        this.cache.getCacheConfiguration().setMaxElementsInMemory(maxElements);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public int getConfigMaxElementsOnDisk() {
        return this.cache.getCacheConfiguration().getMaxElementsOnDisk();
    }

    @Override
    public void setConfigMaxElementsOnDisk(int maxElements) {
        this.cache.getCacheConfiguration().setMaxElementsOnDisk(maxElements);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public String getConfigMemoryStoreEvictionPolicy() {
        return this.cache.getCacheConfiguration().getMemoryStoreEvictionPolicy().toString();
    }

    @Override
    public void setConfigMemoryStoreEvictionPolicy(String evictionPolicy) {
        this.cache.getCacheConfiguration().setMemoryStoreEvictionPolicy(evictionPolicy);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public long getConfigTimeToIdleSeconds() {
        return this.cache.getCacheConfiguration().getTimeToIdleSeconds();
    }

    @Override
    public void setConfigTimeToIdleSeconds(long tti) {
        this.cache.getCacheConfiguration().setTimeToIdleSeconds(tti);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public long getConfigTimeToLiveSeconds() {
        return this.cache.getCacheConfiguration().getTimeToLiveSeconds();
    }

    @Override
    public void setConfigTimeToLiveSeconds(long ttl) {
        this.cache.getCacheConfiguration().setTimeToLiveSeconds(ttl);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isConfigDiskPersistent() {
        return this.cache.getCacheConfiguration().isDiskPersistent();
    }

    @Override
    public void setConfigDiskPersistent(boolean diskPersistent) {
        this.cache.getCacheConfiguration().setDiskPersistent(diskPersistent);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isConfigEternal() {
        return this.cache.getCacheConfiguration().isEternal();
    }

    @Override
    public void setConfigEternal(boolean eternal) {
        this.cache.getCacheConfiguration().setEternal(eternal);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isConfigOverflowToDisk() {
        return this.cache.getCacheConfiguration().isOverflowToDisk();
    }

    @Override
    public void setConfigOverflowToDisk(boolean overflowToDisk) {
        this.cache.getCacheConfiguration().setOverflowToDisk(overflowToDisk);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public boolean isConfigLoggingEnabled() {
        return this.cache.getCacheConfiguration().isLoggingEnabled();
    }

    @Override
    public void setConfigLoggingEnabled(boolean enabled) {
        this.cache.getCacheConfiguration().setLoggingEnabled(enabled);
        this.sendNotification("CacheChanged", this.getCacheAttributes(), this.getImmutableCacheName());
    }

    @Override
    public long getEvictedCount() {
        return this.cache.getLiveCacheStatistics().getEvictedCount();
    }

    @Override
    public long getExpiredCount() {
        return this.cache.getLiveCacheStatistics().getExpiredCount();
    }

    @Override
    public long getInMemoryHitCount() {
        return this.cache.getLiveCacheStatistics().getInMemoryHitCount();
    }

    @Override
    public long getInMemorySize() {
        return this.cache.getLiveCacheStatistics().getInMemorySize();
    }

    @Override
    public long getOnDiskHitCount() {
        return this.cache.getLiveCacheStatistics().getOnDiskHitCount();
    }

    @Override
    public long getOnDiskSize() {
        return this.cache.getLiveCacheStatistics().getOnDiskSize();
    }

    @Override
    public long getPutCount() {
        return this.cache.getLiveCacheStatistics().getPutCount();
    }

    @Override
    public long getRemovedCount() {
        return this.cache.getLiveCacheStatistics().getRemovedCount();
    }

    @Override
    public long getSize() {
        return this.cache.getLiveCacheStatistics().getSize();
    }

    @Override
    public long getUpdateCount() {
        return this.cache.getLiveCacheStatistics().getUpdateCount();
    }

    public Map<String, Object> getCacheAttributes() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("Enabled", this.isEnabled());
        result.put("LoggingEnabled", this.isConfigLoggingEnabled());
        result.put("TimeToIdleSeconds", this.getConfigTimeToIdleSeconds());
        result.put("TimeToLiveSeconds", this.getConfigTimeToLiveSeconds());
        result.put("MaxElementsInMemory", this.getConfigMaxElementsInMemory());
        result.put("MaxElementsOnDisk", this.getConfigMaxElementsOnDisk());
        result.put("DiskPersistent", this.isConfigDiskPersistent());
        result.put("Eternal", this.isConfigEternal());
        result.put("OverflowToDisk", this.isConfigOverflowToDisk());
        result.put("DiskExpiryThreadIntervalSeconds", this.getConfigDiskExpiryThreadIntervalSeconds());
        result.put("MemoryStoreEvictionPolicy", this.getConfigMemoryStoreEvictionPolicy());
        result.put("Coherent", this.isCoherent());
        return result;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return NOTIFICATION_INFO;
    }

    @Override
    public void dispose() {
    }

    static {
        String[] notifTypes = new String[]{"CacheEnabled", "CacheChanged", "CacheFlushed", "CacheStatisticsEnabled", "CacheStatisticsReset"};
        String name = Notification.class.getName();
        String description = "Ehcache SampledCache Event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "Ehcache SampledCache Event")};
    }
}

