/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.CacheConfigurationListener;
import net.sf.ehcache.store.AbstractPolicy;
import net.sf.ehcache.store.FifoPolicy;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.LruPolicy;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.chm.SelectableConcurrentHashMap;
import net.sf.ehcache.writer.CacheWriterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryStore
implements Store,
CacheConfigurationListener {
    protected static final int TOO_LARGE_TO_EFFICIENTLY_ITERATE = 5;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int CONCURRENCY_LEVEL = 100;
    private static final int MAX_EVICTION_RATIO = 5;
    private static final Logger LOG = LoggerFactory.getLogger((String)MemoryStore.class.getName());
    protected Ehcache cache;
    protected volatile boolean useKeySample;
    protected SelectableConcurrentHashMap map;
    protected final Store diskStore;
    protected volatile int maximumSize;
    protected volatile Status status = Status.STATUS_UNINITIALISED;
    protected volatile Policy policy;

    protected MemoryStore(Ehcache cache, Store diskStore) {
        this.cache = cache;
        this.maximumSize = cache.getCacheConfiguration().getMaxElementsInMemory();
        this.diskStore = diskStore;
        this.policy = this.determineEvictionPolicy();
        int initialCapacity = MemoryStore.getInitialCapacityForLoadFactor(this.maximumSize, 0.75f);
        this.map = new SelectableConcurrentHashMap(initialCapacity, 0.75f, 100);
        this.useKeySample = this.maximumSize > 5;
        this.status = Status.STATUS_ALIVE;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initialized " + this.getClass().getName() + " for " + cache.getName());
        }
    }

    static int getInitialCapacityForLoadFactor(int maximumSizeGoal, float loadFactor) {
        double actualMaximum = Math.ceil((float)maximumSizeGoal / loadFactor);
        return Math.max(0, actualMaximum >= 2.147483647E9 ? Integer.MAX_VALUE : (int)actualMaximum);
    }

    public static MemoryStore create(Ehcache cache, Store diskStore) {
        MemoryStore memoryStore = new MemoryStore(cache, diskStore);
        cache.getCacheConfiguration().addConfigurationListener(memoryStore);
        return memoryStore;
    }

    public final void put(Element element) throws CacheException {
        this.putInternal(element, null);
    }

    public final void putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        this.putInternal(element, writerManager);
    }

    private synchronized void putInternal(Element element, CacheWriterManager writerManager) throws CacheException {
        if (element != null) {
            this.map.put(element.getObjectKey(), element);
            if (writerManager != null) {
                writerManager.put(element);
            }
            this.doPut(element);
        }
    }

    public final Element get(Object key) {
        if (key == null) {
            return null;
        }
        return (Element)this.map.get(key);
    }

    public final Element getQuiet(Object key) {
        return this.get(key);
    }

    public final Element remove(Object key) {
        return this.removeInternal(key, null);
    }

    public final Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        return this.removeInternal(key, writerManager);
    }

    private synchronized Element removeInternal(Object key, CacheWriterManager writerManager) throws CacheException {
        if (key == null) {
            return null;
        }
        Element element = (Element)this.map.remove(key);
        if (writerManager != null) {
            writerManager.remove(key);
        }
        if (element != null) {
            return element;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.cache.getName() + "Cache: Cannot remove entry as key " + key + " was not found");
        }
        return null;
    }

    public final boolean bufferFull() {
        return false;
    }

    public void expireElements() {
    }

    protected final Policy determineEvictionPolicy() {
        MemoryStoreEvictionPolicy policySelection = this.cache.getCacheConfiguration().getMemoryStoreEvictionPolicy();
        if (policySelection.equals(MemoryStoreEvictionPolicy.LRU)) {
            return new LruPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.FIFO)) {
            return new FifoPolicy();
        }
        if (policySelection.equals(MemoryStoreEvictionPolicy.LFU)) {
            return new LfuPolicy();
        }
        throw new IllegalArgumentException(policySelection + " isn't a valid eviction policy");
    }

    public final void removeAll() throws CacheException {
        this.clear();
    }

    protected final void clear() {
        this.map.clear();
    }

    public final synchronized void dispose() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            return;
        }
        this.status = Status.STATUS_SHUTDOWN;
        this.flush();
        this.cache = null;
        this.map = null;
    }

    public final void flush() {
        if (this.cache.getCacheConfiguration().isDiskPersistent()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(this.cache.getName() + " is persistent. Spooling " + this.map.size() + " elements to the disk store.");
            }
            this.spoolAllToDisk();
        }
        if (this.cache.getCacheConfiguration().isClearOnFlush()) {
            this.clear();
        }
    }

    protected final void spoolAllToDisk() {
        boolean clearOnFlush = this.cache.getCacheConfiguration().isClearOnFlush();
        for (Object key : this.getKeyArray()) {
            Element element = (Element)this.map.get(key);
            if (element == null) continue;
            if (!element.isSerializable()) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Object with key " + element.getObjectKey() + " is not Serializable and is not being overflowed to disk.");
                continue;
            }
            this.spoolToDisk(element);
            if (!clearOnFlush) continue;
            this.remove(key);
        }
    }

    protected void spoolToDisk(Element element) {
        this.diskStore.put(element);
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.cache.getName() + "Cache: spool to disk done for: " + element.getObjectKey());
        }
    }

    public final Object[] getKeyArray() {
        return this.map.keySet().toArray();
    }

    public final int getSize() {
        return this.map.size();
    }

    public final int getTerracottaClusteredSize() {
        return 0;
    }

    public final boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public final long getSizeInBytes() throws CacheException {
        long sizeInBytes = 0L;
        for (Element o : this.map.values()) {
            Element element = o;
            if (element == null) continue;
            sizeInBytes += element.getSerializedSize();
        }
        return sizeInBytes;
    }

    protected final void evict(Element element) throws CacheException {
        boolean spooled = false;
        if (this.cache.getCacheConfiguration().isOverflowToDisk()) {
            if (!element.isSerializable()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Object with key " + element.getObjectKey() + " is not Serializable and cannot be overflowed to disk");
                }
            } else {
                this.spoolToDisk(element);
                spooled = true;
            }
        }
        if (!spooled) {
            this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
        }
    }

    protected final void notifyExpiry(Element element) {
        this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
    }

    protected final boolean isFull() {
        return this.map.size() > this.maximumSize;
    }

    Map getBackingMap() {
        return this.map;
    }

    protected void doPut(Element elementJustAdded) {
        int evict = Math.min(this.map.size() - this.maximumSize, 5);
        for (int i = 0; i < evict; ++i) {
            this.removeElementChosenByEvictionPolicy(elementJustAdded);
        }
    }

    protected void removeElementChosenByEvictionPolicy(Element elementJustAdded) {
        LOG.debug("Cache is full. Removing element ...");
        Element element = this.findEvictionCandidate(elementJustAdded);
        if (element == null) {
            LOG.debug("Eviction selection miss. Selected element is null");
            return;
        }
        if (element.isExpired()) {
            this.remove(element.getObjectKey());
            this.notifyExpiry(element);
            return;
        }
        this.evict(element);
        this.remove(element.getObjectKey());
    }

    protected final Element findEvictionCandidate(Element elementJustAdded) {
        Element element = null;
        if (this.useKeySample) {
            Element[] elements = this.sampleElements();
            element = this.policy.selectedBasedOnPolicy(elements, elementJustAdded);
            if (element != null) {
                return element;
            }
            return null;
        }
        Element[] elements = this.sampleElements(this.map.size());
        return this.policy.selectedBasedOnPolicy(elements, elementJustAdded);
    }

    protected Element[] sampleElements() {
        int size = AbstractPolicy.calculateSampleSize(this.maximumSize);
        return this.map.getRandomValues(size);
    }

    protected Element[] sampleElements(int size) {
        int[] offsets = LfuPolicy.generateRandomSample(size);
        Element[] elements = new Element[offsets.length];
        Iterator iterator = this.map.values().iterator();
        for (int i = 0; i < offsets.length; ++i) {
            for (int j = 0; j < offsets[i]; ++j) {
                try {
                    iterator.next();
                    continue;
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
            try {
                elements[i] = (Element)iterator.next();
                continue;
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        return elements;
    }

    public Policy getEvictionPolicy() {
        return this.policy;
    }

    public void setEvictionPolicy(Policy policy) {
        this.policy = policy;
    }

    public Object getInternalContext() {
        return null;
    }

    public final Status getStatus() {
        return this.status;
    }

    public boolean isCacheCoherent() {
        return false;
    }

    public void timeToIdleChanged(long oldTti, long newTti) {
    }

    public void timeToLiveChanged(long oldTtl, long newTtl) {
    }

    public void diskCapacityChanged(int oldCapacity, int newCapacity) {
    }

    public void loggingEnabledChanged(boolean oldValue, boolean newValue) {
    }

    public void memoryCapacityChanged(int oldCapacity, int newCapacity) {
        this.useKeySample = newCapacity > 5;
        this.maximumSize = newCapacity;
    }

    public void registered(CacheConfiguration config) {
    }

    public void deregistered(CacheConfiguration config) {
    }

    public void setCoherent(boolean coherent) {
        throw new UnsupportedOperationException();
    }

    public void waitUntilCoherent() {
        throw new UnsupportedOperationException();
    }
}

