/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.StoreExpireAllElementsCommand;
import net.sf.ehcache.transaction.StorePutCommand;
import net.sf.ehcache.transaction.StoreRemoveAllCommand;
import net.sf.ehcache.transaction.StoreRemoveCommand;
import net.sf.ehcache.transaction.TransactionContext;
import net.sf.ehcache.transaction.xa.EhcacheXAResource;
import net.sf.ehcache.writer.CacheWriterManager;

public class XATransactionalStore
implements Store {
    private final Store underlyingStore;
    private final EhcacheXAResource xaResource;

    public XATransactionalStore(EhcacheXAResource xaResource) {
        this.xaResource = xaResource;
        this.underlyingStore = xaResource.getStore();
    }

    public void put(Element element) throws CacheException {
        TransactionContext context = this.getOrCreateTransactionContext();
        this.underlyingStore.get(element.getKey());
        context.addCommand(new StorePutCommand(element), element);
    }

    public void putWithWriter(Element element, CacheWriterManager writerManager) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public Element get(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        Element element = context.get(key);
        if (element == null && !context.isRemoved(key)) {
            element = this.xaResource.get(key);
        }
        return element;
    }

    public Element getQuiet(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        Element element = context.get(key);
        if (element == null && !context.isRemoved(key)) {
            element = this.xaResource.getQuiet(key);
        }
        return element;
    }

    public Object[] getKeyArray() {
        TransactionContext context = this.getOrCreateTransactionContext();
        HashSet<Object> keys = new HashSet<Object>(Arrays.asList(this.underlyingStore.getKeyArray()));
        keys.addAll(context.getAddedKeys());
        keys.removeAll(context.getRemovedKeys());
        return keys.toArray();
    }

    public Element remove(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        Element element = context.get(key);
        if (element == null && !context.isRemoved(key)) {
            element = this.xaResource.getQuiet(key);
        }
        if (element != null) {
            context.addCommand(new StoreRemoveCommand(key), element);
        }
        return element;
    }

    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        throw new UnsupportedOperationException();
    }

    public void removeAll() throws CacheException {
        this.getOrCreateTransactionContext().addCommand(new StoreRemoveAllCommand(), null);
    }

    public void dispose() {
        this.underlyingStore.dispose();
    }

    public int getSize() {
        TransactionContext context = this.getOrCreateTransactionContext();
        int size = this.underlyingStore.getSize();
        return size + context.getSizeModifier();
    }

    public int getTerracottaClusteredSize() {
        TransactionContext context = this.getOrCreateTransactionContext();
        return this.underlyingStore.getTerracottaClusteredSize() + context.getSizeModifier();
    }

    public long getSizeInBytes() {
        this.getOrCreateTransactionContext();
        return this.underlyingStore.getSizeInBytes();
    }

    public Status getStatus() {
        return this.underlyingStore.getStatus();
    }

    public boolean containsKey(Object key) {
        TransactionContext context = this.getOrCreateTransactionContext();
        return !context.isRemoved(key) && (context.getAddedKeys().contains(key) || this.underlyingStore.containsKey(key));
    }

    public void expireElements() {
        this.getOrCreateTransactionContext().addCommand(new StoreExpireAllElementsCommand(), null);
    }

    public void flush() throws IOException {
        this.underlyingStore.flush();
    }

    public boolean bufferFull() {
        return this.underlyingStore.bufferFull();
    }

    public Policy getEvictionPolicy() {
        return this.underlyingStore.getEvictionPolicy();
    }

    public void setEvictionPolicy(Policy policy) {
        this.underlyingStore.setEvictionPolicy(policy);
    }

    public Object getInternalContext() {
        return this.underlyingStore.getInternalContext();
    }

    public boolean isCacheCoherent() {
        return this.underlyingStore.isCacheCoherent();
    }

    public void setCoherent(boolean coherent) throws UnsupportedOperationException {
        this.underlyingStore.setCoherent(coherent);
    }

    public void waitUntilCoherent() throws UnsupportedOperationException {
        this.underlyingStore.waitUntilCoherent();
    }

    private TransactionContext getOrCreateTransactionContext() {
        TransactionContext context;
        try {
            context = this.xaResource.getOrCreateTransactionContext();
        }
        catch (SystemException e) {
            throw new CacheException(e);
        }
        catch (RollbackException e) {
            throw new CacheException(e);
        }
        return context;
    }
}

