/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction.xa;

import net.sf.ehcache.store.Store;
import net.sf.ehcache.transaction.Command;
import net.sf.ehcache.transaction.StoreWriteCommand;
import net.sf.ehcache.transaction.xa.VersionAwareCommand;

public class VersionAwareWrapper
implements Command,
VersionAwareCommand {
    private final Command command;
    private final long version;
    private final Object key;

    public VersionAwareWrapper(Command command) {
        this.command = command;
        this.version = -1L;
        this.key = null;
    }

    public VersionAwareWrapper(Command command, long version, Object key) {
        this.command = command;
        this.version = version;
        this.key = key;
    }

    public boolean isWriteCommand() {
        return this.command instanceof StoreWriteCommand;
    }

    public boolean execute(Store store) {
        return this.command.execute(store);
    }

    public boolean isPut(Object key) {
        return this.command.isPut(key);
    }

    public boolean isRemove(Object key) {
        return this.command.isRemove(key);
    }

    public boolean isVersionAware() {
        return this.key != null;
    }

    public long getVersion() {
        return this.version;
    }

    public Object getKey() {
        return this.key;
    }

    public String getCommandName() {
        return this.command.getCommandName();
    }
}

