/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.writer.writebehind.operations;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.writer.CacheWriter;
import net.sf.ehcache.writer.writebehind.operations.BatchOperation;
import net.sf.ehcache.writer.writebehind.operations.DeleteAllOperation;
import net.sf.ehcache.writer.writebehind.operations.SingleOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteOperation
implements SingleOperation {
    private final Object key;
    private final long creationTime;

    public DeleteOperation(Object key) {
        this(key, System.currentTimeMillis());
    }

    public DeleteOperation(Object key, long creationTime) {
        this.key = key;
        this.creationTime = creationTime;
    }

    @Override
    public void performSingleOperation(CacheWriter cacheWriter) {
        cacheWriter.delete(this.key);
    }

    @Override
    public BatchOperation createBatchOperation(List<SingleOperation> operations) {
        ArrayList<Object> keys = new ArrayList<Object>();
        for (SingleOperation operation : operations) {
            keys.add(((DeleteOperation)operation).key);
        }
        return new DeleteAllOperation(keys);
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }
}

