/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution.jgroups;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.distribution.jgroups.BootstrapRequest;
import net.sf.ehcache.distribution.jgroups.BootstrapRequestMap;
import net.sf.ehcache.distribution.jgroups.JGroupEventMessage;
import net.sf.ehcache.distribution.jgroups.JGroupsCachePeer;
import net.sf.ehcache.distribution.jgroups.ThreadNamingRunnable;
import net.sf.ehcache.util.NamedThreadFactory;
import org.jgroups.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JGroupsBootstrapManager {
    private static final Logger LOG = LoggerFactory.getLogger((String)JGroupsBootstrapManager.class.getName());
    private static final int BOOTSTRAP_CORE_THREADS = 0;
    private static final int BOOTSTRAP_MAX_THREADS = 50;
    private static final int BOOTSTRAP_THREAD_TIMEOUT = 60;
    private static final long BOOTSTRAP_REQUEST_CLEANUP_INTERVAL = 60000L;
    private static final Random BOOTSTRAP_PEER_CHOOSER = new Random();
    private static final long BOOTSTRAP_RESPONSE_TIMEOUT = 30000L;
    private static final long BOOTSTRAP_RESPONSE_TRIES = 10L;
    private static final long BOOTSTRAP_RESPONSE_MAX_TIMEOUT = 300000L;
    private static final int BOOTSTRAP_CHUNK_SIZE = 100;
    private volatile boolean alive = true;
    private final AtomicBoolean referenceTimerScheduled = new AtomicBoolean(false);
    private final BootstrapRequestMap bootstrapRequests = new BootstrapRequestMap();
    private Timer bootstrapRequestCleanupTimer;
    private final ThreadPoolExecutor bootstrapThreadPool;
    private final String clusterName;
    private final JGroupsCachePeer cachePeer;
    private final CacheManager cacheManager;

    public JGroupsBootstrapManager(String clusterName, JGroupsCachePeer cachePeer, CacheManager cacheManager) {
        this.clusterName = clusterName;
        this.cachePeer = cachePeer;
        this.cacheManager = cacheManager;
        this.bootstrapThreadPool = new ThreadPoolExecutor(0, 50, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), (ThreadFactory)new NamedThreadFactory(clusterName + " Bootstrap"), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public boolean waitForCompleteBootstrap(long duration) {
        return this.bootstrapRequests.waitForMapSize(0, duration);
    }

    public void dispose() {
        this.alive = false;
        if (!this.bootstrapRequests.isEmpty()) {
            LOG.debug("Waiting for BootstrapRequests to complete");
            this.bootstrapRequests.waitForMapSize(0, 30000L);
            if (!this.bootstrapRequests.isEmpty()) {
                LOG.warn("Shutting down bootstrap manager while there are still {} bootstrap requests pending", (Object)this.bootstrapRequests.size());
            }
        }
        this.bootstrapThreadPool.shutdown();
        try {
            if (!this.bootstrapThreadPool.awaitTermination(30000L, TimeUnit.MILLISECONDS)) {
                LOG.warn("Not all bootstrap threads shutdown within {}ms window", (Object)30000L);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for bootstrap threads to complete", (Throwable)e);
        }
        if (this.bootstrapRequestCleanupTimer != null) {
            this.bootstrapRequestCleanupTimer.cancel();
            this.bootstrapRequestCleanupTimer.purge();
        }
    }

    public void setBootstrapThreads(int bootstrapThreads) {
        this.bootstrapThreadPool.setMaximumPoolSize(bootstrapThreads);
    }

    public boolean isPendingBootstrapRequests() {
        return !this.bootstrapRequests.isEmpty();
    }

    public void handleBootstrapRequest(BootstrapRequest bootstrapRequest) {
        Ehcache cache;
        String cacheName;
        BootstrapRequest oldRequest;
        if (!this.alive) {
            LOG.warn("dispose has been called, no new BootstrapRequests will be handled, ignoring: {}", (Object)bootstrapRequest);
            return;
        }
        if (!this.referenceTimerScheduled.getAndSet(true)) {
            this.bootstrapRequestCleanupTimer = new Timer(this.clusterName + " Bootstrap Request Cleanup Thread", true);
            this.bootstrapRequestCleanupTimer.schedule((TimerTask)new BootstrapRequestCleanerTimerTask(), 60000L, 60000L);
            LOG.debug("Scheduled BootstrapRequest Reference cleanup timer with {}ms period", (Object)60000L);
        }
        if ((oldRequest = this.bootstrapRequests.put(cacheName = (cache = bootstrapRequest.getCache()).getName(), bootstrapRequest)) != null) {
            LOG.warn("There is already a BootstrapRequest registered for {} with value {}, it has been replaced with the current request.", (Object)cacheName, (Object)oldRequest);
        }
        LOG.debug("Registered {}", (Object)bootstrapRequest);
        BootstrapRequestRunnable bootstrapRequestRunnable = new BootstrapRequestRunnable(bootstrapRequest);
        Future<?> future = this.bootstrapThreadPool.submit(bootstrapRequestRunnable);
        if (!bootstrapRequest.isAsynchronous()) {
            LOG.debug("Waiting up to {}ms for BootstrapRequest of {} to complete", (Object)300000L, (Object)cacheName);
            try {
                future.get(300000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while waiting for bootstrap of " + cacheName + " to complete", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.warn("Exception thrown while bootstrapping " + cacheName, (Throwable)e);
            }
            catch (TimeoutException e) {
                LOG.warn("Timed out waiting 300000ms for bootstrap of " + cacheName + " to complete", (Throwable)e);
            }
        }
    }

    public void sendBootstrapResponse(JGroupEventMessage message) {
        if (!this.alive) {
            LOG.warn("dispose has been called, no new BootstrapResponses will be handled");
            return;
        }
        BootstrapResponseRunnable bootstrapResponseRunnable = new BootstrapResponseRunnable(message);
        this.bootstrapThreadPool.submit(bootstrapResponseRunnable);
    }

    public void handleBootstrapComplete(JGroupEventMessage message) {
        String cacheName = message.getCacheName();
        BootstrapRequest bootstrapRequestStatus = this.bootstrapRequests.get(cacheName);
        if (bootstrapRequestStatus != null) {
            bootstrapRequestStatus.boostrapComplete(BootstrapRequest.BootstrapStatus.COMPLETE);
        } else {
            LOG.warn("No BootstrapRequest registered for cache {}, the event will have no effect: {}", (Object)cacheName, (Object)message);
        }
    }

    public void handleBootstrapIncomplete(JGroupEventMessage message) {
        String cacheName = message.getCacheName();
        BootstrapRequest bootstrapRequestStatus = this.bootstrapRequests.get(cacheName);
        if (bootstrapRequestStatus != null) {
            bootstrapRequestStatus.boostrapComplete(BootstrapRequest.BootstrapStatus.INCOMPLETE);
        } else {
            LOG.warn("No BootstrapRequest registered for cache {}, the event will have no effect: {}", (Object)cacheName, (Object)message);
        }
    }

    public void handleBootstrapResponse(JGroupEventMessage message) {
        String cacheName = message.getCacheName();
        BootstrapRequest bootstrapRequestStatus = this.bootstrapRequests.get(cacheName);
        if (bootstrapRequestStatus != null) {
            Ehcache cache = bootstrapRequestStatus.getCache();
            cache.put(message.getElement(), true);
            bootstrapRequestStatus.countReplication();
        } else {
            LOG.warn("No BootstrapRequest registered for cache {}, the event will have no effect: {}", (Object)cacheName, (Object)message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BootstrapResponseRunnable
    extends ThreadNamingRunnable {
        private final JGroupEventMessage message;

        public BootstrapResponseRunnable(JGroupEventMessage message) {
            super(" - Response for " + message.getCacheName());
            this.message = message;
        }

        @Override
        public void runInternal() {
            List keys;
            Address requestAddress = (Address)this.message.getSerializableKey();
            String cacheName = this.message.getCacheName();
            Ehcache cache = JGroupsBootstrapManager.this.cacheManager.getEhcache(cacheName);
            if (cache == null) {
                LOG.warn("ignoring bootstrap request:   from {} for cache {} which does not exist on this memeber", (Object)requestAddress, (Object)cacheName);
                JGroupEventMessage bootstrapCompleteMessage = new JGroupEventMessage(13, null, null, cacheName);
                JGroupsBootstrapManager.this.cachePeer.send(requestAddress, Arrays.asList(bootstrapCompleteMessage));
                return;
            }
            LOG.debug("servicing bootstrap request: from {} for cache={}", (Object)requestAddress, (Object)cacheName);
            if (JGroupsBootstrapManager.this.bootstrapRequests.get(cacheName) != null) {
                LOG.debug("This group member is currently bootstrapping {} from another node and cannot respond to a bootstrap request for this cache. Notifying requester of incomplete bootstrap", (Object)cacheName);
                JGroupEventMessage bootstrapCompleteMessage = new JGroupEventMessage(13, null, null, cacheName);
                JGroupsBootstrapManager.this.cachePeer.send(requestAddress, Arrays.asList(bootstrapCompleteMessage));
            }
            if ((keys = cache.getKeys()) == null || keys.size() == 0) {
                LOG.debug("no keys to reply to {} to bootstrap cache {}", (Object)requestAddress, (Object)cacheName);
            } else {
                ArrayList<JGroupEventMessage> messageList = new ArrayList<JGroupEventMessage>(Math.min(keys.size(), 100));
                for (Object key : keys) {
                    Element element = cache.getQuiet(key);
                    if (element == null || element.isExpired()) continue;
                    JGroupEventMessage groupEventMessage = new JGroupEventMessage(11, (Serializable)key, element, cacheName);
                    messageList.add(groupEventMessage);
                    if (messageList.size() != 100) continue;
                    this.sendResponseChunk(cache, requestAddress, messageList);
                    messageList.clear();
                }
                if (messageList.size() > 0) {
                    this.sendResponseChunk(cache, requestAddress, messageList);
                }
            }
            JGroupEventMessage bootstrapCompleteMessage = new JGroupEventMessage(12, null, null, cacheName);
            JGroupsBootstrapManager.this.cachePeer.send(requestAddress, Arrays.asList(bootstrapCompleteMessage));
        }

        private void sendResponseChunk(Ehcache cache, Address requestAddress, List<JGroupEventMessage> events) {
            LOG.debug("reply {} elements to {} to bootstrap cache {}", new Object[]{events.size(), requestAddress, cache.getName()});
            JGroupsBootstrapManager.this.cachePeer.send(requestAddress, events);
        }

        public String toString() {
            return "BootstrapResponseRunnable [name=" + this.threadNameSuffix + ", message=" + (Object)((Object)this.message) + "]";
        }
    }

    private final class BootstrapRequestRunnable
    extends ThreadNamingRunnable {
        private final BootstrapRequest bootstrapRequest;

        public BootstrapRequestRunnable(BootstrapRequest bootstrapRequest) {
            super(" - Request for " + bootstrapRequest.getCache().getName());
            this.bootstrapRequest = bootstrapRequest;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runInternal() {
            Ehcache cache = this.bootstrapRequest.getCache();
            String cacheName = cache.getName();
            try {
                List<Address> addresses = JGroupsBootstrapManager.this.cachePeer.getOtherGroupMembers();
                if (addresses == null || addresses.size() == 0) {
                    LOG.info("There are no other nodes in the cluster to bootstrap {} from", (Object)cacheName);
                    return;
                }
                Address localAddress = JGroupsBootstrapManager.this.cachePeer.getLocalAddress();
                LOG.debug("Loading cache {} with local address {} from peers: {}", new Object[]{cacheName, localAddress, addresses});
                int replicationCount = 0;
                do {
                    this.bootstrapRequest.reset();
                    int randomPeerNumber = BOOTSTRAP_PEER_CHOOSER.nextInt(addresses.size());
                    Address address = addresses.remove(randomPeerNumber);
                    JGroupEventMessage event = new JGroupEventMessage(10, (Serializable)localAddress, null, cacheName);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Requesting bootstrap of {} from {}", (Object)cacheName, (Object)address);
                    }
                    JGroupsBootstrapManager.this.cachePeer.send(address, Arrays.asList(event));
                    this.waitForBootstrap(cacheName, address);
                    replicationCount = (int)((long)replicationCount + this.bootstrapRequest.getReplicationCount());
                } while (this.bootstrapRequest.getBootstrapStatus() != BootstrapRequest.BootstrapStatus.COMPLETE && addresses.size() > 0);
                if (BootstrapRequest.BootstrapStatus.COMPLETE == this.bootstrapRequest.getBootstrapStatus()) {
                    LOG.info("Bootstrap for cache {} is complete, loaded {} elements", (Object)cacheName, (Object)replicationCount);
                } else {
                    LOG.info("Bootstrap for cache {} ended with status {}, loaded {} elements", new Object[]{cacheName, this.bootstrapRequest.getBootstrapStatus(), replicationCount});
                }
            }
            finally {
                BootstrapRequest removedRequest = JGroupsBootstrapManager.this.bootstrapRequests.remove(cacheName);
                if (removedRequest == null) {
                    LOG.warn("No BootstrapRequest for {} to remove", (Object)cacheName);
                    return;
                }
                LOG.debug("Removed {}", (Object)removedRequest);
            }
        }

        protected void waitForBootstrap(String cacheName, Address address) {
            int waitTry = 1;
            while ((long)waitTry <= 10L) {
                try {
                    if (this.bootstrapRequest.waitForBoostrap(30000L, TimeUnit.MILLISECONDS)) {
                        return;
                    }
                    LOG.debug("Bootstrap of {} did not complete in {}ms, will wait {} more times.", new Object[]{cacheName, 30000L * (long)waitTry, 10L - (long)waitTry});
                }
                catch (InterruptedException e) {
                    LOG.warn("Interrupted while waiting for bootstrap of " + cacheName + " to complete", (Throwable)e);
                }
                ++waitTry;
            }
            LOG.warn("Bootstrap of {} did not complete in {}ms, giving up on bootstrap request to {}.", new Object[]{cacheName, 300000L, address});
        }

        public String toString() {
            return "BootstrapRequestRunnable [name=" + this.threadNameSuffix + ", message=" + this.bootstrapRequest + "]";
        }
    }

    private final class BootstrapRequestCleanerTimerTask
    extends TimerTask {
        private BootstrapRequestCleanerTimerTask() {
        }

        public void run() {
            JGroupsBootstrapManager.this.bootstrapRequests.cleanBootstrapRequests();
        }
    }
}

