/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class AsciiInputStream
extends FilterInputStream {
    protected boolean active;
    protected int eol;
    protected int buffer;
    protected int markBuffer;

    public AsciiInputStream(InputStream in) throws Exception {
        super(in);
        String lineSeparator = System.getProperty("line.separator");
        if (lineSeparator.equals("\r\n")) {
            this.active = false;
        } else {
            if (lineSeparator.length() > 1) {
                throw new Exception("System line separator longer than 1 char");
            }
            this.active = true;
            this.eol = lineSeparator.charAt(0);
            this.buffer = -1;
        }
    }

    public int read() throws IOException {
        int cur;
        if (!this.active) {
            return this.in.read();
        }
        if (this.buffer < 0) {
            cur = this.in.read();
        } else {
            cur = this.buffer;
            this.buffer = -1;
        }
        if (cur != 13) {
            return cur;
        }
        this.buffer = this.in.read();
        if (this.buffer != 10) {
            return cur;
        }
        this.buffer = -1;
        return this.eol;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count;
        if (!this.active) {
            return this.in.read(b, off, len);
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int cur = this.read();
        if (cur < 0) {
            return 0;
        }
        b[off] = (byte)cur;
        for (count = 1; count < len; ++count) {
            try {
                cur = this.read();
            }
            catch (IOException e) {
                cur = -1;
            }
            if (cur < 0) {
                return count;
            }
            b[off + count] = (byte)cur;
        }
        return count;
    }

    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        if (!this.active || this.buffer < 0) {
            return this.in.skip(n);
        }
        this.buffer = -1;
        return 1L + this.in.skip(n - 1L);
    }

    public int available() throws IOException {
        if (!this.active || this.buffer < 0) {
            return this.in.available();
        }
        return 1 + this.in.available();
    }

    public void mark(int readlimit) {
        if (readlimit <= 0) {
            return;
        }
        if (!this.active) {
            this.in.mark(readlimit);
            return;
        }
        this.markBuffer = this.buffer;
        this.in.mark(readlimit - 1);
    }

    public void reset() throws IOException {
        if (!this.active) {
            this.in.reset();
            return;
        }
        if (!this.in.markSupported()) {
            throw new IOException();
        }
        this.buffer = this.markBuffer;
        this.in.reset();
    }
}

