/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.AsciiOutputStream;
import gnu.inet.ftp.ConnectionEvent;
import gnu.inet.ftp.PassiveConnection;
import gnu.inet.ftp.PassiveParameters;
import gnu.inet.ftp.Putter;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PassivePutter
extends Putter {
    private static final Log log = LogFactory.getLog((Class)PassivePutter.class);
    private PassiveConnection connection;

    public PassivePutter(InputStream in, PassiveConnection connection) {
        this.istream = in;
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        PassiveParameters parameters;
        boolean signalClosure;
        block32: {
            signalClosure = false;
            Socket sock = null;
            OutputStream ostream = null;
            long amount = 0L;
            int buffer_size = 0;
            byte[] buffer = new byte[1024];
            parameters = this.connection.getPassiveParameters();
            try {
                sock = this.connection.getSocket();
                if (this.cancelled) {
                    throw new InterruptedIOException("Transfer cancelled");
                }
                this.signalConnectionOpened(new ConnectionEvent(parameters.getInetAddress(), parameters.getPort()));
                signalClosure = true;
                this.signalTransferStarted();
                try {
                    int len;
                    switch (this.type) {
                        case 'A': {
                            ostream = new AsciiOutputStream(sock.getOutputStream());
                            break;
                        }
                        default: {
                            ostream = sock.getOutputStream();
                        }
                    }
                    switch (this.mode) {
                        case 'Z': {
                            ostream = new DeflaterOutputStream(ostream);
                            break;
                        }
                    }
                    while ((len = this.istream.read(buffer)) != -1) {
                        ostream.write(buffer, 0, len);
                        amount += (long)len;
                        if ((buffer_size += len) >= 1024) {
                            buffer_size %= 1024;
                            this.signalTransfered(amount);
                        }
                        PassivePutter.yield();
                    }
                    Object var11_12 = null;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    log.debug((Object)"Closing inputstream");
                    if (ostream != null) {
                        ostream.close();
                    }
                    if (!sock.isClosed()) {
                        try {
                            log.debug((Object)"Setting socket to 0 lingering");
                            sock.setSoLinger(true, 0);
                            sock.close();
                        }
                        catch (SocketException e2) {
                            // empty catch block
                        }
                    }
                    this.signalTransferCompleted();
                    throw throwable;
                }
                log.debug((Object)"Closing inputstream");
                if (ostream != null) {
                    ostream.close();
                }
                if (!sock.isClosed()) {
                    try {
                        log.debug((Object)"Setting socket to 0 lingering");
                        sock.setSoLinger(true, 0);
                        sock.close();
                    }
                    catch (SocketException e2) {
                        // empty catch block
                    }
                }
                this.signalTransferCompleted();
                {
                    break block32;
                    catch (InterruptedIOException iioe) {
                        if (!this.cancelled) {
                            log.error((Object)iioe.getMessage(), (Throwable)iioe);
                        }
                        Object var11_13 = null;
                        log.debug((Object)"Closing inputstream");
                        if (ostream != null) {
                            ostream.close();
                        }
                        if (!sock.isClosed()) {
                            try {
                                log.debug((Object)"Setting socket to 0 lingering");
                                sock.setSoLinger(true, 0);
                                sock.close();
                            }
                            catch (SocketException e2) {
                                // empty catch block
                            }
                        }
                        this.signalTransferCompleted();
                        break block32;
                    }
                    catch (Exception e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                        Object var11_14 = null;
                        log.debug((Object)"Closing inputstream");
                        if (ostream != null) {
                            ostream.close();
                        }
                        if (!sock.isClosed()) {
                            try {
                                log.debug((Object)"Setting socket to 0 lingering");
                                sock.setSoLinger(true, 0);
                                sock.close();
                            }
                            catch (SocketException e2) {
                                // empty catch block
                            }
                        }
                        this.signalTransferCompleted();
                    }
                }
            }
            catch (Exception ee) {
                this.signalConnectionFailed(ee);
                log.error((Object)ee.getMessage(), (Throwable)ee);
            }
        }
        if (signalClosure) {
            this.signalConnectionClosed(new ConnectionEvent(parameters.getInetAddress(), parameters.getPort()));
        }
    }
}

