/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.formula;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jxls.formula.CellRef;
import net.sf.jxls.formula.Formula;
import net.sf.jxls.formula.FormulaController;
import net.sf.jxls.formula.FormulaResolver;
import net.sf.jxls.tag.Point;
import net.sf.jxls.transformation.BlockTransformation;
import net.sf.jxls.transformation.DuplicateTransformation;
import net.sf.jxls.transformer.Workbook;
import net.sf.jxls.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.ss.usermodel.Cell;

public class FormulaControllerImpl
implements FormulaController {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected Map sheetFormulasMap;
    Workbook workbook;

    public FormulaControllerImpl(Workbook workbook) {
        this.workbook = workbook;
        this.sheetFormulasMap = workbook.createFormulaSheetMap();
    }

    public void updateWorkbookFormulas(BlockTransformation transformation) {
        Set sheetNames = this.sheetFormulasMap.keySet();
        HashSet<CellRef> cellRefsToRemove = new HashSet<CellRef>();
        HashSet<Formula> formulasToRemove = new HashSet<Formula>();
        for (String sheetName : sheetNames) {
            List formulas = (List)this.sheetFormulasMap.get(sheetName);
            formulasToRemove.clear();
            int size = formulas.size();
            for (int i = 0; i < size; ++i) {
                Formula formula = (Formula)formulas.get(i);
                List formulaPoints = null;
                Point formulaPoint = null;
                boolean transformFormula = false;
                if (formula.getSheet().getSheetName().equals(transformation.getBlock().getSheet().getSheetName())) {
                    transformFormula = true;
                    formulaPoint = new Point(formula.getRowNum(), formula.getCellNum().shortValue());
                    formulaPoints = transformation.transformCell(formulaPoint);
                }
                if (!transformFormula || formulaPoints != null && !formulaPoints.isEmpty()) {
                    Set cellRefs = formula.getCellRefs();
                    cellRefsToRemove.clear();
                    for (CellRef cellRef : cellRefs) {
                        if (transformation instanceof DuplicateTransformation && transformation.getBlock().contains(cellRef) && transformation.getBlock().contains(formula)) continue;
                        List resultCells = transformation.transformCell(sheetName, cellRef);
                        if (resultCells != null) {
                            if (resultCells.size() == 1) {
                                String newCell = (String)resultCells.get(0);
                                cellRef.update(newCell);
                                continue;
                            }
                            if (resultCells.size() <= 1) continue;
                            cellRef.update(resultCells);
                            continue;
                        }
                        cellRefsToRemove.add(cellRef);
                    }
                    if (!cellRefsToRemove.isEmpty()) {
                        formula.removeCellRefs(cellRefsToRemove);
                    }
                    formula.updateReplacedRefCellsCollection();
                    formula.updateCellRefs();
                    if (formulaPoints == null || formulaPoints.isEmpty()) continue;
                    if (formulaPoints.size() == 1) {
                        Point newPoint = (Point)formulaPoints.get(0);
                        formula.setRowNum(new Integer(newPoint.getRow()));
                        formula.setCellNum(new Integer(newPoint.getCol()));
                        continue;
                    }
                    List sheetFormulas = (List)this.sheetFormulasMap.get(formula.getSheet().getSheetName());
                    int num = formulaPoints.size();
                    for (int j = 1; j < num; ++j) {
                        Point point = (Point)formulaPoints.get(j);
                        Formula newFormula = new Formula(formula);
                        newFormula.setRowNum(new Integer(point.getRow()));
                        newFormula.setCellNum(new Integer(point.getCol()));
                        Set newCellRefs = newFormula.getCellRefs();
                        for (CellRef newCellRef : newCellRefs) {
                            if (!transformation.getBlock().contains(newCellRef) || !transformation.getBlock().contains(formulaPoint)) continue;
                            newCellRef.update(transformation.getDuplicatedCellRef(sheetName, newCellRef.toString(), j));
                        }
                        sheetFormulas.add(newFormula);
                    }
                    continue;
                }
                if (formulaPoints != null) continue;
                formulasToRemove.add(formula);
            }
            formulas.removeAll(formulasToRemove);
        }
    }

    public Map getSheetFormulasMap() {
        return this.sheetFormulasMap;
    }

    public void writeFormulas(FormulaResolver formulaResolver) {
        Set sheetNames = this.sheetFormulasMap.keySet();
        for (String sheetName : sheetNames) {
            List formulas = (List)this.sheetFormulasMap.get(sheetName);
            for (int i = 0; i < formulas.size(); ++i) {
                Formula formula = (Formula)formulas.get(i);
                String formulaString = formulaResolver.resolve(formula, null);
                if (formulaString == null) continue;
                Cell hssfCell = Util.getOrCreateCell(formula.getSheet().getPoiSheet(), formula.getRowNum(), formula.getCellNum());
                try {
                    hssfCell.setCellFormula(formulaString);
                    continue;
                }
                catch (RuntimeException e) {
                    this.log.error((Object)("Can't set formula: " + formulaString), (Throwable)e);
                    throw new RuntimeException("Can't set formula: " + formulaString, e);
                }
            }
        }
    }
}

