/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.formula;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jxls.formula.CellRef;
import net.sf.jxls.formula.Formula;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormulaPart {
    protected final Log log = LogFactory.getLog(this.getClass());
    public static char defaultValueToken = (char)64;
    Formula parentFormula;
    String formulaPartString;
    List parts = new ArrayList();
    List cellRefs = new ArrayList();
    List cellRefsToRemove = new ArrayList();
    List cellRefsToAdd = new ArrayList();
    Integer defaultValue = null;
    private static final String regexCellRef = "([a-zA-Z]+[a-zA-Z0-9]*![a-zA-Z]+[0-9]+|[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+)";
    private static final Pattern regexCellRefPattern = Pattern.compile("([a-zA-Z]+[a-zA-Z0-9]*![a-zA-Z]+[0-9]+|[a-zA-Z]+[0-9]+|'[^?\\\\/:'*]+'![a-zA-Z]+[0-9]+)");

    public FormulaPart(String formulaPartString, Formula parentFormula) {
        this.formulaPartString = formulaPartString;
        this.parentFormula = parentFormula;
        this.parseFormulaPartString(formulaPartString);
    }

    public FormulaPart(FormulaPart aFormulaPart) {
        this.parentFormula = aFormulaPart.parentFormula;
        for (int i = 0; i < aFormulaPart.parts.size(); ++i) {
            Object part = aFormulaPart.parts.get(i);
            if (part instanceof String) {
                this.parts.add(part.toString());
                continue;
            }
            if (!(part instanceof CellRef)) continue;
            CellRef cellRef = new CellRef(part.toString(), this);
            this.parts.add(cellRef);
            this.cellRefs.add(cellRef);
        }
        this.defaultValue = aFormulaPart.defaultValue;
    }

    public Integer getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Integer defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void parseFormulaPartString(String formula) {
        this.parts.clear();
        this.cellRefs.clear();
        formula = this.extractDefaultValue(formula);
        Matcher refCellMatcher = regexCellRefPattern.matcher(formula);
        int end = 0;
        CellRef cellRef = null;
        while (refCellMatcher.find()) {
            String part = formula.substring(end, refCellMatcher.start());
            part = this.adjustFormulaPartForCellIndex(cellRef, part);
            this.parts.add(part);
            cellRef = new CellRef(refCellMatcher.group(), this);
            this.parts.add(cellRef);
            this.cellRefs.add(cellRef);
            end = refCellMatcher.end();
        }
        this.parts.add(this.adjustFormulaPartForCellIndex(cellRef, formula.substring(end)));
    }

    private String extractDefaultValue(String formula) {
        int i = formula.indexOf(defaultValueToken);
        String resultFormula = formula;
        if (i >= 0) {
            resultFormula = formula.substring(0, i);
            try {
                this.defaultValue = Integer.valueOf(formula.substring(i + 1));
            }
            catch (NumberFormatException e) {
                this.log.error((Object)("Can't parse default value constant for " + this.formulaPartString + " formula part. Integer expected after '@' symbol"));
            }
        }
        return resultFormula;
    }

    private String adjustFormulaPartForCellIndex(CellRef cellRef, String formulaPart) {
        if (cellRef != null) {
            int indStart = formulaPart.indexOf(40);
            int indEnd = formulaPart.indexOf(41);
            if (indStart == 0 && indEnd > 0) {
                String cellIndex = formulaPart.substring(indStart + 1, indEnd);
                try {
                    cellRef.setCellIndex(Integer.valueOf(cellIndex));
                    formulaPart = formulaPart.substring(indEnd + 1);
                }
                catch (NumberFormatException e) {
                    this.log.error((Object)("Can't parse cell index " + cellIndex + " for cell " + cellRef + ". Make sure you don't have any spaces for index part."), (Throwable)e);
                }
            }
        }
        return formulaPart;
    }

    void replaceCellRefs(CellRef cellRef, List rangeFormulaParts) {
        this.cellRefsToRemove.add(cellRef);
        for (int i = 0; i < rangeFormulaParts.size(); ++i) {
            Object formulaPart = rangeFormulaParts.get(i);
            if (!(formulaPart instanceof CellRef)) continue;
            this.cellRefsToAdd.add(formulaPart);
        }
    }

    public void replaceCellRef(CellRef cellRef, List rangeFormulaParts) {
        for (int i = 0; i < this.parts.size(); ++i) {
            Object formulaPart = this.parts.get(i);
            if (formulaPart != cellRef) continue;
            this.replaceFormulaPart(i, rangeFormulaParts);
            this.replaceCellRefs(cellRef, rangeFormulaParts);
            break;
        }
    }

    private void replaceFormulaPart(int pos, List rangeFormulaParts) {
        this.parts.remove(pos);
        this.parts.addAll(pos, rangeFormulaParts);
    }

    public Collection getRefCells() {
        return this.cellRefs;
    }

    public String getActualFormula() {
        if (this.cellRefs.isEmpty() && this.defaultValue != null) {
            return this.defaultValue.toString();
        }
        String actualFormula = "";
        for (Object formulaPart : this.parts) {
            actualFormula = actualFormula + formulaPart.toString();
        }
        return actualFormula;
    }

    public void removeCellRefs(Set cellRefsToBeRemoved) {
        ArrayList<Integer> formulaPartIndexesToRemove = new ArrayList<Integer>();
        Object prevFormulaPart = null;
        for (int i = 0; i < this.parts.size(); ++i) {
            Object formulaPart = this.parts.get(i);
            if (!cellRefsToBeRemoved.contains(formulaPart)) continue;
            formulaPartIndexesToRemove.add(new Integer(i));
            if (i > 0) {
                prevFormulaPart = this.parts.get(i - 1);
            }
            Object nextFormulaPart = i < this.parts.size() - 1 ? (Object)this.parts.get(i + 1) : null;
            if (prevFormulaPart == null) continue;
            if (prevFormulaPart.toString().equals(",")) {
                formulaPartIndexesToRemove.add(new Integer(i - 1));
                continue;
            }
            if (nextFormulaPart == null || !nextFormulaPart.toString().equals(",")) continue;
            formulaPartIndexesToRemove.add(new Integer(i + 1));
        }
        Collections.sort(formulaPartIndexesToRemove);
        int shift = 0;
        for (int i = 0; i < formulaPartIndexesToRemove.size(); ++i) {
            int index = (Integer)formulaPartIndexesToRemove.get(i);
            this.parts.remove(index - shift);
            ++shift;
        }
        this.cellRefs.removeAll(cellRefsToBeRemoved);
    }

    public void updateReplacedRefCellsCollection() {
        int size = this.cellRefsToRemove.size();
        for (int i = 0; i < size; ++i) {
            CellRef cellRef = (CellRef)this.cellRefsToRemove.get(i);
            this.cellRefs.remove(cellRef);
        }
        this.cellRefsToRemove.clear();
        int size2 = this.cellRefsToAdd.size();
        for (int i = 0; i < size2; ++i) {
            Object cellRef2 = this.cellRefsToAdd.get(i);
            this.cellRefs.add(cellRef2);
        }
        this.cellRefsToAdd.clear();
    }

    public String toString() {
        return this.formulaPartString;
    }
}

