/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformation;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.formula.CellRef;
import net.sf.jxls.tag.Block;
import net.sf.jxls.tag.Point;
import net.sf.jxls.transformation.BlockTransformation;
import net.sf.jxls.transformation.DuplicateTransformation;
import org.apache.poi.ss.util.CellReference;

public class DuplicateTransformationByColumns
extends BlockTransformation {
    int rowNum;
    int colNum;
    int duplicateNumber;
    List cells = new ArrayList();

    public DuplicateTransformationByColumns(Block block, int duplicateNumber) {
        super(block);
        this.duplicateNumber = duplicateNumber;
    }

    public Block getBlockAfterTransformation() {
        return null;
    }

    public List transformCell(Point p) {
        ArrayList<Point> resultCells;
        if (this.block.contains(p)) {
            resultCells = new ArrayList<Point>();
            Point rp = p;
            resultCells.add(p);
            for (int i = 0; i < this.duplicateNumber; ++i) {
                rp = rp.shift(0, this.block.getNumberOfColumns());
                resultCells.add(rp);
            }
        } else {
            resultCells = new ArrayList();
            resultCells.add(p);
        }
        return resultCells;
    }

    public String getDuplicatedCellRef(String sheetName, String cell, int duplicateBlock) {
        CellReference cellRef = new CellReference(cell);
        int row = cellRef.getRow();
        short col = cellRef.getCol();
        String refSheetName = cellRef.getSheetName();
        String resultCellRef = cell;
        if ((this.block.getSheet().getSheetName().equalsIgnoreCase(refSheetName) || refSheetName == null && this.block.getSheet().getSheetName().equalsIgnoreCase(sheetName)) && this.block.contains(row, col) && this.duplicateNumber >= 1 && this.duplicateNumber >= duplicateBlock) {
            col = (short)(col + this.block.getNumberOfColumns() * duplicateBlock);
            resultCellRef = this.cellToString(row, col, refSheetName);
        }
        return resultCellRef;
    }

    public List transformCell(String sheetName, CellRef cellRef) {
        String refSheetName = cellRef.getSheetName();
        this.cells.clear();
        if ((this.block.getSheet().getSheetName().equalsIgnoreCase(refSheetName) || refSheetName == null && this.block.getSheet().getSheetName().equalsIgnoreCase(sheetName)) && this.block.contains(cellRef.getRowNum(), cellRef.getColNum())) {
            this.colNum = cellRef.getColNum();
            this.cells.add(this.cellToString(cellRef.getRowNum(), this.colNum, refSheetName));
            for (int i = 0; i < this.duplicateNumber; ++i) {
                this.colNum += this.block.getNumberOfColumns();
                this.cells.add(this.cellToString(cellRef.getRowNum(), this.colNum, refSheetName));
            }
        }
        return this.cells;
    }

    public String cellToString(int row, int col, String sheetName) {
        CellReference cellReference = new CellReference(row, col, false, false);
        String cellname = sheetName != null ? sheetName + "!" + cellReference.formatAsString() : cellReference.formatAsString();
        return cellname;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DuplicateTransformation) {
            DuplicateTransformation dt = (DuplicateTransformation)obj;
            return super.equals(obj) && dt.duplicateNumber == this.duplicateNumber;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.duplicateNumber;
        return result;
    }

    public String toString() {
        return "DuplicateTransformation: {" + super.toString() + ", duplicateNumber=" + this.duplicateNumber + "}";
    }
}

