/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.transformation;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.formula.CellRef;
import net.sf.jxls.tag.Block;
import net.sf.jxls.tag.Point;
import net.sf.jxls.transformation.BlockTransformation;
import org.apache.poi.ss.util.CellReference;

public class ShiftTransformation
extends BlockTransformation {
    int rowShift;
    int colShift;
    int rowNum;
    int colNum;
    private CellReference cellReference;
    private List cells = new ArrayList();
    private List points = new ArrayList();

    public ShiftTransformation(Block block, int rowShift, int colShift) {
        super(block);
        this.rowShift = rowShift;
        this.colShift = colShift;
    }

    public Block getBlockAfterTransformation() {
        return null;
    }

    public List transformCell(Point p) {
        this.points.clear();
        if (this.block.contains(p) || this.block.isAbove(p) && this.rowShift != 0 || this.block.isToLeft(p) && this.colShift != 0) {
            Point newPoint = p.shift(this.rowShift, this.colShift);
            this.points.add(newPoint);
        } else {
            this.points.add(p);
        }
        return this.points;
    }

    public List transformCell(String sheetName, CellRef cellRef) {
        this.cells.clear();
        String refSheetName = cellRef.getSheetName();
        if ((this.block.getSheet().getSheetName().equalsIgnoreCase(refSheetName) || cellRef.getSheetName() == null && this.block.getSheet().getSheetName().equalsIgnoreCase(sheetName)) && (this.block.contains(cellRef.getRowNum(), cellRef.getColNum()) || this.block.getEndRowNum() < cellRef.getRowNum() && this.rowShift != 0 || this.block.getEndCellNum() < cellRef.getColNum() && this.colShift != 0)) {
            this.rowNum = cellRef.getRowNum() + this.rowShift;
            this.colNum = cellRef.getColNum() + this.colShift;
            if (this.colNum < 0) {
                this.colNum = 0;
            }
            this.cellReference = new CellReference(this.rowNum, this.colNum, false, false);
            if (cellRef.getSheetName() != null) {
                this.cells.add(cellRef.getSheetName() + "!" + this.cellReference.formatAsString());
            } else {
                this.cells.add(this.cellReference.formatAsString());
            }
        }
        return this.cells;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ShiftTransformation) {
            ShiftTransformation st = (ShiftTransformation)obj;
            return super.equals(obj) && this.rowShift == st.rowShift && this.colShift == st.colShift;
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 29 * result + this.rowShift;
        result = 29 * result + this.colShift;
        return result;
    }

    public String toString() {
        return "ShiftTransformation: {" + super.toString() + ", shift=(" + this.rowShift + ", " + this.colShift + ")}";
    }
}

