/*
 * Decompiled with CFR 0.152.
 */
package proguard.gradle;

import groovy.lang.Closure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.tasks.TaskAction;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.KeepClassSpecification;
import proguard.MemberSpecification;
import proguard.ParseException;
import proguard.ProGuard;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class ProGuardTask
extends DefaultTask {
    private final Configuration configuration = new Configuration();
    private ClassSpecification classSpecification;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configuration(Object configurationFile) throws ParseException, IOException {
        ConfigurationParser parser = new ConfigurationParser(this.resolvedFile(configurationFile), System.getProperties());
        try {
            parser.parse(this.configuration);
        }
        finally {
            parser.close();
        }
    }

    public void injars(Object programJars) throws ParseException {
        this.injars(null, programJars);
    }

    public void injars(Map filterArgs, Object programJars) throws ParseException {
        this.configuration.programJars = this.extendClassPath(this.configuration.programJars, this.resolvedFiles(programJars), filterArgs, false);
    }

    public void outjars(Object programJars) throws ParseException {
        this.outjars(null, programJars);
    }

    public void outjars(Map filterArgs, Object programJars) throws ParseException {
        this.configuration.programJars = this.extendClassPath(this.configuration.programJars, this.resolvedFiles(programJars), filterArgs, true);
    }

    public void libraryjars(Object libraryJars) throws ParseException {
        this.libraryjars(null, libraryJars);
    }

    public void libraryjars(Map filterArgs, Object libraryJars) throws ParseException {
        this.configuration.libraryJars = this.extendClassPath(this.configuration.libraryJars, this.resolvedFiles(libraryJars), filterArgs, false);
    }

    public Object getskipnonpubliclibraryclasses() {
        this.skipnonpubliclibraryclasses();
        return null;
    }

    public void skipnonpubliclibraryclasses() {
        this.configuration.skipNonPublicLibraryClasses = true;
    }

    public Object getdontskipnonpubliclibraryclassmembers() {
        this.dontskipnonpubliclibraryclassmembers();
        return null;
    }

    public void dontskipnonpubliclibraryclassmembers() {
        this.configuration.skipNonPublicLibraryClassMembers = false;
    }

    public Object getkeepdirectories() {
        this.keepdirectories();
        return null;
    }

    public void keepdirectories() {
        this.keepdirectories(null);
    }

    public void keepdirectories(String filter) {
        this.configuration.keepDirectories = this.extendFilter(this.configuration.keepDirectories, filter);
    }

    public void target(String targetClassVersion) {
        this.configuration.targetClassVersion = ClassUtil.internalClassVersion((String)targetClassVersion);
    }

    public Object getforceprocessing() {
        this.forceprocessing();
        return null;
    }

    public void forceprocessing() {
        this.configuration.lastModified = Long.MAX_VALUE;
    }

    public void keep(String classSpecificationString) throws ParseException {
        this.keep(null, classSpecificationString);
    }

    public void keep(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, true, false, keepArgs, classSpecificationString));
    }

    public void keep(Map keepClassSpecificationArgs) throws ParseException {
        this.keep(keepClassSpecificationArgs, (Closure)null);
    }

    public void keep(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, true, false, keepClassSpecificationArgs, classMembersClosure));
    }

    public void keepclassmembers(String classSpecificationString) throws ParseException {
        this.keepclassmembers(null, classSpecificationString);
    }

    public void keepclassmembers(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, false, false, keepArgs, classSpecificationString));
    }

    public void keepclassmembers(Map keepClassSpecificationArgs) throws ParseException {
        this.keepclassmembers(keepClassSpecificationArgs, (Closure)null);
    }

    public void keepclassmembers(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, false, false, keepClassSpecificationArgs, classMembersClosure));
    }

    public void keepclasseswithmembers(String classSpecificationString) throws ParseException {
        this.keepclasseswithmembers(null, classSpecificationString);
    }

    public void keepclasseswithmembers(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, false, true, keepArgs, classSpecificationString));
    }

    public void keepclasseswithmembers(Map keepClassSpecificationArgs) throws ParseException {
        this.keepclasseswithmembers(keepClassSpecificationArgs, (Closure)null);
    }

    public void keepclasseswithmembers(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, false, true, keepClassSpecificationArgs, classMembersClosure));
    }

    public void keepnames(String classSpecificationString) throws ParseException {
        this.keepnames(null, classSpecificationString);
    }

    public void keepnames(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, true, false, keepArgs, classSpecificationString));
    }

    public void keepnames(Map keepClassSpecificationArgs) throws ParseException {
        this.keepnames(keepClassSpecificationArgs, (Closure)null);
    }

    public void keepnames(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, true, false, keepClassSpecificationArgs, classMembersClosure));
    }

    public void keepclassmembernames(String classSpecificationString) throws ParseException {
        this.keepclassmembernames(null, classSpecificationString);
    }

    public void keepclassmembernames(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, false, false, keepArgs, classSpecificationString));
    }

    public void keepclassmembernames(Map keepClassSpecificationArgs) throws ParseException {
        this.keepclassmembernames(keepClassSpecificationArgs, (Closure)null);
    }

    public void keepclassmembernames(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, false, false, keepClassSpecificationArgs, classMembersClosure));
    }

    public void keepclasseswithmembernames(String classSpecificationString) throws ParseException {
        this.keepclasseswithmembernames(null, classSpecificationString);
    }

    public void keepclasseswithmembernames(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, false, true, keepArgs, classSpecificationString));
    }

    public void keepclasseswithmembernames(Map keepClassSpecificationArgs) throws ParseException {
        this.keepclasseswithmembernames(keepClassSpecificationArgs, (Closure)null);
    }

    public void keepclasseswithmembernames(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, false, true, keepClassSpecificationArgs, classMembersClosure));
    }

    public Object getprintseeds() {
        this.printseeds();
        return null;
    }

    public void printseeds() {
        this.configuration.printSeeds = Configuration.STD_OUT;
    }

    public void printseeds(Object printSeeds) throws ParseException {
        this.configuration.printSeeds = this.resolvedFile(printSeeds);
    }

    public Object getdontshrink() {
        this.dontshrink();
        return null;
    }

    public void dontshrink() {
        this.configuration.shrink = false;
    }

    public Object getprintusage() {
        this.printusage();
        return null;
    }

    public void printusage() {
        this.configuration.printUsage = Configuration.STD_OUT;
    }

    public void printusage(Object printUsage) throws ParseException {
        this.configuration.printUsage = this.resolvedFile(printUsage);
    }

    public void whyareyoukeeping(String classSpecificationString) throws ParseException {
        this.configuration.whyAreYouKeeping = this.extendClassSpecifications(this.configuration.whyAreYouKeeping, this.createClassSpecification(classSpecificationString));
    }

    public void whyareyoukeeping(Map classSpecificationArgs) throws ParseException {
        this.whyareyoukeeping(classSpecificationArgs, null);
    }

    public void whyareyoukeeping(Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.whyAreYouKeeping = this.extendClassSpecifications(this.configuration.whyAreYouKeeping, this.createClassSpecification(classSpecificationArgs, classMembersClosure));
    }

    public Object getdontoptimize() {
        this.dontoptimize();
        return null;
    }

    public void dontoptimize() {
        this.configuration.optimize = false;
    }

    public void optimizations(String filter) {
        this.configuration.optimizations = this.extendFilter(this.configuration.optimizations, filter);
    }

    public void optimizationpasses(int optimizationPasses) {
        this.configuration.optimizationPasses = optimizationPasses;
    }

    public void assumenosideeffects(String classSpecificationString) throws ParseException {
        this.configuration.assumeNoSideEffects = this.extendClassSpecifications(this.configuration.assumeNoSideEffects, this.createClassSpecification(classSpecificationString));
    }

    public void assumenosideeffects(Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.assumeNoSideEffects = this.extendClassSpecifications(this.configuration.assumeNoSideEffects, this.createClassSpecification(classSpecificationArgs, classMembersClosure));
    }

    public Object getallowaccessmodification() {
        this.allowaccessmodification();
        return null;
    }

    public void allowaccessmodification() {
        this.configuration.allowAccessModification = true;
    }

    public Object getmergeinterfacesaggressively() {
        this.mergeinterfacesaggressively();
        return null;
    }

    public void mergeinterfacesaggressively() {
        this.configuration.mergeInterfacesAggressively = true;
    }

    public Object getdontobfuscate() {
        this.dontobfuscate();
        return null;
    }

    public void dontobfuscate() {
        this.configuration.obfuscate = false;
    }

    public Object getprintmapping() {
        this.printmapping();
        return null;
    }

    public void printmapping() {
        this.configuration.printMapping = Configuration.STD_OUT;
    }

    public void printmapping(Object printMapping) throws ParseException {
        this.configuration.printMapping = this.resolvedFile(printMapping);
    }

    public void applymapping(Object applyMapping) throws ParseException {
        this.configuration.applyMapping = this.resolvedFile(applyMapping);
    }

    public void obfuscationdictionary(Object obfuscationDictionary) throws ParseException {
        this.configuration.obfuscationDictionary = this.resolvedFile(obfuscationDictionary);
    }

    public void classobfuscationdictionary(Object classObfuscationDictionary) throws ParseException {
        this.configuration.classObfuscationDictionary = this.resolvedFile(classObfuscationDictionary);
    }

    public void packageobfuscationdictionary(Object packageObfuscationDictionary) throws ParseException {
        this.configuration.packageObfuscationDictionary = this.resolvedFile(packageObfuscationDictionary);
    }

    public Object getoverloadaggressively() {
        this.overloadaggressively();
        return null;
    }

    public void overloadaggressively() {
        this.configuration.overloadAggressively = true;
    }

    public Object getuseuniqueclassmembernames() {
        this.useuniqueclassmembernames();
        return null;
    }

    public void useuniqueclassmembernames() {
        this.configuration.useUniqueClassMemberNames = true;
    }

    public Object getdontusemixedcaseclassnames() {
        this.dontusemixedcaseclassnames();
        return null;
    }

    public void dontusemixedcaseclassnames() {
        this.configuration.useMixedCaseClassNames = false;
    }

    public Object getkeeppackagenames() {
        this.keeppackagenames();
        return null;
    }

    public void keeppackagenames() {
        this.keeppackagenames(null);
    }

    public void keeppackagenames(String filter) {
        this.configuration.keepPackageNames = this.extendFilter(this.configuration.keepPackageNames, filter, true);
    }

    public Object getflattenpackagehierarchy() {
        this.flattenpackagehierarchy();
        return null;
    }

    public void flattenpackagehierarchy() {
        this.flattenpackagehierarchy("");
    }

    public void flattenpackagehierarchy(String flattenPackageHierarchy) {
        this.configuration.flattenPackageHierarchy = ClassUtil.internalClassName((String)flattenPackageHierarchy);
    }

    public Object getrepackageclasses() {
        this.repackageclasses();
        return null;
    }

    public void repackageclasses() {
        this.repackageclasses("");
    }

    public void repackageclasses(String repackageClasses) {
        this.configuration.repackageClasses = ClassUtil.internalClassName((String)repackageClasses);
    }

    public Object getkeepattributes() {
        this.keepattributes();
        return null;
    }

    public void keepattributes() {
        this.keepattributes(null);
    }

    public void keepattributes(String filter) {
        this.configuration.keepAttributes = this.extendFilter(this.configuration.keepAttributes, filter);
    }

    public Object getkeepparameternames() {
        this.keepparameternames();
        return null;
    }

    public void keepparameternames() {
        this.configuration.keepParameterNames = true;
    }

    public Object getrenamesourcefileattribute() {
        this.renamesourcefileattribute();
        return null;
    }

    public void renamesourcefileattribute() {
        this.renamesourcefileattribute("");
    }

    public void renamesourcefileattribute(String newSourceFileAttribute) {
        this.configuration.newSourceFileAttribute = newSourceFileAttribute;
    }

    public Object getadaptclassstrings() {
        this.adaptclassstrings();
        return null;
    }

    public void adaptclassstrings() {
        this.adaptclassstrings(null);
    }

    public void adaptclassstrings(String filter) {
        this.configuration.adaptClassStrings = this.extendFilter(this.configuration.adaptClassStrings, filter, true);
    }

    public Object getadaptresourcefilenames() {
        this.adaptresourcefilenames();
        return null;
    }

    public void adaptresourcefilenames() {
        this.adaptresourcefilenames(null);
    }

    public void adaptresourcefilenames(String filter) {
        this.configuration.adaptResourceFileNames = this.extendFilter(this.configuration.adaptResourceFileNames, filter);
    }

    public Object getadaptresourcefilecontents() {
        this.adaptresourcefilecontents();
        return null;
    }

    public void adaptresourcefilecontents() {
        this.adaptresourcefilecontents(null);
    }

    public void adaptresourcefilecontents(String filter) {
        this.configuration.adaptResourceFileContents = this.extendFilter(this.configuration.adaptResourceFileContents, filter);
    }

    public Object getdontpreverify() {
        this.dontpreverify();
        return null;
    }

    public void dontpreverify() {
        this.configuration.preverify = false;
    }

    public Object getmicroedition() {
        this.microedition();
        return null;
    }

    public void microedition() {
        this.configuration.microEdition = true;
    }

    public Object getverbose() {
        this.verbose();
        return null;
    }

    public void verbose() {
        this.configuration.verbose = true;
    }

    public Object getdontnote() {
        this.dontnote();
        return null;
    }

    public void dontnote() {
        this.dontnote(null);
    }

    public void dontnote(String filter) {
        this.configuration.note = this.extendFilter(this.configuration.note, filter, true);
    }

    public Object getdontwarn() {
        this.dontwarn();
        return null;
    }

    public void dontwarn() {
        this.dontwarn(null);
    }

    public void dontwarn(String filter) {
        this.configuration.warn = this.extendFilter(this.configuration.warn, filter, true);
    }

    public Object getignorewarnings() {
        this.ignorewarnings();
        return null;
    }

    public void ignorewarnings() {
        this.configuration.ignoreWarnings = true;
    }

    public Object getprintconfiguration() {
        this.printconfiguration();
        return null;
    }

    public void printconfiguration() {
        this.configuration.printConfiguration = Configuration.STD_OUT;
    }

    public void printconfiguration(Object printConfiguration) throws ParseException {
        this.configuration.printConfiguration = this.resolvedFile(printConfiguration);
    }

    public Object getdump() {
        this.dump();
        return null;
    }

    public void dump() {
        this.configuration.dump = Configuration.STD_OUT;
    }

    public void dump(Object dump) throws ParseException {
        this.configuration.dump = this.resolvedFile(dump);
    }

    public void field(Map memberSpecificationArgs) throws ParseException {
        if (this.classSpecification == null) {
            throw new IllegalArgumentException("The 'field' method can only be used nested inside a class specification.");
        }
        this.classSpecification.addField(this.createMemberSpecification(false, false, memberSpecificationArgs));
    }

    public void constructor(Map memberSpecificationArgs) throws ParseException {
        if (this.classSpecification == null) {
            throw new IllegalArgumentException("The 'constructor' method can only be used nested inside a class specification.");
        }
        this.classSpecification.addMethod(this.createMemberSpecification(true, true, memberSpecificationArgs));
    }

    public void method(Map memberSpecificationArgs) throws ParseException {
        if (this.classSpecification == null) {
            throw new IllegalArgumentException("The 'method' method can only be used nested inside a class specification.");
        }
        this.classSpecification.addMethod(this.createMemberSpecification(true, false, memberSpecificationArgs));
    }

    @TaskAction
    public void proguard() throws IOException {
        new ProGuard(this.configuration).execute();
    }

    private File resolvedFile(Object file) throws ParseException {
        return this.getProject().file(this.resolvedString(file));
    }

    private ConfigurableFileCollection resolvedFiles(Object files) throws ParseException {
        return this.getProject().files(new Object[]{this.resolvedString(files)});
    }

    private Object resolvedString(Object object) throws ParseException {
        if (object instanceof String) {
            try {
                String fileName = (String)object;
                return new ConfigurationParser(fileName, "Gradle setting", null, System.getProperties()).replaceSystemProperties(fileName);
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage());
            }
        }
        return object;
    }

    private ClassPath extendClassPath(ClassPath classPath, ConfigurableFileCollection fileCollection, Map filterArgs, boolean output) {
        if (classPath == null) {
            classPath = new ClassPath();
        }
        for (File file : fileCollection) {
            ClassPathEntry classPathEntry = new ClassPathEntry(file, output);
            if (filterArgs != null) {
                classPathEntry.setFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("filter"))));
                classPathEntry.setJarFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("jarfilter"))));
                classPathEntry.setWarFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("warfilter"))));
                classPathEntry.setEarFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("earfilter"))));
                classPathEntry.setZipFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("zipfilter"))));
            }
            classPath.add(classPathEntry);
        }
        return classPath;
    }

    private KeepClassSpecification createKeepClassSpecification(boolean allowShrinking, boolean markClasses, boolean markConditionally, Map keepArgs, String classSpecificationString) throws ParseException {
        ClassSpecification classSpecification = this.createClassSpecification(classSpecificationString);
        return this.createKeepClassSpecification(allowShrinking, markClasses, markConditionally, keepArgs, classSpecification);
    }

    private KeepClassSpecification createKeepClassSpecification(boolean allowShrinking, boolean markClasses, boolean markConditionally, Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        ClassSpecification classSpecification = this.createClassSpecification(classSpecificationArgs, classMembersClosure);
        return this.createKeepClassSpecification(allowShrinking, markClasses, markConditionally, classSpecificationArgs, classSpecification);
    }

    private KeepClassSpecification createKeepClassSpecification(boolean allowShrinking, boolean markClasses, boolean markConditionally, Map keepArgs, ClassSpecification classSpecification) {
        return new KeepClassSpecification(markClasses, markConditionally, this.retrieveBoolean(keepArgs, "allowshrinking", allowShrinking), this.retrieveBoolean(keepArgs, "allowoptimization", false), this.retrieveBoolean(keepArgs, "allowobfuscation", false), classSpecification);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassSpecification createClassSpecification(String classSpecificationString) throws ParseException {
        ClassSpecification classSpecification;
        ConfigurationParser parser = new ConfigurationParser(new String[]{classSpecificationString}, null);
        try {
            classSpecification = parser.parseClassSpecificationArguments();
        }
        catch (Throwable throwable) {
            try {
                parser.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage());
            }
        }
        parser.close();
        return classSpecification;
    }

    private ClassSpecification createClassSpecification(Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        String access = (String)classSpecificationArgs.get("access");
        String annotation = (String)classSpecificationArgs.get("annotation");
        String type = (String)classSpecificationArgs.get("type");
        String name = (String)classSpecificationArgs.get("name");
        String extendsAnnotation = (String)classSpecificationArgs.get("extendsannotation");
        String extends_ = (String)classSpecificationArgs.get("extends");
        if (extends_ == null) {
            extends_ = (String)classSpecificationArgs.get("implements");
        }
        ClassSpecification classSpecification = new ClassSpecification(null, this.requiredClassAccessFlags(true, access, type), this.requiredClassAccessFlags(false, access, type), annotation != null ? ClassUtil.internalType((String)annotation) : null, name != null ? ClassUtil.internalClassName((String)name) : null, extendsAnnotation != null ? ClassUtil.internalType((String)extendsAnnotation) : null, extends_ != null ? ClassUtil.internalClassName((String)extends_) : null);
        if (classMembersClosure != null) {
            this.classSpecification = classSpecification;
            classMembersClosure.call((Object)classSpecification);
            this.classSpecification = null;
        }
        return classSpecification;
    }

    private int requiredClassAccessFlags(boolean set, String access, String type) throws ParseException {
        int accessFlags = 0;
        if (access != null) {
            StringTokenizer tokenizer = new StringTokenizer(access, " ,");
            while (tokenizer.hasMoreTokens()) {
                int accessFlag;
                String strippedToken;
                String token = tokenizer.nextToken();
                if (!(token.startsWith("!") ^ set)) continue;
                String string = strippedToken = token.startsWith("!") ? token.substring(1) : token;
                int n = strippedToken.equals("public") ? 1 : (strippedToken.equals("final") ? 16 : (strippedToken.equals("abstract") ? 1024 : (strippedToken.equals("synthetic") ? 4096 : (accessFlag = strippedToken.equals("@") ? 8192 : 0))));
                if (accessFlag == 0) {
                    throw new ParseException("Incorrect class access modifier [" + strippedToken + "]");
                }
                accessFlags |= accessFlag;
            }
        }
        if (type != null && type.startsWith("!") ^ set) {
            int accessFlag;
            int n = type.equals("class") ? 0 : (type.equals("interface") || type.equals("!interface") ? 512 : (accessFlag = type.equals("enum") || type.equals("!enum") ? 16384 : -1));
            if (accessFlag == -1) {
                throw new ParseException("Incorrect class type [" + type + "]");
            }
            accessFlags |= accessFlag;
        }
        return accessFlags;
    }

    private MemberSpecification createMemberSpecification(boolean isMethod, boolean isConstructor, Map classSpecificationArgs) throws ParseException {
        String access = (String)classSpecificationArgs.get("access");
        String type = (String)classSpecificationArgs.get("type");
        String annotation = (String)classSpecificationArgs.get("annotation");
        String name = (String)classSpecificationArgs.get("name");
        String parameters = (String)classSpecificationArgs.get("parameters");
        if (annotation != null) {
            annotation = ClassUtil.internalType((String)annotation);
        }
        if (isMethod) {
            if (isConstructor) {
                if (type != null) {
                    throw new ParseException("Type attribute not allowed in constructor specification [" + type + "]");
                }
                if (parameters != null) {
                    type = "void";
                }
                name = "<init>";
            } else if (type != null ^ parameters != null) {
                throw new ParseException("Type and parameters attributes must always be present in combination in method specification");
            }
        } else if (parameters != null) {
            throw new ParseException("Parameters attribute not allowed in field specification [" + parameters + "]");
        }
        List parameterList = ListUtil.commaSeparatedList((String)parameters);
        String descriptor = parameters != null ? ClassUtil.internalMethodDescriptor((String)type, (List)parameterList) : (type != null ? ClassUtil.internalType((String)type) : null);
        return new MemberSpecification(this.requiredMemberAccessFlags(true, access), this.requiredMemberAccessFlags(false, access), annotation, name, descriptor);
    }

    private int requiredMemberAccessFlags(boolean set, String access) throws ParseException {
        int accessFlags = 0;
        if (access != null) {
            StringTokenizer tokenizer = new StringTokenizer(access, " ,");
            while (tokenizer.hasMoreTokens()) {
                int accessFlag;
                String strippedToken;
                String token = tokenizer.nextToken();
                if (!(token.startsWith("!") ^ set)) continue;
                String string = strippedToken = token.startsWith("!") ? token.substring(1) : token;
                int n = strippedToken.equals("public") ? 1 : (strippedToken.equals("private") ? 2 : (strippedToken.equals("protected") ? 4 : (strippedToken.equals("static") ? 8 : (strippedToken.equals("final") ? 16 : (strippedToken.equals("synchronized") ? 32 : (strippedToken.equals("volatile") ? 64 : (strippedToken.equals("transient") ? 128 : (strippedToken.equals("bridge") ? 64 : (strippedToken.equals("varargs") ? 128 : (strippedToken.equals("native") ? 256 : (strippedToken.equals("abstract") ? 1024 : (strippedToken.equals("strictfp") ? 2048 : (accessFlag = strippedToken.equals("synthetic") ? 4096 : 0)))))))))))));
                if (accessFlag == 0) {
                    throw new ParseException("Incorrect class member access modifier [" + strippedToken + "]");
                }
                accessFlags |= accessFlag;
            }
        }
        return accessFlags;
    }

    private boolean retrieveBoolean(Map args, String name, boolean defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object arg = args.get(name);
        return arg == null ? defaultValue : (Boolean)arg;
    }

    private List extendClassSpecifications(List classSpecifications, ClassSpecification classSpecification) {
        if (classSpecifications == null) {
            classSpecifications = new ArrayList<ClassSpecification>();
        }
        classSpecifications.add(classSpecification);
        return classSpecifications;
    }

    private List extendClassSpecifications(List classSpecifications, List additionalClassSpecifications) {
        if (additionalClassSpecifications != null) {
            if (classSpecifications == null) {
                classSpecifications = new ArrayList();
            }
            classSpecifications.addAll(additionalClassSpecifications);
        }
        return classSpecifications;
    }

    private List extendFilter(List filter, String filterString) {
        return this.extendFilter(filter, filterString, false);
    }

    private List extendFilter(List filter, String filterString, boolean internal) {
        if (filter == null) {
            filter = new ArrayList();
        }
        if (filterString == null) {
            filter.clear();
        } else {
            if (internal) {
                filterString = ClassUtil.internalClassName((String)filterString);
            }
            filter.addAll(ListUtil.commaSeparatedList((String)filterString));
        }
        return filter;
    }
}

