/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.settings;

import java.awt.RenderingHints;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.settings.ISettingsListener;
import net.sf.robocode.settings.ISettingsManager;

public class SettingsManager
implements ISettingsManager {
    private static final String DEFAULT_FILE_GUNSHOT_SFX = "/net/sf/robocode/sound/sounds/zap.wav";
    private static final String DEFAULT_FILE_ROBOT_COLLISION_SFX = "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav";
    private static final String DEFAULT_FILE_WALL_COLLISION_SFX = "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav";
    private static final String DEFAULT_FILE_ROBOT_DEATH_SFX = "/net/sf/robocode/sound/sounds/explode.wav";
    private static final String DEFAULT_FILE_BULLET_HITS_ROBOT_SFX = "/net/sf/robocode/sound/sounds/shellhit.wav";
    private static final String DEFAULT_FILE_BULLET_HITS_BULLET_SFX = "/net/sf/robocode/sound/sounds/shellhit.wav";
    private boolean optionsViewRobotEnergy = true;
    private boolean optionsViewRobotNames = true;
    private boolean optionsViewScanArcs = false;
    private boolean optionsViewExplosions = true;
    private boolean optionsViewGround = true;
    private boolean optionsViewExplosionDebris = true;
    private boolean optionsViewSentryBorder = false;
    private boolean optionsViewTPS = true;
    private boolean optionsViewFPS = true;
    private boolean optionsViewPreventSpeedupWhenMinimized = false;
    private int optionsRenderingAntialiasing = 0;
    private int optionsRenderingTextAntialiasing = 0;
    private int optionsRenderingMethod = 0;
    private int optionsRenderingNoBuffers = 2;
    private int optionsBattleDesiredTPS = 30;
    private boolean optionsRenderingBufferImages = true;
    private boolean optionsRenderingForceBulletColor = false;
    private boolean optionsSoundEnableSound = false;
    private boolean optionsSoundEnableGunshot = true;
    private boolean optionsSoundEnableBulletHit = true;
    private boolean optionsSoundEnableRobotDeath = true;
    private boolean optionsSoundEnableWallCollision = true;
    private boolean optionsSoundEnableRobotCollision = true;
    private String optionsSoundMixer = "DirectAudioDevice";
    private boolean optionsSoundEnableMixerVolume = true;
    private boolean optionsSoundEnableMixerPan = true;
    private Collection<String> optionsDevelopmentPaths = new HashSet<String>();
    private Collection<String> optionsExcludedDevelopmentPaths = new HashSet<String>();
    private boolean optionsCommonNotifyAboutNewBetaVersions = false;
    private boolean optionsCommonShowResults = true;
    private boolean optionsCommonAppendWhenSavingResults = true;
    private boolean optionsCommonDontHideRankings = true;
    private boolean optionsCommonEnableAutoRecording = false;
    private boolean optionsCommonAutoRecordingXML = false;
    private boolean optionsCommonEnableReplayRecording = false;
    private boolean optionsTeamShowTeamRobots = false;
    private String fileThemeMusic = "";
    private String fileBackgroundMusic = "";
    private String fileEndOfBattleMusic = "";
    private String fileGunshotSfx = "/net/sf/robocode/sound/sounds/zap.wav";
    private String fileRobotCollisionSfx = "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav";
    private String fileWallCollisionSfx = "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav";
    private String fileRobotDeathSfx = "/net/sf/robocode/sound/sounds/explode.wav";
    private String fileBulletHitsRobotSfx = "/net/sf/robocode/sound/sounds/shellhit.wav";
    private String fileBulletHitsBulletSfx = "/net/sf/robocode/sound/sounds/shellhit.wav";
    private String lastRunVersion = "";
    private Date versionChecked;
    private long robotFilesystemQuota = 200000L;
    private long consoleQuota = 8192L;
    private long cpuConstant = -1L;
    private int battleDefaultBattlefieldWidth = 800;
    private int battleDefaultBattlefieldHeight = 600;
    private double battleDefaultGunCoolingRate = 0.1;
    private long battleDefaultInactivityTime = 450L;
    private int battleDefaultSentryBorderSize = 100;
    private boolean battleDefaultHideEnemyNames = false;
    private int battleDefaultNumberOfRounds = 10;
    private final Properties props = new SortedProperties();
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy H:mm:ss");
    private final RenderingHints renderingHints = new RenderingHints(new HashMap());
    private final List<ISettingsListener> listeners = new ArrayList<ISettingsListener>();

    public SettingsManager() {
        FileInputStream in = null;
        try {
            in = new FileInputStream(FileUtil.getRobocodeConfigFile());
            this.load(in);
        }
        catch (FileNotFoundException e) {
            Logger.logError((String)("No " + FileUtil.getRobocodeConfigFile().getName() + ". Using defaults."));
        }
        catch (IOException e) {
            Logger.logError((String)("Error while reading " + FileUtil.getRobocodeConfigFile().getName() + ": " + e));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public void saveProperties() {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(FileUtil.getRobocodeConfigFile());
            this.store(out, "Robocode Properties");
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean getOptionsViewRobotNames() {
        return this.optionsViewRobotNames;
    }

    @Override
    public void setOptionsViewRobotNames(boolean optionsViewRobotNames) {
        this.optionsViewRobotNames = optionsViewRobotNames;
        this.props.setProperty("robocode.options.view.robotNames", "" + optionsViewRobotNames);
    }

    @Override
    public boolean getOptionsViewScanArcs() {
        return this.optionsViewScanArcs;
    }

    @Override
    public void setOptionsViewScanArcs(boolean optionsViewScanArcs) {
        this.optionsViewScanArcs = optionsViewScanArcs;
        this.props.setProperty("robocode.options.view.scanArcs", "" + optionsViewScanArcs);
    }

    @Override
    public boolean getOptionsViewRobotEnergy() {
        return this.optionsViewRobotEnergy;
    }

    @Override
    public void setOptionsViewRobotEnergy(boolean optionsViewRobotEnergy) {
        this.optionsViewRobotEnergy = optionsViewRobotEnergy;
        this.props.setProperty("robocode.options.view.robotEnergy", "" + optionsViewRobotEnergy);
    }

    @Override
    public boolean getOptionsViewGround() {
        return this.optionsViewGround;
    }

    @Override
    public void setOptionsViewGround(boolean optionsViewGround) {
        this.optionsViewGround = optionsViewGround;
        this.props.setProperty("robocode.options.view.ground", "" + optionsViewGround);
    }

    @Override
    public boolean getOptionsViewTPS() {
        return this.optionsViewTPS;
    }

    @Override
    public void setOptionsViewTPS(boolean optionsViewTPS) {
        this.optionsViewTPS = optionsViewTPS;
        this.props.setProperty("robocode.options.view.TPS", "" + optionsViewTPS);
    }

    @Override
    public boolean getOptionsViewFPS() {
        return this.optionsViewFPS;
    }

    @Override
    public void setOptionsViewFPS(boolean optionsViewFPS) {
        this.optionsViewFPS = optionsViewFPS;
        this.props.setProperty("robocode.options.view.FPS", "" + optionsViewFPS);
    }

    @Override
    public boolean getOptionsViewExplosions() {
        return this.optionsViewExplosions;
    }

    @Override
    public void setOptionsViewExplosions(boolean optionsViewExplosions) {
        this.optionsViewExplosions = optionsViewExplosions;
        this.props.setProperty("robocode.options.view.explosions", "" + optionsViewExplosions);
    }

    @Override
    public boolean getOptionsViewExplosionDebris() {
        return this.optionsViewExplosionDebris;
    }

    @Override
    public void setOptionsViewExplosionDebris(boolean optionsViewExplosionDebris) {
        this.optionsViewExplosionDebris = optionsViewExplosionDebris;
        this.props.setProperty("robocode.options.view.explosionDebris", "" + optionsViewExplosionDebris);
    }

    @Override
    public boolean getOptionsViewPreventSpeedupWhenMinimized() {
        return this.optionsViewPreventSpeedupWhenMinimized;
    }

    @Override
    public void setOptionsViewPreventSpeedupWhenMinimized(boolean preventSpeedupWhenMinimized) {
        this.optionsViewPreventSpeedupWhenMinimized = preventSpeedupWhenMinimized;
        this.props.setProperty("robocode.options.view.preventSpeedupWhenMinimized", "" + preventSpeedupWhenMinimized);
    }

    @Override
    public boolean getOptionsViewSentryBorder() {
        return this.optionsViewSentryBorder;
    }

    @Override
    public void setOptionsViewSentryBorder(boolean optionsViewSentryBorder) {
        this.optionsViewSentryBorder = optionsViewSentryBorder;
        this.props.setProperty("robocode.options.view.sentryBorder", "" + optionsViewSentryBorder);
    }

    @Override
    public int getOptionsRenderingAntialiasing() {
        return this.optionsRenderingAntialiasing;
    }

    @Override
    public void setOptionsRenderingAntialiasing(int optionsRenderingAntialiasing) {
        Object value;
        this.optionsRenderingAntialiasing = optionsRenderingAntialiasing;
        this.props.setProperty("robocode.options.rendering.antialiasing", "" + optionsRenderingAntialiasing);
        switch (optionsRenderingAntialiasing) {
            case 1: {
                value = RenderingHints.VALUE_ANTIALIAS_ON;
                break;
            }
            case 2: {
                value = RenderingHints.VALUE_ANTIALIAS_OFF;
                break;
            }
            default: {
                value = RenderingHints.VALUE_ANTIALIAS_DEFAULT;
            }
        }
        this.renderingHints.put(RenderingHints.KEY_ANTIALIASING, value);
    }

    @Override
    public int getOptionsRenderingTextAntialiasing() {
        return this.optionsRenderingTextAntialiasing;
    }

    @Override
    public void setOptionsRenderingTextAntialiasing(int optionsRenderingTextAntialiasing) {
        Object value;
        this.optionsRenderingTextAntialiasing = optionsRenderingTextAntialiasing;
        this.props.setProperty("robocode.options.rendering.text.antialiasing", "" + optionsRenderingTextAntialiasing);
        switch (optionsRenderingTextAntialiasing) {
            case 1: {
                value = RenderingHints.VALUE_TEXT_ANTIALIAS_ON;
                break;
            }
            case 2: {
                value = RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                break;
            }
            default: {
                value = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            }
        }
        this.renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, value);
    }

    @Override
    public int getOptionsRenderingMethod() {
        return this.optionsRenderingMethod;
    }

    @Override
    public void setOptionsRenderingMethod(int optionsRenderingMethod) {
        Object value;
        this.optionsRenderingMethod = optionsRenderingMethod;
        this.props.setProperty("robocode.options.rendering.method", "" + optionsRenderingMethod);
        switch (optionsRenderingMethod) {
            case 1: {
                value = RenderingHints.VALUE_RENDER_QUALITY;
                break;
            }
            case 2: {
                value = RenderingHints.VALUE_RENDER_SPEED;
                break;
            }
            default: {
                value = RenderingHints.VALUE_RENDER_DEFAULT;
            }
        }
        this.renderingHints.put(RenderingHints.KEY_RENDERING, value);
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    @Override
    public int getOptionsRenderingNoBuffers() {
        return this.optionsRenderingNoBuffers;
    }

    @Override
    public void setOptionsRenderingNoBuffers(int optionsRenderingNoBuffers) {
        this.optionsRenderingNoBuffers = optionsRenderingNoBuffers;
        this.props.setProperty("robocode.options.rendering.noBuffers", "" + optionsRenderingNoBuffers);
    }

    @Override
    public boolean getOptionsRenderingBufferImages() {
        return this.optionsRenderingBufferImages;
    }

    @Override
    public void setOptionsRenderingBufferImages(boolean optionsRenderingBufferImages) {
        this.optionsRenderingBufferImages = optionsRenderingBufferImages;
        this.props.setProperty("robocode.options.rendering.bufferImages", "" + optionsRenderingBufferImages);
    }

    @Override
    public boolean getOptionsRenderingForceBulletColor() {
        return this.optionsRenderingForceBulletColor;
    }

    @Override
    public void setOptionsRenderingForceBulletColor(boolean optionsRenderingForceBulletColor) {
        this.optionsRenderingForceBulletColor = optionsRenderingForceBulletColor;
        this.props.setProperty("robocode.options.rendering.forceBulletColor", "" + optionsRenderingForceBulletColor);
    }

    @Override
    public int getOptionsBattleDesiredTPS() {
        return this.optionsBattleDesiredTPS;
    }

    @Override
    public void setOptionsBattleDesiredTPS(int optionsBattleDesiredTPS) {
        this.optionsBattleDesiredTPS = optionsBattleDesiredTPS;
        this.props.setProperty("robocode.options.battle.desiredTPS", "" + optionsBattleDesiredTPS);
    }

    @Override
    public boolean getOptionsSoundEnableSound() {
        return this.optionsSoundEnableSound;
    }

    @Override
    public void setOptionsSoundEnableSound(boolean optionsSoundEnableSound) {
        this.optionsSoundEnableSound = optionsSoundEnableSound;
        this.props.setProperty("robocode.options.sound.enableSound", "" + optionsSoundEnableSound);
    }

    @Override
    public boolean getOptionsSoundEnableGunshot() {
        return this.optionsSoundEnableGunshot;
    }

    @Override
    public void setOptionsSoundEnableGunshot(boolean optionsSoundEnableGunshot) {
        this.optionsSoundEnableGunshot = optionsSoundEnableGunshot;
        this.props.setProperty("robocode.options.sound.enableGunshot", "" + optionsSoundEnableGunshot);
    }

    @Override
    public boolean getOptionsSoundEnableBulletHit() {
        return this.optionsSoundEnableBulletHit;
    }

    @Override
    public void setOptionsSoundEnableBulletHit(boolean optionsSoundEnableBulletHit) {
        this.optionsSoundEnableBulletHit = optionsSoundEnableBulletHit;
        this.props.setProperty("robocode.options.sound.enableBulletHit", "" + optionsSoundEnableBulletHit);
    }

    @Override
    public boolean getOptionsSoundEnableRobotDeath() {
        return this.optionsSoundEnableRobotDeath;
    }

    @Override
    public void setOptionsSoundEnableRobotDeath(boolean optionsSoundEnableRobotDeath) {
        this.optionsSoundEnableRobotDeath = optionsSoundEnableRobotDeath;
        this.props.setProperty("robocode.options.sound.enableRobotDeath", "" + optionsSoundEnableRobotDeath);
    }

    @Override
    public boolean getOptionsSoundEnableWallCollision() {
        return this.optionsSoundEnableWallCollision;
    }

    @Override
    public void setOptionsSoundEnableWallCollision(boolean optionsSoundEnableWallCollision) {
        this.optionsSoundEnableWallCollision = optionsSoundEnableWallCollision;
        this.props.setProperty("robocode.options.sound.enableWallCollision", "" + optionsSoundEnableWallCollision);
    }

    @Override
    public boolean getOptionsSoundEnableRobotCollision() {
        return this.optionsSoundEnableRobotCollision;
    }

    @Override
    public void setOptionsSoundEnableRobotCollision(boolean optionsSoundEnableRobotCollision) {
        this.optionsSoundEnableRobotCollision = optionsSoundEnableRobotCollision;
        this.props.setProperty("robocode.options.sound.enableRobotCollision", "" + optionsSoundEnableRobotCollision);
    }

    @Override
    public boolean getOptionsSoundEnableMixerVolume() {
        return this.optionsSoundEnableMixerVolume;
    }

    @Override
    public void setOptionsSoundMixer(String optionsSoundMixer) {
        this.optionsSoundMixer = optionsSoundMixer;
        this.props.setProperty("robocode.options.sound.mixer", optionsSoundMixer);
    }

    @Override
    public String getOptionsSoundMixer() {
        return this.optionsSoundMixer;
    }

    @Override
    public void setOptionsSoundEnableMixerVolume(boolean optionsSoundEnableMixerVolume) {
        this.optionsSoundEnableMixerVolume = optionsSoundEnableMixerVolume;
        this.props.setProperty("robocode.options.sound.enableMixerVolume", "" + optionsSoundEnableMixerVolume);
    }

    @Override
    public boolean getOptionsSoundEnableMixerPan() {
        return this.optionsSoundEnableMixerPan;
    }

    @Override
    public void setOptionsSoundEnableMixerPan(boolean optionsSoundEnableMixerPan) {
        this.optionsSoundEnableMixerPan = optionsSoundEnableMixerPan;
        this.props.setProperty("robocode.options.sound.enableMixerPan", "" + optionsSoundEnableMixerPan);
    }

    @Override
    public boolean getOptionsTeamShowTeamRobots() {
        return this.optionsTeamShowTeamRobots;
    }

    @Override
    public void setOptionsTeamShowTeamRobots(boolean optionsTeamShowTeamRobots) {
        this.optionsTeamShowTeamRobots = optionsTeamShowTeamRobots;
        this.props.setProperty("robocode.options.team.showTeamRobots", "" + optionsTeamShowTeamRobots);
    }

    @Override
    public String getFileThemeMusic() {
        return this.fileThemeMusic;
    }

    @Override
    public String getFileBackgroundMusic() {
        return this.fileBackgroundMusic;
    }

    @Override
    public String getFileEndOfBattleMusic() {
        return this.fileEndOfBattleMusic;
    }

    @Override
    public String getFileGunshotSfx() {
        return this.fileGunshotSfx;
    }

    @Override
    public String getBulletHitsRobotSfx() {
        return this.fileBulletHitsRobotSfx;
    }

    @Override
    public String getBulletHitsBulletSfx() {
        return this.fileBulletHitsBulletSfx;
    }

    @Override
    public String getRobotDeathSfx() {
        return this.fileRobotDeathSfx;
    }

    @Override
    public String getRobotCollisionSfx() {
        return this.fileRobotCollisionSfx;
    }

    @Override
    public String getWallCollisionSfx() {
        return this.fileWallCollisionSfx;
    }

    @Override
    public Date getVersionChecked() {
        return this.versionChecked != null ? (Date)this.versionChecked.clone() : null;
    }

    @Override
    public void setVersionChecked(Date versionChecked) {
        this.versionChecked = versionChecked != null ? (Date)versionChecked.clone() : null;
        this.props.setProperty("robocode.versionchecked", this.dateFormat.format(new Date()));
    }

    @Override
    public long getRobotFilesystemQuota() {
        return this.robotFilesystemQuota;
    }

    @Override
    public void setRobotFilesystemQuota(long robotFilesystemQuota) {
        this.robotFilesystemQuota = robotFilesystemQuota;
        this.props.setProperty("robocode.robot.filesystem.quota", "" + robotFilesystemQuota);
    }

    @Override
    public long getConsoleQuota() {
        return this.consoleQuota;
    }

    @Override
    public void setConsoleQuota(long consoleQuota) {
        this.consoleQuota = consoleQuota;
        this.props.setProperty("robocode.console.quota", "" + consoleQuota);
    }

    @Override
    public long getCpuConstant() {
        return this.cpuConstant;
    }

    @Override
    public void setCpuConstant(long cpuConstant) {
        this.cpuConstant = cpuConstant;
        this.props.setProperty("robocode.cpu.constant", "" + cpuConstant);
    }

    @Override
    public Collection<String> getOptionsDevelopmentPaths() {
        return new HashSet<String>(this.optionsDevelopmentPaths);
    }

    @Override
    public void setOptionsDevelopmentPaths(Collection<String> paths) {
        this.optionsDevelopmentPaths = new HashSet<String>(paths);
        this.props.setProperty("robocode.options.development.path", SettingsManager.toCommaSeparatedString(paths));
    }

    @Override
    public Collection<String> getOptionsExcludedDevelopmentPaths() {
        return new HashSet<String>(this.optionsExcludedDevelopmentPaths);
    }

    @Override
    public void setOptionsExcludedDevelopmentPaths(Collection<String> paths) {
        this.optionsExcludedDevelopmentPaths = new HashSet<String>(paths);
        this.props.setProperty("robocode.options.development.path.excluded", SettingsManager.toCommaSeparatedString(paths));
    }

    @Override
    public Collection<String> getOptionsEnabledDevelopmentPaths() {
        Collection<String> paths = this.getOptionsDevelopmentPaths();
        paths.removeAll(this.getOptionsExcludedDevelopmentPaths());
        return paths;
    }

    @Override
    public boolean getOptionsCommonShowResults() {
        return this.optionsCommonShowResults;
    }

    @Override
    public void setOptionsCommonAppendWhenSavingResults(boolean enable) {
        this.optionsCommonAppendWhenSavingResults = enable;
        this.props.setProperty("robocode.options.common.appendWhenSavingResults", "" + enable);
    }

    @Override
    public boolean getOptionsCommonAppendWhenSavingResults() {
        return this.optionsCommonAppendWhenSavingResults;
    }

    @Override
    public void setOptionsCommonShowResults(boolean enable) {
        this.optionsCommonShowResults = enable;
        this.props.setProperty("robocode.options.common.showResults", "" + enable);
    }

    @Override
    public boolean getOptionsCommonDontHideRankings() {
        return this.optionsCommonDontHideRankings;
    }

    @Override
    public void setOptionsCommonDontHideRankings(boolean enable) {
        this.optionsCommonDontHideRankings = enable;
        this.props.setProperty("robocode.options.common.dontHideRankings", "" + enable);
    }

    @Override
    public boolean getOptionsCommonEnableReplayRecording() {
        return this.optionsCommonEnableReplayRecording;
    }

    @Override
    public void setOptionsCommonEnableReplayRecording(boolean enable) {
        this.optionsCommonEnableReplayRecording = enable;
        this.props.setProperty("robocode.options.common.enableReplayRecording", "" + enable);
    }

    @Override
    public boolean getOptionsCommonEnableAutoRecording() {
        return this.optionsCommonEnableAutoRecording;
    }

    @Override
    public boolean getOptionsCommonAutoRecordingXML() {
        return this.optionsCommonAutoRecordingXML;
    }

    @Override
    public void setOptionsCommonEnableAutoRecording(boolean enable) {
        this.optionsCommonEnableAutoRecording = enable;
        this.props.setProperty("robocode.options.common.enableAutoRecording", "" + enable);
    }

    @Override
    public void setOptionsCommonEnableAutoRecordingXML(boolean enable) {
        this.optionsCommonAutoRecordingXML = enable;
        this.props.setProperty("robocode.options.common.autoRecordingXML", "" + enable);
    }

    @Override
    public void setOptionsCommonNotifyAboutNewBetaVersions(boolean enable) {
        this.optionsCommonNotifyAboutNewBetaVersions = enable;
        this.props.setProperty("robocode.options.common.notifyAboutNewBetaVersions", "" + enable);
    }

    @Override
    public boolean getOptionsCommonNotifyAboutNewBetaVersions() {
        return this.optionsCommonNotifyAboutNewBetaVersions;
    }

    @Override
    public int getBattleDefaultBattlefieldWidth() {
        return this.battleDefaultBattlefieldWidth;
    }

    @Override
    public void setBattleDefaultBattlefieldWidth(int battlefieldWidth) {
        this.battleDefaultBattlefieldWidth = Math.max(400, battlefieldWidth);
        this.props.setProperty("robocode.battle.default.battlefieldWidth", "" + this.battleDefaultBattlefieldWidth);
    }

    @Override
    public int getBattleDefaultBattlefieldHeight() {
        return this.battleDefaultBattlefieldHeight;
    }

    @Override
    public void setBattleDefaultBattlefieldHeight(int battlefieldHeight) {
        this.battleDefaultBattlefieldHeight = Math.max(400, battlefieldHeight);
        this.props.setProperty("robocode.battle.default.battlefieldHeight", "" + this.battleDefaultBattlefieldHeight);
    }

    @Override
    public double getBattleDefaultGunCoolingRate() {
        return this.battleDefaultGunCoolingRate;
    }

    @Override
    public void setBattleDefaultGunCoolingRate(double gunCoolingRate) {
        this.battleDefaultGunCoolingRate = Math.max(0.1, gunCoolingRate);
        this.props.setProperty("robocode.battle.default.gunCoolingRate", "" + this.battleDefaultGunCoolingRate);
    }

    @Override
    public long getBattleDefaultInactivityTime() {
        return this.battleDefaultInactivityTime;
    }

    @Override
    public void setBattleDefaultInactivityTime(long inactivityTime) {
        this.battleDefaultInactivityTime = Math.max(0L, inactivityTime);
        this.props.setProperty("robocode.battle.default.inactivityTime", "" + this.battleDefaultInactivityTime);
    }

    @Override
    public int getBattleDefaultSentryBorderSize() {
        return this.battleDefaultSentryBorderSize;
    }

    @Override
    public void setBattleDefaultSentryBorderSize(int sentryBorderSize) {
        this.battleDefaultSentryBorderSize = sentryBorderSize;
        this.props.setProperty("robocode.battle.default.sentryBorderSize", "" + this.battleDefaultSentryBorderSize);
    }

    @Override
    public boolean getBattleDefaultHideEnemyNames() {
        return this.battleDefaultHideEnemyNames;
    }

    @Override
    public void setBattleDefaultHideEnemyNames(boolean hideEnemyNames) {
        this.battleDefaultHideEnemyNames = hideEnemyNames;
        this.props.setProperty("robocode.battle.default.hideEnemyNames", "" + this.battleDefaultHideEnemyNames);
    }

    @Override
    public int getBattleDefaultNumberOfRounds() {
        return this.battleDefaultNumberOfRounds;
    }

    @Override
    public void setBattleDefaultNumberOfRounds(int numberOfRounds) {
        this.battleDefaultNumberOfRounds = Math.max(1, numberOfRounds);
        this.props.setProperty("robocode.battle.default.numberOfBattles", "" + this.battleDefaultNumberOfRounds);
    }

    @Override
    public void store(FileOutputStream out, String desc) throws IOException {
        this.props.store(out, desc);
    }

    @Override
    public void load(FileInputStream in) throws IOException {
        this.props.load(in);
        this.optionsViewRobotNames = Boolean.valueOf(this.props.getProperty("robocode.options.view.robotNames", "true"));
        this.optionsViewScanArcs = Boolean.valueOf(this.props.getProperty("robocode.options.view.scanArcs", "false"));
        this.optionsViewRobotEnergy = Boolean.valueOf(this.props.getProperty("robocode.options.view.robotEnergy", "true"));
        this.optionsViewGround = Boolean.valueOf(this.props.getProperty("robocode.options.view.ground", "true"));
        this.optionsViewTPS = Boolean.valueOf(this.props.getProperty("robocode.options.view.TPS", "true"));
        this.optionsViewFPS = Boolean.valueOf(this.props.getProperty("robocode.options.view.FPS", "true"));
        this.optionsViewExplosions = Boolean.valueOf(this.props.getProperty("robocode.options.view.explosions", "true"));
        this.optionsViewExplosionDebris = Boolean.valueOf(this.props.getProperty("robocode.options.view.explosionDebris", "true"));
        this.optionsViewSentryBorder = Boolean.valueOf(this.props.getProperty("robocode.options.view.sentryBorder", "false"));
        this.optionsViewPreventSpeedupWhenMinimized = Boolean.valueOf(this.props.getProperty("robocode.options.view.preventSpeedupWhenMinimized", "false"));
        this.optionsBattleDesiredTPS = Integer.parseInt(this.props.getProperty("robocode.options.battle.desiredTPS", "30"));
        this.setOptionsRenderingAntialiasing(Integer.parseInt(this.props.getProperty("robocode.options.rendering.antialiasing", "0")));
        this.setOptionsRenderingTextAntialiasing(Integer.parseInt(this.props.getProperty("robocode.options.rendering.text.antialiasing", "0")));
        this.setOptionsRenderingMethod(Integer.parseInt(this.props.getProperty("robocode.options.rendering.method", "0")));
        this.optionsRenderingNoBuffers = Integer.parseInt(this.props.getProperty("robocode.options.rendering.noBuffers", "2"));
        this.optionsRenderingBufferImages = Boolean.valueOf(this.props.getProperty("robocode.options.rendering.bufferImages", "true"));
        this.optionsRenderingForceBulletColor = Boolean.valueOf(this.props.getProperty("robocode.options.rendering.forceBulletColor", "false"));
        this.optionsSoundEnableSound = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableSound", "false"));
        this.optionsSoundEnableGunshot = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableGunshot", "true"));
        this.optionsSoundEnableBulletHit = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableBulletHit", "true"));
        this.optionsSoundEnableRobotDeath = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableRobotDeath", "true"));
        this.optionsSoundEnableRobotCollision = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableRobotCollision", "true"));
        this.optionsSoundEnableWallCollision = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableWallCollision", "true"));
        this.optionsSoundMixer = this.props.getProperty("robocode.options.sound.mixer", "DirectAudioDevice");
        this.optionsSoundEnableMixerVolume = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableMixerVolume", "true"));
        this.optionsSoundEnableMixerPan = Boolean.valueOf(this.props.getProperty("robocode.options.sound.enableMixerPan", "true"));
        this.optionsDevelopmentPaths = SettingsManager.fromCommaSeparatedString(this.props.getProperty("robocode.options.development.path", System.getProperty("robocode.options.development.path")));
        this.optionsExcludedDevelopmentPaths = SettingsManager.fromCommaSeparatedString(this.props.getProperty("robocode.options.development.path.excluded", ""));
        this.optionsCommonNotifyAboutNewBetaVersions = Boolean.valueOf(this.props.getProperty("robocode.options.common.notifyAboutNewBetaVersions", "false"));
        this.optionsCommonShowResults = Boolean.valueOf(this.props.getProperty("robocode.options.common.showResults", "true"));
        this.optionsCommonAppendWhenSavingResults = Boolean.valueOf(this.props.getProperty("robocode.options.common.appendWhenSavingResults", "true"));
        this.optionsCommonDontHideRankings = Boolean.valueOf(this.props.getProperty("robocode.options.common.dontHideRankings", "true"));
        this.optionsCommonEnableReplayRecording = Boolean.valueOf(this.props.getProperty("robocode.options.common.enableReplayRecording", "false"));
        this.optionsCommonEnableAutoRecording = Boolean.valueOf(this.props.getProperty("robocode.options.common.enableAutoRecording", "false"));
        this.optionsCommonAutoRecordingXML = Boolean.valueOf(this.props.getProperty("robocode.options.common.autoRecordingXML", "false"));
        this.optionsTeamShowTeamRobots = Boolean.valueOf(this.props.getProperty("robocode.options.team.showTeamRobots", "false"));
        this.fileThemeMusic = this.props.getProperty("robocode.file.music.theme");
        this.fileBackgroundMusic = this.props.getProperty("robocode.file.music.background");
        this.fileEndOfBattleMusic = this.props.getProperty("robocode.file.music.endOfBattle");
        this.fileGunshotSfx = this.props.getProperty("robocode.file.sfx.gunshot", DEFAULT_FILE_GUNSHOT_SFX);
        this.fileRobotCollisionSfx = this.props.getProperty("robocode.file.sfx.robotCollision", "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav");
        this.fileWallCollisionSfx = this.props.getProperty("robocode.file.sfx.wallCollision", "/net/sf/robocode/sound/sounds/13831_adcbicycle_22.wav");
        this.fileRobotDeathSfx = this.props.getProperty("robocode.file.sfx.robotDeath", DEFAULT_FILE_ROBOT_DEATH_SFX);
        this.fileBulletHitsRobotSfx = this.props.getProperty("robocode.file.sfx.bulletHitsRobot", "/net/sf/robocode/sound/sounds/shellhit.wav");
        this.fileBulletHitsBulletSfx = this.props.getProperty("robocode.file.sfx.bulletHitsBullet", "/net/sf/robocode/sound/sounds/shellhit.wav");
        this.lastRunVersion = this.props.getProperty("robocode.version.lastrun", "");
        this.props.remove("robocode.cpu.constant.1000");
        try {
            this.versionChecked = this.dateFormat.parse(this.props.getProperty("robocode.versionchecked"));
        }
        catch (Exception e) {
            Logger.logMessage((String)"Initializing version check date.");
            this.setVersionChecked(new Date());
        }
        this.battleDefaultBattlefieldWidth = Integer.parseInt(this.props.getProperty("robocode.battle.default.battlefieldWidth", "800"));
        this.battleDefaultBattlefieldHeight = Integer.parseInt(this.props.getProperty("robocode.battle.default.battlefieldHeight", "600"));
        this.battleDefaultGunCoolingRate = Double.parseDouble(this.props.getProperty("robocode.battle.default.gunCoolingRate", "0.1"));
        this.battleDefaultInactivityTime = Long.parseLong(this.props.getProperty("robocode.battle.default.inactivityTime", "450"));
        this.battleDefaultHideEnemyNames = Boolean.parseBoolean(this.props.getProperty("robocode.battle.default.hideEnemyNames", "false"));
        this.battleDefaultNumberOfRounds = Integer.parseInt(this.props.getProperty("robocode.battle.default.numberOfBattles", "10"));
        this.robotFilesystemQuota = Long.parseLong(this.props.getProperty("robocode.robot.filesystem.quota", "200000"));
        this.consoleQuota = Long.parseLong(this.props.getProperty("robocode.console.quota", "8192"));
        this.cpuConstant = Long.parseLong(this.props.getProperty("robocode.cpu.constant", "-1"));
    }

    @Override
    public String getLastRunVersion() {
        return this.lastRunVersion;
    }

    @Override
    public void setLastRunVersion(String lastRunVersion) {
        this.lastRunVersion = lastRunVersion;
        this.props.setProperty("robocode.version.lastrun", "" + lastRunVersion);
    }

    @Override
    public void addPropertyListener(ISettingsListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removePropertyListener(ISettingsListener propertyListener) {
        this.listeners.remove(propertyListener);
    }

    private void notifyPropertyChanged(String name) {
        for (ISettingsListener listener : this.listeners) {
            try {
                listener.settingChanged(name);
            }
            catch (Exception e) {
                Logger.logError((Throwable)e);
            }
        }
    }

    private static String toCommaSeparatedString(Collection<String> strings) {
        if (strings == null || strings.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            sb.append(s).append(',');
        }
        String line = sb.toString();
        return line.substring(0, line.length() - 1);
    }

    private static Collection<String> fromCommaSeparatedString(String line) {
        String[] strings;
        if (line == null || line.trim().length() == 0) {
            return new HashSet<String>();
        }
        HashSet<String> set = new HashSet<String>();
        String splitExpr = File.pathSeparatorChar == ':' ? "[,:]+" : "[,;]+";
        for (String s : strings = line.split(splitExpr)) {
            set.add(s);
        }
        return set;
    }

    private class SortedProperties
    extends Properties {
        private static final long serialVersionUID = 1L;

        private SortedProperties() {
        }

        @Override
        public Enumeration<Object> keys() {
            Enumeration<Object> keysEnum = super.keys();
            Vector<String> keyList = new Vector<String>();
            while (keysEnum.hasMoreElements()) {
                keyList.add((String)keysEnum.nextElement());
            }
            Collections.sort(keyList);
            return keyList.elements();
        }

        @Override
        public synchronized Object setProperty(String key, String value) {
            String old = super.getProperty(key, null);
            boolean notify = old == null && value != null || old != null && !old.equals(value);
            Object res = super.setProperty(key, value);
            if (notify) {
                SettingsManager.this.notifyPropertyChanged(key);
            }
            return res;
        }
    }
}

