/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.serialization;

import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.StringCharacterIterator;
import java.util.Locale;

public class CsvWriter {
    private static final DecimalFormat decimalFormat = new DecimalFormat("#.####", new DecimalFormatSymbols(Locale.US));
    private Writer writer;
    private boolean header;
    private boolean isStartLine;

    public CsvWriter(Writer writer, boolean header) {
        this.writer = writer;
        this.header = header;
    }

    public void startDocument(String header) throws IOException {
        this.writer.write(header);
        this.writer.write(10);
        this.isStartLine = true;
    }

    public void writeValue(String value) throws IOException {
        this.writeRaw(CsvWriter.encode(value));
    }

    public void writeValue(boolean value) throws IOException {
        this.writeRaw(Boolean.toString(value));
    }

    public void writeValue(long value) throws IOException {
        this.writeRaw(Long.toString(value));
    }

    public void writeValue(double value, boolean trim) throws IOException {
        if (trim) {
            this.writeRaw(decimalFormat.format(value));
        } else {
            this.writeRaw(Double.toString(value));
        }
    }

    public void endLine() throws IOException {
        this.writer.write("\r\n");
        this.isStartLine = true;
    }

    private void writeRaw(String value) throws IOException {
        if (this.isStartLine) {
            this.isStartLine = false;
        } else {
            this.writer.write(44);
        }
        if (value != null) {
            this.writer.write(value);
        }
    }

    private static String encode(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '\n') {
                result.append(" ");
            } else if (character == '\r') {
                result.append(" ");
            } else if (character == '\"') {
                result.append("'");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }
}

