/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.battle;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.table.AbstractTableModel;
import net.sf.robocode.io.Logger;
import robocode.BattleResults;

public class BattleResultsTableModel
extends AbstractTableModel {
    private String title;
    private final BattleResults[] results;
    private final int numRounds;
    private final double totalScore;

    public BattleResultsTableModel(BattleResults[] results, int numRounds) {
        this.results = results;
        this.numRounds = numRounds;
        this.totalScore = this.countTotalScore();
    }

    private double countTotalScore() {
        double totalScore = 0.0;
        for (BattleResults result : this.results) {
            totalScore += (double)result.getScore();
        }
        return totalScore;
    }

    @Override
    public int getColumnCount() {
        return 12;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return "Rank";
            }
            case 1: {
                return "Robot Name";
            }
            case 2: {
                return "    Total Score    ";
            }
            case 3: {
                return "Survival";
            }
            case 4: {
                return "Surv Bonus";
            }
            case 5: {
                return "Bullet Dmg";
            }
            case 6: {
                return "Bullet Bonus";
            }
            case 7: {
                return "Ram Dmg * 2";
            }
            case 8: {
                return "Ram Bonus";
            }
            case 9: {
                return " 1sts ";
            }
            case 10: {
                return " 2nds ";
            }
            case 11: {
                return " 3rds ";
            }
        }
        return "";
    }

    @Override
    public int getRowCount() {
        return this.results.length;
    }

    public String getTitle() {
        if (this.title == null) {
            int round = this.numRounds;
            this.title = "Results for " + round + " round";
            if (round > 1) {
                this.title = this.title + 's';
            }
        }
        return this.title;
    }

    @Override
    public Object getValueAt(int row, int col) {
        BattleResults statistics = this.results[row];
        switch (col) {
            case 0: {
                int place;
                for (place = row + 1; place < this.getRowCount() && statistics.getScore() == this.results[place].getScore(); ++place) {
                }
                return BattleResultsTableModel.getPlacementString(place);
            }
            case 1: {
                return statistics.getTeamLeaderName();
            }
            case 2: {
                String percent = "";
                if (this.totalScore != 0.0) {
                    percent = " (" + NumberFormat.getPercentInstance().format((double)statistics.getScore() / this.totalScore) + ")";
                }
                return "" + (int)((double)statistics.getScore() + 0.5) + percent;
            }
            case 3: {
                return "" + (int)((double)statistics.getSurvival() + 0.5);
            }
            case 4: {
                return "" + (int)((double)statistics.getLastSurvivorBonus() + 0.5);
            }
            case 5: {
                return "" + (int)((double)statistics.getBulletDamage() + 0.5);
            }
            case 6: {
                return "" + (int)((double)statistics.getBulletDamageBonus() + 0.5);
            }
            case 7: {
                return "" + (int)((double)statistics.getRamDamage() + 0.5);
            }
            case 8: {
                return "" + (int)((double)statistics.getRamDamageBonus() + 0.5);
            }
            case 9: {
                return "" + statistics.getFirsts();
            }
            case 10: {
                return "" + statistics.getSeconds();
            }
            case 11: {
                return "" + statistics.getThirds();
            }
        }
        return "";
    }

    public void print(PrintStream out) {
        out.println(this.getTitle());
        for (int col = 1; col < this.getColumnCount(); ++col) {
            out.print(this.getColumnName(col) + "\t");
        }
        out.println();
        for (int row = 0; row < this.getRowCount(); ++row) {
            out.print(this.getValueAt(row, 0) + ": ");
            for (int col = 1; col < this.getColumnCount(); ++col) {
                out.print(this.getValueAt(row, col) + "\t");
            }
            out.println();
        }
    }

    public void saveToFile(String filename, boolean append) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(filename, append));
            out.println(DateFormat.getDateTimeInstance().format(new Date()));
            out.println(this.getTitle());
            for (int col = 0; col < this.getColumnCount(); ++col) {
                if (col > 0) {
                    out.print(',');
                }
                out.print(this.getColumnName(col));
            }
            out.println();
            for (int row = 0; row < this.getRowCount(); ++row) {
                for (int col = 0; col < this.getColumnCount(); ++col) {
                    if (col > 0) {
                        out.print(',');
                    }
                    out.print(this.getValueAt(row, col));
                }
                out.println();
            }
            out.println("$");
            out.close();
        }
        catch (IOException e) {
            Logger.logError((Throwable)e);
        }
    }

    private static String getPlacementString(int i) {
        String result = "" + i;
        result = i > 3 && i < 20 ? result + "th" : (i % 10 == 1 ? result + "st" : (i % 10 == 2 ? result + "nd" : (i % 10 == 3 ? result + "rd" : result + "th")));
        return result;
    }
}

