/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.peer;

import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.robocode.serialization.ISerializableHelper;
import net.sf.robocode.serialization.RbSerializer;

public class BulletStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final int bulletId;
    public final String victimName;
    public final boolean isActive;
    public final double x;
    public final double y;

    public BulletStatus(int bulletId, double x, double y, String victimName, boolean isActive) {
        this.bulletId = bulletId;
        this.x = x;
        this.y = y;
        this.isActive = isActive;
        this.victimName = victimName;
    }

    static ISerializableHelper createHiddenSerializer() {
        return new SerializableHelper();
    }

    private static class SerializableHelper
    implements ISerializableHelper {
        private SerializableHelper() {
        }

        public int sizeOf(RbSerializer serializer, Object object) {
            BulletStatus obj = (BulletStatus)object;
            return 5 + serializer.sizeOf(obj.victimName) + 1 + 16;
        }

        public void serialize(RbSerializer serializer, ByteBuffer buffer, Object object) {
            BulletStatus obj = (BulletStatus)object;
            serializer.serialize(buffer, obj.bulletId);
            serializer.serialize(buffer, obj.victimName);
            serializer.serialize(buffer, obj.isActive);
            serializer.serialize(buffer, obj.x);
            serializer.serialize(buffer, obj.y);
        }

        public Object deserialize(RbSerializer serializer, ByteBuffer buffer) {
            int bulletId = buffer.getInt();
            String victimName = serializer.deserializeString(buffer);
            boolean isActive = serializer.deserializeBoolean(buffer);
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            return new BulletStatus(bulletId, x, y, victimName, isActive);
        }
    }
}

