/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.version;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.io.RobocodeProperties;
import net.sf.robocode.settings.ISettingsManager;
import net.sf.robocode.version.IVersionManager;
import net.sf.robocode.version.Version;

public final class VersionManager
implements IVersionManager {
    private static final String VERSIONS_TXT = "versions.md";
    private static final String UNKNOWN_VERSION = "unknown";
    private static Version version;
    private final boolean versionChanged;

    public VersionManager(ISettingsManager settingsManager) {
        if (settingsManager != null) {
            boolean bl = this.versionChanged = !settingsManager.getLastRunVersion().equals(this.getVersion());
            if (this.versionChanged) {
                settingsManager.setLastRunVersion(this.getVersion());
            }
        } else {
            this.versionChanged = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public String checkForNewVersion() {
        String newVersLine;
        block9: {
            newVersLine = null;
            InputStream inputStream = null;
            InputStreamReader inputStreamReader = null;
            BufferedReader reader = null;
            try {
                URL url = new URL("https://robocode.sourceforge.io/version/version.html");
                URLConnection urlConnection = url.openConnection();
                urlConnection.setConnectTimeout(5000);
                if (urlConnection instanceof HttpURLConnection) {
                    Logger.logMessage((String)"Update checking with http.");
                    HttpURLConnection h = (HttpURLConnection)urlConnection;
                    if (h.usingProxy()) {
                        Logger.logMessage((String)"http using proxy.");
                    }
                }
                inputStream = urlConnection.getInputStream();
                inputStreamReader = new InputStreamReader(inputStream);
                reader = new BufferedReader(inputStreamReader);
                newVersLine = reader.readLine();
                FileUtil.cleanupStream((Object)inputStream);
            }
            catch (MalformedURLException e) {
                Logger.logError((String)"Unable to check for new version", (Throwable)e);
                newVersLine = null;
                break block9;
            }
            catch (IOException e2) {
                Logger.logError((String)"Unable to check for new version", (Throwable)e2);
                newVersLine = null;
                break block9;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                FileUtil.cleanupStream(inputStream);
                FileUtil.cleanupStream(inputStreamReader);
                FileUtil.cleanupStream(reader);
            }
            FileUtil.cleanupStream((Object)inputStreamReader);
            FileUtil.cleanupStream((Object)reader);
        }
        return newVersLine;
    }

    public String getVersion() {
        return VersionManager.getVersionInstance().toString();
    }

    private static Version getVersionInstance() {
        if (version == null) {
            version = new Version(VersionManager.getVersionFromJar());
        }
        return version;
    }

    public boolean isLastRunVersionChanged() {
        return this.versionChanged;
    }

    public String getVersionN() {
        Version v = VersionManager.getVersionInstance();
        return v.getMajor() + "." + v.getMinor() + "." + v.getRevision() + "." + v.getBuild();
    }

    public int getVersionAsInt() {
        Version v = VersionManager.getVersionInstance();
        return (v.getMajor() << 24) + (v.getMinor() << 16) + (v.getRevision() << 8) + v.getBuild();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionFromJar() {
        String versionString = null;
        BufferedReader in = null;
        try {
            URL versionsUrl = VersionManager.class.getResource("/versions.md");
            if (versionsUrl == null) {
                Logger.logError((String)"The URL for the versions.md was not found");
                versionString = UNKNOWN_VERSION;
            } else {
                URLConnection connection = versionsUrl.openConnection();
                connection.setUseCaches(false);
                InputStream is = connection.getInputStream();
                in = new BufferedReader(new InputStreamReader(is));
                versionString = in.readLine();
                while (versionString != null && !versionString.startsWith("## Version ")) {
                    versionString = in.readLine();
                }
            }
        }
        catch (FileNotFoundException e) {
            Logger.logError((String)"No versions.md file in robocode.jar");
            versionString = UNKNOWN_VERSION;
        }
        catch (IOException e) {
            Logger.logError((String)("Error while reading versions.md from robocode.jar: " + e));
            versionString = UNKNOWN_VERSION;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        String version = UNKNOWN_VERSION;
        if (versionString != null && !versionString.equals(UNKNOWN_VERSION)) {
            try {
                version = VersionManager.versionFileLineToVersion(versionString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (version.equals(UNKNOWN_VERSION)) {
            Logger.logWarning((String)"Getting version from file");
            return VersionManager.getVersionFromFile();
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getVersionFromFile() {
        String versionString = null;
        InputStreamReader fileReader = null;
        BufferedReader in = null;
        try {
            File dir = FileUtil.getCwd();
            if (RobocodeProperties.isTestingOn()) {
                dir = dir.getParentFile();
            }
            fileReader = new FileReader(new File(dir, VERSIONS_TXT));
            in = new BufferedReader(fileReader);
            versionString = in.readLine();
        }
        catch (FileNotFoundException e) {
            Logger.logError((String)"No versions.md file.");
            versionString = UNKNOWN_VERSION;
        }
        catch (IOException e) {
            Logger.logError((String)"IO Exception reading versions.md", (Throwable)e);
            versionString = UNKNOWN_VERSION;
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {}
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        String version = UNKNOWN_VERSION;
        if (versionString != null && !versionString.equals(UNKNOWN_VERSION)) {
            try {
                version = VersionManager.versionFileLineToVersion(versionString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return version;
    }

    private static String versionFileLineToVersion(String versionFileLine) {
        String version = versionFileLine.substring("## Version ".length());
        int index = version.indexOf(40);
        if (index >= 0) {
            version = version.substring(0, index);
        }
        return version.trim();
    }
}

