/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.core;

import java.io.File;
import java.io.IOException;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import robocode.control.events.IBattleListener;

public abstract class RobocodeMainBase
implements Runnable {
    public abstract void loadSetup(String[] var1);

    public abstract void initForRobocodeEngine(IBattleListener var1);

    public abstract void cleanup();

    public static void robocodeMain(Object args) {
        RobocodeMainBase main = Container.getComponent(RobocodeMainBase.class);
        main.loadSetup((String[])args);
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                Logger.logError((String)("UncaughtException on thread " + t.getClass()), (Throwable)e);
            }
        });
        ThreadGroup group = new ThreadGroup("Robocode thread group");
        new Thread(group, main, "Robocode main thread").start();
    }

    public static void initContainer() {
        Container.init();
    }

    public static void cleanupForRobocodeEngine() {
        RobocodeMainBase main = Container.getComponent(RobocodeMainBase.class);
        main.cleanup();
    }

    public static void initContainerForRobocodeEngine(File robocodeHome, IBattleListener listener) {
        try {
            if (robocodeHome == null) {
                robocodeHome = FileUtil.getCwd();
            }
            FileUtil.setCwd((File)robocodeHome);
            File robotsDir = FileUtil.getRobotsDir();
            if (robotsDir == null) {
                throw new RuntimeException("No valid robot directory is specified");
            }
            if (!robotsDir.exists() || !robotsDir.isDirectory()) {
                throw new RuntimeException('\'' + robotsDir.getAbsolutePath() + "' is not a valid robot directory");
            }
        }
        catch (IOException e) {
            System.err.println(e);
            return;
        }
        RobocodeMainBase main = Container.getComponent(RobocodeMainBase.class);
        main.initForRobocodeEngine(listener);
    }
}

