/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.cachecleaner;

import java.io.File;
import java.io.IOException;
import net.sf.robocode.core.Container;
import net.sf.robocode.io.FileUtil;
import net.sf.robocode.io.Logger;
import net.sf.robocode.repository.IRepositoryManager;

public final class CacheCleaner {
    private CacheCleaner() {
    }

    public static void main(String[] args) {
        CacheCleaner.clean();
    }

    public static void clean() {
        File roborumbleTempFile = new File("roborumble/temp");
        CacheCleaner.deleteFile(roborumbleTempFile.getPath());
        CacheCleaner.deleteFile(FileUtil.getRobotsDataDir().getPath());
        CacheCleaner.deleteFile(FileUtil.getRobotDatabaseFile().getPath());
        FileUtil.createDir((File)roborumbleTempFile);
        IRepositoryManager repositoryManager = Container.getComponent(IRepositoryManager.class);
        repositoryManager.reload(true);
        Logger.logMessage((String)"Cleaning done.");
    }

    private static void deleteFile(String filename) {
        Logger.logMessage((String)("Deleting " + filename + "..."));
        try {
            CacheCleaner.recursivelyDelete(new File(filename));
        }
        catch (IOException ex) {
            Logger.logError((String)ex.getMessage());
        }
    }

    private static void recursivelyDelete(File file) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] files;
                for (File f : files = file.listFiles()) {
                    CacheCleaner.recursivelyDelete(f);
                }
            }
            if (!file.delete()) {
                throw new IOException("Failed deleting file: " + file.getPath());
            }
        }
    }
}

