/*
 * Decompiled with CFR 0.152.
 */
package net.sf.robocode.host;

import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlException;
import net.sf.robocode.host.IHost;
import net.sf.robocode.host.IHostManager;
import net.sf.robocode.host.IRobotClassLoader;
import net.sf.robocode.host.RobotStatics;
import net.sf.robocode.host.proxies.AdvancedRobotProxy;
import net.sf.robocode.host.proxies.BasicRobotProxy;
import net.sf.robocode.host.proxies.IHostingRobotProxy;
import net.sf.robocode.host.proxies.JuniorRobotProxy;
import net.sf.robocode.host.proxies.StandardRobotProxy;
import net.sf.robocode.host.proxies.TeamRobotProxy;
import net.sf.robocode.host.security.RobotClassLoader;
import net.sf.robocode.io.Logger;
import net.sf.robocode.peer.IRobotPeer;
import net.sf.robocode.peer.IRobotStatics;
import net.sf.robocode.repository.IRobotItem;
import net.sf.robocode.repository.RobotType;
import net.sf.robocode.security.HiddenAccess;
import robocode.BorderSentry;
import robocode.Droid;
import robocode.Robot;
import robocode.control.RobotSpecification;
import robocode.robotinterfaces.IAdvancedRobot;
import robocode.robotinterfaces.IBasicRobot;
import robocode.robotinterfaces.IInteractiveRobot;
import robocode.robotinterfaces.IJuniorRobot;
import robocode.robotinterfaces.IPaintRobot;
import robocode.robotinterfaces.ITeamRobot;

public class JavaHost
implements IHost {
    public IRobotClassLoader createLoader(IRobotItem robotItem) {
        return new RobotClassLoader(robotItem.getClassPathURL(), robotItem.getFullClassName());
    }

    @Override
    public IHostingRobotProxy createRobotProxy(IHostManager hostManager, RobotSpecification robotSpecification, IRobotStatics statics, IRobotPeer peer) {
        BasicRobotProxy robotProxy;
        IRobotItem specification = (IRobotItem)HiddenAccess.getFileSpecification((RobotSpecification)robotSpecification);
        if (specification.isTeamRobot()) {
            robotProxy = new TeamRobotProxy(specification, hostManager, peer, (RobotStatics)statics);
        } else if (specification.isAdvancedRobot()) {
            robotProxy = new AdvancedRobotProxy(specification, hostManager, peer, (RobotStatics)statics);
        } else if (specification.isStandardRobot()) {
            robotProxy = new StandardRobotProxy(specification, hostManager, peer, (RobotStatics)statics);
        } else if (specification.isJuniorRobot()) {
            robotProxy = new JuniorRobotProxy(specification, hostManager, peer, (RobotStatics)statics);
        } else {
            throw new AccessControlException("Unknown robot type");
        }
        return robotProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getReferencedClasses(IRobotItem robotItem) {
        IRobotClassLoader loader = null;
        try {
            loader = this.createLoader(robotItem);
            loader.loadRobotMainClass(true);
            String[] stringArray = loader.getReferencedClasses();
            return stringArray;
        }
        catch (ClassNotFoundException e) {
            Logger.logError((Throwable)e);
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            if (loader != null) {
                loader.cleanup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RobotType getRobotType(IRobotItem robotItem, boolean resolve, boolean message) {
        IRobotClassLoader loader = null;
        try {
            loader = this.createLoader(robotItem);
            Class robotClass = loader.loadRobotMainClass(resolve);
            if (robotClass == null || Modifier.isAbstract(robotClass.getModifiers())) {
                RobotType robotType = RobotType.INVALID;
                return robotType;
            }
            RobotType robotType = this.checkInterfaces(robotClass, robotItem);
            return robotType;
        }
        catch (Throwable t) {
            if (message) {
                Logger.logError((String)("Got an error with " + robotItem.getFullClassName() + ": " + t));
                if (t.getMessage() != null && t.getMessage().contains("Bad version number in .class file")) {
                    Logger.logError((String)"Maybe robot was compiled with a newer Java version the Java version used for running Robocode?");
                }
            }
            RobotType robotType = RobotType.INVALID;
            return robotType;
        }
        finally {
            if (loader != null) {
                loader.cleanup();
            }
        }
    }

    private RobotType checkInterfaces(Class<?> robotClass, IRobotItem robotItem) {
        boolean isJuniorRobot = false;
        boolean isStandardRobot = false;
        boolean isInteractiveRobot = false;
        boolean isPaintRobot = false;
        boolean isAdvancedRobot = false;
        boolean isTeamRobot = false;
        boolean isDroid = false;
        boolean isSentryRobot = false;
        if (IAdvancedRobot.class.isAssignableFrom(robotClass)) {
            isAdvancedRobot = true;
        }
        if (Robot.class.isAssignableFrom(robotClass) && !isAdvancedRobot) {
            isStandardRobot = true;
        }
        if (IJuniorRobot.class.isAssignableFrom(robotClass)) {
            isJuniorRobot = true;
            if (isAdvancedRobot) {
                throw new AccessControlException(robotItem.getFullClassName() + ": Junior robot should not implement IAdvancedRobot interface.");
            }
        }
        if (IBasicRobot.class.isAssignableFrom(robotClass) && !isAdvancedRobot && !isJuniorRobot) {
            isStandardRobot = true;
        }
        if (ITeamRobot.class.isAssignableFrom(robotClass)) {
            isTeamRobot = true;
        }
        if (Droid.class.isAssignableFrom(robotClass)) {
            isDroid = true;
        }
        if (BorderSentry.class.isAssignableFrom(robotClass)) {
            isSentryRobot = true;
        }
        if (IInteractiveRobot.class.isAssignableFrom(robotClass) && (this.checkMethodOverride(robotClass, Robot.class, "getInteractiveEventListener", new Class[0]) || this.checkMethodOverride(robotClass, Robot.class, "onKeyPressed", KeyEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onKeyReleased", KeyEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onKeyTyped", KeyEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseClicked", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseEntered", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseExited", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMousePressed", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseReleased", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseMoved", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseDragged", MouseEvent.class) || this.checkMethodOverride(robotClass, Robot.class, "onMouseWheelMoved", MouseWheelEvent.class))) {
            isInteractiveRobot = true;
        }
        if (IPaintRobot.class.isAssignableFrom(robotClass) && (this.checkMethodOverride(robotClass, Robot.class, "getPaintEventListener", new Class[0]) || this.checkMethodOverride(robotClass, Robot.class, "onPaint", Graphics2D.class))) {
            isPaintRobot = true;
        }
        return new RobotType(isJuniorRobot, isStandardRobot, isInteractiveRobot, isPaintRobot, isAdvancedRobot, isTeamRobot, isDroid, isSentryRobot);
    }

    private boolean checkMethodOverride(Class<?> robotClass, Class<?> knownBase, String name, Class<?> ... parameterTypes) {
        if (knownBase.isAssignableFrom(robotClass)) {
            Method getInteractiveEventListener;
            try {
                getInteractiveEventListener = robotClass.getMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (getInteractiveEventListener.getDeclaringClass().equals(knownBase)) {
                return false;
            }
        }
        return true;
    }
}

