////////////////////////////////////////////////////////////////////////
// Copyright (c) 2018-2020 Saxonica Limited
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0.
// If a copy of the MPL was not distributed with this file, You can
// obtain one at http://mozilla.org/MPL/2.0/.
// This Source Code Form is "Incompatible With Secondary Licenses",
// as defined by the Mozilla Public License, v. 2.0.
////////////////////////////////////////////////////////////////////////

package net.sf.saxon.lib;

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE
// If you edit this file, your edits WILL BE TERMINATED with
// extreme prejudice by the next build.

import net.sf.saxon.trans.RecoveryPolicy;

/**
 * FeatureKeys defines a set of constants, representing the names of Saxon configuration
 * options which can be supplied to the Saxon implementations of the JAXP
 * interfaces TransformerFactory, SchemaFactory, Validator, and ValidationHandler,
 * and to other interfaces such as the s9api {@link net.sf.saxon.s9api.Processor}
 */

public abstract class FeatureKeys {


    /**
    *            <p>ALLOW_EXTERNAL_FUNCTIONS has rather wider effect than the name might suggest.
    *                It controls whether stylesheets are able to access external resources in the server environment.</p>
    *            <p>More specifically, if set to <b>false</b> it disallows all of the
    *                following:</p>
    *            <ul>
    *                <li>With SaxonJ, calls to reflexive Java extension functions</li>
    *                <li>Use of the XSLT <code>system-property()</code> function to access Java system
    *                    properties</li>
    *                <li>Use of the Saxon SQL extension library</li>
    *                <li>Use of the EXPath File library</li>
    *                <li>Use of a URI in the <code>href</code> attribute of an <code>xsl:result-document</code> instruction</li>
    *                <li>Calls to XSLT extension instructions</li>
    *            </ul>
    *            <p>The default value is <b>true</b>. The setting <b>false</b> is recommended in an
    *                environment where untrusted stylesheets may be executed.</p>
    *            <p>This option does not disable use of the <code>doc()</code> function or similar
    *                functions to access the filestore of the machine where the transformation or query
    *                is running. That should be done using a user-supplied <code>URIResolver</code>.</p>
    *            <p>Note that integrated extension functions are trusted; calls to such functions are
    *                allowed even if this configuration option is false. In cases where an integrated
    *                extension function is used to load and execute untrusted code, it should check this
    *                configuration option before doing so.</p>
    *            <p>If the value of the property is false, then it will also be set to false on any new
    *            Configuration created using the <code>fn:transform()</code> function.</p>
    *
    **/

    public final static String ALLOW_EXTERNAL_FUNCTIONS =
        "http://saxon.sf.net/feature/allow-external-functions";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>ALLOW_MULTITHREADING determines whether multi-threading is allowed.</p>
    *            <p>If true (the default), the presence of the attribute <code>saxon:threads="N"</code>
    *                on an <code>xsl:for-each</code> instruction, when running under Saxon-EE, causes
    *                multi-threaded execution. If set to false, the value of the
    *                    <code>saxon:threads</code> argument is ignored.</p>
    *            <p>Setting the value to false also disables asynchronous processing of
    *                    <code>xsl:result-document</code> instructions.</p>
    *            <p>The default value is true if Saxon-EE is in use, false otherwise.</p>
    *
    **/

    public final static String ALLOW_MULTITHREADING =
        "http://saxon.sf.net/feature/allow-multithreading";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>ALLOW_OLD_JAVA_URI_FORMAT determines whether extension function calls to
    *                dynamically-loaded Java extension functions may use the URI format supported in
    *                older Saxon releases.</p>
    *            <p>If the value is false (the default), the only URI format accepted is (for example)
    *                "java:java.util.Date" - that is, a URI consisting of the string "java:" followed by
    *                the Java qualified class name of the class containing the implementation of the
    *                extension function.</p>
    *            <p>If the value is true, then in addition to this format, the following are accepted:
    *                (a) the Java class name on its own ("java.util.Date"), and (b) any URI in which the
    *                Java class name follows the last "/" character (for example
    *                "http://my.com/extensions/java.util.Date"). This last format was originally provided
    *                for compatibility with xt and xalan, but it causes problems because it leads to
    *                unnecessary attempts to load spurious classes when the user did not intend the URI
    *                to represent a dynamically-loaded Java class.</p>
    *
    **/

    public final static String ALLOW_OLD_JAVA_URI_FORMAT =
        "http://saxon.sf.net/feature/allow-old-java-uri-format";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This flag must be set to enable use of extensions to XPath, XQuery and XSLT
    *                syntax that go beyond what is allowed by the extensibility mechanisms in the spec.
    *                In some cases these extensions are experimental and may not be carried forward to future
    *            Saxon releases.</p>
    *            <p>Syntax extensions in Saxon 10 include the use of type aliases (<code>type(...)</code> where
    *                an item type is expected, and <code>declare type NAME = item-type</code> in the XQuery Prolog);
    *                and simple inline functions (for example <code>.{. + 1}</code>).</p>
    *
    **/

    public final static String ALLOW_SYNTAX_EXTENSIONS =
        "http://saxon.sf.net/feature/allowSyntaxExtensions";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>ASSERTIONS_CAN_SEE_COMMENTS determines whether comment and processing instructions in
    *                a document being validated are visible to assertions in an XSD 1.1 schema.</p>
    *            <p>If the value is false (the default), comments and processing instructions are
    *                stripped from the view of the document that is made visible to the XPath expression
    *                that implements the assertion. If this creates adjacent text nodes, they are
    *                collapsed into a single text node.</p>
    *            <p>If the value is true, then comments and processing instructions are visible to the
    *                XPath assertion.</p>
    *
    **/

    public final static String ASSERTIONS_CAN_SEE_COMMENTS =
        "http://saxon.sf.net/feature/assertionsCanSeeComments";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied <code>CollationURIResolver</code> is used to process any collation URIs
    *                found in the query or stylesheet, returning an object of class
    *                    {@link net.sf.saxon.lib.StringCollator} that implements the requested
    *                collation.</p>
    *
    **/

    public final static String COLLATION_URI_RESOLVER =
        "http://saxon.sf.net/feature/collation-uri-resolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied class is instantiated and the resulting instance is used as the value of
    *                the {@link net.sf.saxon.lib.FeatureKeys#COLLATION_URI_RESOLVER} property.</p>
    *
    **/

    public final static String COLLATION_URI_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/collation-uri-resolver-class";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied <code>CollectionFinder</code> is used to retrieve a {@link net.sf.saxon.lib.ResourceCollection} object given by any URI defined in
    *                calls to the <code>collection()</code> or the <code>uri-collection()</code> function.</p>
    *            <p>If the argument is not specified then a default <code>ResourceCollection</code> should be handled.
    *                <code>CollectionFinder</code> returns a {@link net.sf.saxon.lib.ResourceCollection} which is used to map the URI of collection into a
    *                sequence of {@link net.sf.saxon.lib.Resource} objects
    *                (which are then resolved in the same way as URIs passed to the <code>doc()</code>
    *                function), or it may return an item (typically a node but can handle JSON documents).</p>
    *
    **/

    public final static String COLLECTION_FINDER =
        "http://saxon.sf.net/feature/collection-finder";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied class is instantiated and the resulting instance is used as the value of
    *                the {@link net.sf.saxon.lib.FeatureKeys#COLLECTION_FINDER} property.</p>
    *
    **/

    public final static String COLLECTION_FINDER_CLASS =
        "http://saxon.sf.net/feature/collection-finder-class";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>If run-time tracing of stylesheet or query execution is required, then the code must
    *                be compiled with tracing enabled.</p>
    *            <p>Default is false. This option causes code to be
    *                compiled that makes calls to a {@link net.sf.saxon.lib.TraceListener}, but this
    *                has no effect unless a <code>TraceListener</code> is registered at execution
    *                time.</p>
    *
    **/

    public final static String COMPILE_WITH_TRACING =
        "http://saxon.sf.net/feature/compile-with-tracing";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This attribute cannot be set on the {@link net.sf.saxon.Configuration} itself,
    *                but it can be set on various JAXP factory objects such as a
    *                <code>TransformerFactory</code> or <code>DocumentBuilderFactory</code>, to
    *                ensure that several such factories use the same <code>Configuration</code>.</p>
    *            <p>Note that other configuration options are held in the <code>Configuration</code> object,
    *                so setting this attribute will cancel all others that have been set. Also, if two
    *                factories share the same <code>Configuration</code>, then setting an attribute on
    *                one affects all the others.</p>
    *
    **/

    public final static String CONFIGURATION =
        "http://saxon.sf.net/feature/configuration";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Defines a configuration file to be applied to the configuration.</p>
    *            <p>This attribute cannot be set on the {@link net.sf.saxon.Configuration} itself, but it can be
    *                set on various JAXP factory objects such as a <code>TransformerFactory</code> or
    *                    <code>DocumentBuilderFactory</code>. It is particularly useful when running
    *                transformations via the Ant xslt task, where it can be set as follows to define all
    *                configuration settings: </p>
    *            <p><code>&lt;factory name="net.sf.saxon.TransformerFactoryImpl"&gt; &lt;attribute
    *                    name="http://saxon.sf.net/feature/configuration-file"
    *                    value="c:/saxon/config.xml"/&gt; &lt;/factory&gt;</code>
    *            </p>
    *
    **/

    public final static String CONFIGURATION_FILE =
        "http://saxon.sf.net/feature/configuration-file";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option is set to indicate that bytecode generation should be run in debugging
    *                mode; it injects diagnostic tracing calls into the generated bytecode. This should
    *                be used only if requested by Saxonica support to diagnose a problem related to
    *                bytecode generation.</p>
    *
    **/

    public final static String DEBUG_BYTE_CODE =
        "http://saxon.sf.net/feature/debugByteCode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option is relevant only if <code>DISPLAY_BYTE_CODE</code> is set to true. It
    *                defines a directory to which files containing bytecode in human-readable form will
    *                be written. There will be one such file for each generated class, with a filename
    *                designed to give some kind of clue as to its relationship to the source code.</p>
    *            <p>The default value is the directory <code>saxonByteCode</code> within the current
    *                working directory.</p>
    *            <p>The named directory is created if it does not already exist.</p>
    *            <p>Because the generation of class names involves random numbers, files will tend to
    *                accumulate in the supplied directory, even when the same source code is compiled
    *                repeatedly.</p>
    *
    **/

    public final static String DEBUG_BYTE_CODE_DIR =
        "http://saxon.sf.net/feature/debugByteCodeDir";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option determines the collation that is used for comparing strings when no
    *                explicit collation is requested. It is not necessary for this collation to exist (or
    *                to have been registered) when setting this option; it only needs to exist by the
    *                time it is used.</p>
    *            <p>In XSLT it is possible to override this setting using the
    *                    <code>[xsl:]default-collation</code> attribute on any stylesheet element. In
    *                XQuery, it can be overridden using the <code>declare default collation</code>
    *                declaration in the query prolog, or via a setter method in class
    *                    {@link net.sf.saxon.query.StaticQueryContext}.</p>
    *            <p>If no value is specified, the Unicode codepoint collation is used.</p>
    *
    **/

    public final static String DEFAULT_COLLATION =
        "http://saxon.sf.net/feature/defaultCollation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This determines the collection that is used when the <code>fn:collection()</code>
    *                function is called with no arguments; the effect is the same as if it were called
    *                passing the URI that is the value of this configuration property.</p>
    *
    **/

    public final static String DEFAULT_COLLECTION =
        "http://saxon.sf.net/feature/defaultCollection";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This determines the country that is used by <code>format-date()</code> and similar
    *                functions if no country code is supplied explicitly. If no value is given for this
    *                property, the default is taken from the Java Locale, which in turn typically depends
    *                on settings for the current user in the operating system.</p>
    *
    **/

    public final static String DEFAULT_COUNTRY =
        "http://saxon.sf.net/feature/defaultCountry";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option determines the language that is used by <code>format-date()</code>,
    *                    <code>xsl:number</code> and similar constructs if no language code is supplied
    *                explicitly. If no value is given for this property, the default is taken from the
    *                Java Locale, which in turn typically depends on settings for the current user in the
    *                operating system.</p>
    *
    **/

    public final static String DEFAULT_LANGUAGE =
        "http://saxon.sf.net/feature/defaultLanguage";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Determines which regular expression engine should be used for evaluating regular expressions occuring in constructs
    *            such as <code>fn:matches()</code>, <code>fn:replace</code>, and <code>xsl:analyze-string</code>, and also
    *            in the pattern facet of a schema.</p>
    *            <p>On the Java platform the permitted values are "S" (default), and "J". The value "J" selects the regex engine
    *            provided in the JDK in preference to the Saxon regular expression engine. This means that regular expressions must
    *            follow the Java syntax and semantics rather than the XPath syntax and semantics.</p>
    *            <p>On the .NET platform the permitted values are "S" (default), "J", and "N". The value "J" selects the regex engine
    *                provided in the IKVMC run-time, which is derived from OpenJDK. The value "N" selects the regex engine provided
    *            in the Microsoft .NET platform. In each case, the regular expression must follow the syntax and semantics of the selected
    *            regex engine.</p>
    *            <p>The choice of regular expression may be overridden in a particular invocation by appending the value ";s",
    *            ";j", or ";n" to the flags argument of the relevant call. (This does not apply to XSD patterns, where no flags argument is available)</p>
    *            <p>Use of this feature is not conformant with W3C specifications. Use of the setting "N", however, can be useful
    *            when schemas have been written with the Microsoft schema processor in mind, since this uses the Microsoft regular
    *            expression dialect rather than the W3C dialect.</p>
    *
    **/

    public final static String DEFAULT_REGEX_ENGINE =
        "http://saxon.sf.net/feature/defaultRegexEngine";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option disables the <code>xsl:evaluate</code> instruction.</p>
    *            <p>If set at stylesheet compile time, the feature is statically disabled. If set at
    *                run-time it is dynamically disabled. (These terms are defined in the XSLT 3.0 spec.)
    *                The feature is always disabled (statically) in Saxon-HE.</p>
    *
    **/

    public final static String DISABLE_XSL_EVALUATE =
        "http://saxon.sf.net/feature/disableXslEvaluate";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option is set to indicate that bytecode generation should be run in display
    *                mode. The effect is to output files (one per class) containing a human-readable
    *                print of the generated bytecode. The files are placed in the directory identified by
    *                the <code>DEBUG_BYTE_CODE_DIR</code> option.</p>
    *
    **/

    public final static String DISPLAY_BYTE_CODE =
        "http://saxon.sf.net/feature/displayByteCode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>If true, the XML parser is requested to perform validation of source documents
    *                against their DTD. Default is false.</p>
    *            <p>This option establishes a default for use whenever source documents (not stylesheets
    *                or schema documents) are parsed. The option can be overridden for individual
    *                documents by setting the {@link net.sf.saxon.lib.ParseOptions} for that
    *                individual document, for example from a <code>URIResolver</code>.</p>
    *
    **/

    public final static String DTD_VALIDATION =
        "http://saxon.sf.net/feature/validation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option determines whether DTD validation failures should be treated as
    *                recoverable. If the option is set, a validation failure is reported as a warning
    *                rather than an error. The default is false.</p>
    *            <p>This option establishes a default for use whenever source documents (not stylesheets
    *                or schema documents) are parsed. The option can be overridden for individual
    *                documents by setting the {@link net.sf.saxon.lib.ParseOptions} for that
    *                individual document, for example from a <code>URIResolver</code>.</p>
    *
    **/

    public final static String DTD_VALIDATION_RECOVERABLE =
        "http://saxon.sf.net/feature/dtd-validation-recoverable";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Forces Saxon to do eager evaluation of expressions in contexts where normally it would do lazy evaluation,
    *                for example when evaluating variables and function results. This can make for easier debugging.</p>
    *            <p>Note that this only applies to situations where Saxon would normally save a <code>Closure</code>
    *            object as the result of an expression. It does not prevent Saxon from using pipelined evaluation of
    *            intermediate expressions using iterators.</p>
    *
    **/

    public final static String EAGER_EVALUATION =
        "http://saxon.sf.net/feature/eagerEvaluation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied class is instantiated and the resulting <code>EntityResolver</code> is
    *                used whenever Saxon itself creates an <code>XMLReader</code> for parsing source
    *                documents. It is not used with a user-supplied <code>XMLReader</code>.</p>
    *            <p>The default value is {@link net.sf.saxon.lib.StandardEntityResolver}. This is an entity
    *                resolver that recognizes the names of many standard W3C DTDs and external entity
    *                files, and resolves them against local copies issued with the Saxon software, to
    *                avoid the need to fetch them from the web.</p>
    *            <p>The property can be set to a zero-length string, in which case no
    *                    <code>EntityResolver</code> will be used.</p>
    *
    *
    **/

    public final static String ENTITY_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/entityResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Setting the <code>ENVIRONMENT_VARIABLE_RESOLVER</code> causes the supplied object to
    *                be registered as the environment variable resolver for the
    *                    <code>Configuration</code>. The setting is global: it affects all queries and
    *                transformations using this configuration.</p>
    *            <p>The environment variable resolver is used when the XPath functions
    *                    <code>available-environment-variables()</code> or
    *                    <code>environment-variable()</code> are called. Saxon essentially delegates the
    *                evaluation of the function to the external resolver.</p>
    *
    **/

    public final static String ENVIRONMENT_VARIABLE_RESOLVER =
        "http://saxon.sf.net/feature/environmentVariableResolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Setting <code>ENVIRONMENT_VARIABLE_RESOLVER_CLASS</code> causes an instance of the
    *                supplied class to be created, and registered as the environment variable resolver
    *                for the <code>Configuration</code>. The setting is global: it affects all queries
    *                and transformations using this configuration.</p>
    *            <p>The environment variable resolver is used when the XPath functions
    *                    <code>available-environment-variables()</code> or
    *                    <code>environment-variable()</code> are called. Saxon essentially delegates the
    *                evaluation of the function to the external resolver.</p>
    *
    **/

    public final static String ENVIRONMENT_VARIABLE_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/environmentVariableResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p><code>ERROR_LISTENER_CLASS</code> is the name of the class used to implement the JAXP
    *                <code>ErrorListener</code>. This is used both at compile time and at run-time.</p>
    *            <p>Currently if this option is specified, the class is instantiated, and the same
    *                instance is used for all processes running under this configuration. This may change
    *                in future so that a new instance is created for each compilation or evaluation.</p>
    *            <p>Finer control can be obtained by setting the <code>ErrorListener</code> for a
    *                specific XSLT or XQuery compilation or evaluation.</p>
    *
    **/

    public final static String ERROR_LISTENER_CLASS =
        "http://saxon.sf.net/feature/errorListenerClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p><code>EXPAND_ATTRIBUTE_DEFAULTS</code> determines whether fixed and default values
    *                defined in a schema or DTD will be expanded (both on input and on output documents,
    *                if validation is requested).</p>
    *            <p>By default (and for conformance with the specification)
    *                validation against a DTD or schema will cause default values defined in the schema
    *                or DTD to be inserted into the document. Setting this feature to false suppresses
    *                this behavior. In the case of DTD-defined defaults this only works if the XML parser
    *                reports whether each attribute was specified in the source or generated by expanding
    *                a default value. Not all XML parsers report this information.</p>
    *
    **/

    public final static String EXPAND_ATTRIBUTE_DEFAULTS =
        "http://saxon.sf.net/feature/expandAttributeDefaults";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p><code>EXPATH_FILE_DELETE_TEMPORARY_FILES</code> determines whether temporary files
    *                and directories created in the EXPath File module should be automatically deleted on
    *                closure of the JVM.</p>
    *            <p>The default value is <b>false</b>, to align with the standard. The setting
    *                    <b>false</b> is recommended when external 'sweep-up' features aren't
    *                available.</p>
    *
    **/

    public final static String EXPATH_FILE_DELETE_TEMPORARY_FILES =
        "http://saxon.sf.net/feature/expathFileDeleteTemporaryFiles";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>By default, Saxon-EE attempts to generate Java bytecode for evaluation of parts of a
    *                query or stylesheet that are amenable to such treatment. Setting this option to
    *                false disables this.</p>
    *            <p>For backwards compatibility, this option when used at the level of <code>Configuration.setConfigurationProperty()</code>
    *            can also be used to set the value of <code>THRESHOLD_FOR_HOTSPOT_BYTECODE</code>. If the value on that interface is supplied
    *            as an integer (or a string in the form of an integer) then a value of 1 or more sets the threshold for hotspot detection, while
    *            a value of zero or less disables bytecode generation entirely. On other interfaces the value of the property must be a boolean.</p>
    *
    **/

    public final static String GENERATE_BYTE_CODE =
        "http://saxon.sf.net/feature/generateByteCode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>If this option is set to true, then when a <code>SAXSource</code> is supplied as the
    *                input to an XSLT transformation, Saxon will ignore the <code>XMLReader</code>
    *                supplied in the <code>SAXSource</code> (in fact, it will modify the supplied
    *                    <code>SAXSource</code> setting the <code>XMLReader</code> to null) and use an
    *                    <code>XMLReader</code> created using the value of the
    *                    <code>SOURCE_PARSER_CLASS</code> option in preference.</p>
    *            <p>The defining use case for this feature is when calling a Saxon transformation from
    *                Ant. Ant always supplies the source document as a <code>SAXSource</code> using a
    *                parser instantiated using the default JAXP mechanism. A different parser set using
    *                the property <code>http://saxon.sf.net/feature/sourceParserClass</code> will
    *                normally be ignored in this case; setting the <code>ignoreSAXSourceParser</code>
    *                option overrides this. This is especially useful if the input format is not in fact
    *                XML, but some other format converted to a SAX event stream by means of a custom
    *                parser.</p>
    *
    **/

    public final static String IGNORE_SAX_SOURCE_PARSER =
        "http://saxon.sf.net/feature/ignoreSAXSourceParser";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p><code>IMPLICIT_SCHEMA_IMPORTS</code> allows reference to schema components without an <code>xs:import</code> for the relevant namespace being
    *                present in the containing schema document. </p>
    *            <p>This only works if the referenced components are already present among the schema components known to the configuration, perhaps
    *            because they were part of a different schema, or because there are cyclic references within a schema.</p>
    *            <p>This option is not conformant with the XSD specification, which requires explicit <code>xs:import</code> declarations
    *            for all cross-namespace component references. However, some "industry-standard" schemas are known to violate this rule,
    *            and setting this option allows such schemas to be loaded by Saxon.</p>
    *
    **/

    public final static String IMPLICIT_SCHEMA_IMPORTS =
        "http://saxon.sf.net/feature/implicitSchemaImports";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p><code>LAZY_CONSTRUCTION_MODE</code> determines whether temporary trees are
    *                constructed lazily. The default setting is false; there are a few situations (but
    *                not many) where setting this to true can give a performance benefit (especially a
    *                memory saving).</p>
    *            <p>The option is most likely to be effective when executing XQuery in "pull" mode, that
    *                is, when the client calls the query processor to deliver the result as a stream of
    *                nodes, rather than running the query and piping the results into a serializer.</p>
    *
    **/

    public final static String LAZY_CONSTRUCTION_MODE =
        "http://saxon.sf.net/feature/lazyConstructionMode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p><code>LICENSE_FILE_LOCATION</code> holds the filename in which the Saxon license file
    *                is held.</p>
    *            <p>This is the full file name, for example <code>c:/saxon/license/license.lic</code>.
    *                Setting this property causes Saxon to
    *                immediately read the specified file and register the license data, assuming it can
    *                be found at this location. The property is not recognized for reading, and it is not
    *                recognized for writing except in Saxon-PE and Saxon-EE.</p>
    *
    **/

    public final static String LICENSE_FILE_LOCATION =
        "http://saxon.sf.net/feature/licenseFileLocation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Default is false. If true, line and column number information is retained for all
    *                source documents. This information is accessible using the
    *                    <code>saxon:line-number()</code> and <code>saxon:column-number()</code>
    *                extension functions.</p>
    *            <p>Note that the information is only as good as the XML parser supplies. SAX parsers
    *                generally report the position of an element node using the line and column number of
    *                the "&gt;" character that forms the last character of the start tag.</p>
    *            <p>When this option is set, location information attached to a node (system ID, line
    *            number, and column number) is retained when the node is copied. This has the side effect
    *            that the base URI of a node is also copied, which in some cases runs contrary to the
    *            XSLT or XQuery specification.</p>
    *
    **/

    public final static String LINE_NUMBERING =
        "http://saxon.sf.net/feature/linenumbering";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Setting the <code>MARK_DEFAULTED_ATTRIBUTES</code> option causes Saxon to retain details of attributes
    *            that were notified by the XML parser as being defaulted (that is, the attribute was not present in the instance
    *            document but was defined by a default value in a DTD or schema). This information is available to applications
    *            via the <code>saxon:is-defaulted()</code> extension function.</p>
    *            <p>Note: information about defaulted attributes is retained automatically where the attribute is processed
    *            using Saxon's schema processor; but in the case where the information comes from an external XML parser, it
    *            is retained only if this option is set.</p>
    *
    **/

    public final static String MARK_DEFAULTED_ATTRIBUTES =
        "http://saxon.sf.net/feature/markDefaultedAttributes";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Places a limit on the number of classes for which Saxon will generate bytecode.</p>
    *            <p>If bytecode generation is enabled, Saxon will generate bytecode for frequently used constructs appearing
    *                in stylesheets or queries. This can become problematic if a configuration uses a very large number
    *                of different stylesheets and queries, because it creates memory pressure (in some environments classes
    *                are never garbage collected). When this limit (which defaults to 10,000) is exceeded, no more bytecode
    *            is generated, and queries/stylesheets are interpreted instead.</p>
    *
    **/

    public final static String MAX_COMPILED_CLASSES =
        "http://saxon.sf.net/feature/maxCompiledClasses";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>From Saxon 11.1, this option has no effect.</p>
    *
    *
    **/

    public final static String MESSAGE_EMITTER_CLASS =
        "http://saxon.sf.net/feature/messageEmitterClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Affects XQuery only. An instance of a user-written class implementing Saxon's
    *                    {@link net.sf.saxon.lib.ModuleURIResolver} interface. This is used to
    *                process any URIs used in <code>import module</code> directives in XQuery.</p>
    *
    **/

    public final static String MODULE_URI_RESOLVER =
        "http://saxon.sf.net/feature/moduleURIResolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Affects XQuery only. The name of a user-written class implementing Saxon's
    *                    {@link net.sf.saxon.lib.ModuleURIResolver} interface. This is used to
    *                process any URIs used in <code>import module</code> directives in XQuery.</p>
    *
    **/

    public final static String MODULE_URI_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/moduleURIResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>When set from the Transform or Query command line, a report on bytecode generation is
    *                produced at the end of the transformation or query.</p>
    *            <p>When set from an application, the bytecode report is produced only on request, by
    *                calling <code>Configuration.createByteCodeReport(fileName)</code>.</p>
    *            <p>The bytecode report is an XML file containing one entry for each expression that has
    *                been compiled into bytecode. Each entry contains the following details, where
    *                applicable:</p>
    *                <ul>
    *                <li><code>text</code> Abbreviated text of the expression</li>
    *                <li><code>intCount</code> Number of times the expression was evaluated in the interpreter</li>
    *                <li><code>intTime</code> Cumulative time spent evaluating the expression (including subexpressions) in the interpreter</li>
    *                <li><code>bcCount</code> Number of times the expression was evaluated as byte-code</li>
    *                <li><code>bcTime</code> Cumulative time spent evaluating the expression (including subexpressions) as byte-code</li>
    *                <li><code>compileTime</code> Time spent generating bytecode for the expression</li>
    *                <li><code>ratio</code> Average byte-code execution time as a proportion of average interpreted execution time</li>
    *                <li><code>ebv</code> Number of evaluations of the expressions <code>effectiveBooleanValue()</code> method</li>
    *                <li><code>eval</code> Number of evaluations of the expressions <code>evaluateItem()</code> method</li>
    *                <li><code>iterate</code> Number of evaluations of the expressions <code>iterate()</code> method</li>
    *                <li><code>process</code> Number of evaluations of the expressions <code>process()</code> method</li>
    *                <li><code>module</code> URI of the module containing the expression</li>
    *                <li><code>line</code> Line number of the expression within this module</li>
    *            </ul>
    *
    **/

    public final static String MONITOR_HOT_SPOT_BYTE_CODE =
        "http://saxon.sf.net/feature/monitorHotSpotByteCode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Affects schema construction (whether for standalone validation, or in the context of
    *                XSLT or XQuery).</p>
    *            <p>If set to true, the schema processor attempts to fetch a schema
    *                document appearing in an <code>xs:import</code> directive, whether or not a schema
    *                for that namespace has already been loaded, unless the absolute URI formed from the
    *                    <code>schemaLocation</code> is the same as the absolute URI that was used to
    *                load that namespace. If set to false, the schema processor ignores the
    *                    <code>schemaLocation</code> on an <code>xs:import</code> declaration if schema
    *                components for the requested namespace are already available. Note that setting the
    *                value to true might cause spurious errors due to like-named schema components being
    *                loaded more than once. On the other hand, setting the value to false might result in
    *                validation failing because schema components are missing.</p>
    *            <p>Note: Both settings are conformant with the W3C recommendation, which leaves the
    *                details implementation-defined. It is possible (and advisable) to write schemas in
    *                such a way that this setting makes no difference, by ensuring that all imports for a
    *                particular namespace go via a "home" schema document for that namespace, where the
    *                home schema document contains <code>xs:include</code> declarations for all the
    *                schema documents defining components in that namespace.</p>
    *
    **/

    public final static String MULTIPLE_SCHEMA_IMPORTS =
        "http://saxon.sf.net/feature/multipleSchemaImports";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Indicates that the supplied <code>NamePool</code> should be used as the target
    *                (run-time) <code>NamePool</code> by all stylesheets compiled (using
    *                <code>newTemplates()</code>) after this call on <code>setAttribute</code>.</p>
    *            <p>Normally a single system-allocated <code>NamePool</code> is used for all stylesheets
    *                compiled while the Java VM remains loaded; this attribute allows user control over
    *                the allocation of name pools. Note that source trees used as input to a
    *                transformation must be built using the same <code>NamePool</code> that is used when
    *                the stylesheet is compiled: this will happen automatically if the input to a
    *                transformation is supplied as a <code>SAXSource</code> or <code>StreamSource</code>
    *                but it is under user control if you build the source tree yourself.</p>
    *            <p>This option can be used to make two <code>Configuration</code> objects share a
    *                    <code>NamePool</code> even though they differ in other respects.</p>
    *
    **/

    public final static String NAME_POOL =
        "http://saxon.sf.net/feature/namePool";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p><code>OCCURRENCE_LIMITS</code> determines the largest values of
    *                <code>minOccurs</code> and <code>maxOccurs</code> that can be accommodated when
    *                compiling an "expanded" finite state machine to represent an XSD content model
    *                grammar.</p>
    *            <p>These limits do not apply in the common cases where the grammar can be
    *                implemented using a counting finite-state-machine, but in those cases where this is
    *                not possible, any <code>minOccurs</code> value greater than the first integer is
    *                reduced to the value of the first integer, and any <code>maxOccurs</code> value
    *                greater than the second integer is treated as "unbounded".</p>
    *            <p>Setting these values too high may cause an <code>OutOfMemoryException</code> since
    *                the size of the finite state machine constructed by Saxon increases linearly with
    *                the values of <code>minOccurs</code> and <code>maxOccurs</code>.</p>
    *
    **/

    public final static String OCCURRENCE_LIMITS =
        "http://saxon.sf.net/feature/occurrenceLimits";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Allows individual optimizations to be enabled or disabled selectively.</p>
    *            <p>There is a set of single-letter flags identifying particular optimizations:</p>
    *            <ul>
    *                <li>c: generate bytecode</li>
    *                <li>e: cache regular expressions</li>
    *                <li>f: inline functions</li>
    *                <li>g: extract global variables</li>
    *                <li>j: just-in-time compilation of template rules</li>
    *                <li>k: create keys</li>
    *                <li>l: loop lifting</li>
    *                <li>m: miscellaneous</li>
    *                <li>n: constant folding</li>
    *                <li>r: template rule-sets</li>
    *                <li>s: extract common subexpressions</li>
    *                <li>v: inline variables</li>
    *                <li>w: create switch statements</li>
    *                <li>x: index predicates</li>
    *            </ul>
    *            <p>A value such as <code>gs</code> runs with only the selected optimizations;
    *                <code>-gs</code> runs with the selected optimizations disabled and all others enabled. The
    *                value <code>0</code> suppresses all optimizations. The default is full optimization; this
    *                feature allows optimization to be suppressed in cases where reducing compile time is
    *                important, or where optimization gets in the way of debugging, or causes extension
    *                functions with side-effects to behave unpredictably. (Note however, that even with
    *                no optimization, lazy evaluation may still cause the evaluation order to be not as
    *                expected.) </p>
    *            <p><i>Note that disabling optimizations may prevent streamed execution. This is because
    *            there are cases where streamed execution is only possible because the optimizer is able to detect
    *            that sorting nodes into document order is unnecessary.</i></p>
    *
    **/

    public final static String OPTIMIZATION_LEVEL =
        "http://saxon.sf.net/feature/optimizationLevel";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied <code>OutputURIResolver</code> will be used to resolve URIs of secondary
    *                result documents selected in the <code>href</code> attribute of the XSLT
    *                    <code>xsl:result-document</code> instruction.</p>
    *
    **/

    public final static String OUTPUT_URI_RESOLVER =
        "http://saxon.sf.net/feature/outputURIResolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied class will be instantiated, and the resulting
    *                    <code>OutputURIResolver</code> will be used to resolve URIs of secondary result
    *                documents selected in the <code>href</code> attribute of the XSLT
    *                    <code>xsl:result-document</code> instruction.</p>
    *
    **/

    public final static String OUTPUT_URI_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/outputURIResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>If true, calls on the <code>doc()</code> and <code>document()</code> functions, if
    *                their arguments are known at compile time, will be evaluated at compile time, and
    *                the resulting document will be stored as part of the Saxon
    *                {@link net.sf.saxon.Configuration} and shared by all queries and
    *                transformations running within that <code>Configuration</code>.</p>
    *            <p>This is useful for reference documents that have stable content and are used by many different
    *                queries and transformations. The default is false, which means each query or transformation
    *                will reload the document from disk.</p>
    *            <p>In XSLT 3.0 a better way of having external documents pre-loaded at stylesheet
    *                compile time is to use the new facility of static global variables.</p>
    *            <p>This feature should not be enabled when stylesheets are exported to a SEF file,
    *               since embedded source documents within a SEF file cannot always be accurately
    *               reconstructed.</p>
    *            <p>When URIs are pre-evaluated, neither the <code>ResourceResolver</code> associated
    *                with the relevant <code>Compiler</code>, nor the relevant run-time <code>ResourceResolver</code>
    *                are used to resolve the URI. Only the Configuration-level <code>ResourceResolver</code> is used.</p>
    *
    **/

    public final static String PRE_EVALUATE_DOC_FUNCTION =
        "http://saxon.sf.net/feature/preEvaluateDocFunction";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>True if the <code>doc()</code> or <code>document()</code> are to recognize query parameters included in the
    *                URI (for example, <code>?validation=strict</code>). The
    *                default is false.</p>
    *
    *            <p>The allowed parameters are: <code>validation=strict|lax|strip</code> to perform schema
    *                validation (see {@code Validation of
    *                    source documents}); <code>strip-space=yes|ignorable|no</code> to control whitespace
    *                stripping (see {@code Whitespace
    *                    stripping in source documents}); <code>parser=full.class.name</code> to
    *                determine the name of the parser (XMLReader) to be used (see {@code Controlling parsing of source
    *                    documents}); and <code>xinclude=yes|no</code> to control whether XInclude
    *                processing takes place, assuming the XML parser supports it (see {@code XInclude processing}).</p>
    *
    **/

    public final static String RECOGNIZE_URI_QUERY_PARAMETERS =
        "http://saxon.sf.net/feature/recognize-uri-query-parameters";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>At one time this property controlled how recoverable errors were handled
    *            (fatal error, warning, or ignored). XSLT 3.0 has eliminated all recoverable errors from the
    *                specification, so the property is no longer used.</p>
    *
    **/

    public final static String RECOVERY_POLICY =
        "http://saxon.sf.net/feature/recoveryPolicy";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>At one time this property controlled how recoverable errors were handled
    *                (fatal error, warning, or ignored). XSLT 3.0 has eliminated all recoverable errors from the
    *                specification, so the property is no longer used.</p>
    *
    **/

    public final static String RECOVERY_POLICY_NAME =
        "http://saxon.sf.net/feature/recoveryPolicyName";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Indicates the maximum number of threads to be used for processing
    *                    <code>xsl:result-document</code> instructions in parallel. If the maximum number
    *                of threads are already in use, the <code>xsl:result-document</code> instruction will
    *                be executed synchronously within its parent thread.</p>
    *            <p>The default value is initialized to
    *                    <code>Runtime.getRuntime().availableProcessors()</code> which is intended to
    *                represent the number of "processors" (under some definition) available from the
    *                hardware.</p>
    *            <p>The limit applies per <code>Configuration</code>. If multiple workloads are running
    *                on the same server under separate Saxon <code>Configuration</code> objects, then it
    *                may be desirable to lower the limit.</p>
    *            <p>Setting a value of zero or one suppresses multithreading entirely. This can also be
    *                achieved (for a specific <code>xsl:result-document</code> instruction) by setting
    *                the attribute <code>saxon:asynchronous="no"</code> in the stylesheet. Suppressing
    *                multithreading may be desirable in a stylesheet that calls extension functions with
    *                side-effects.</p>
    *
    **/

    public final static String RESULT_DOCUMENT_THREADS =
        "http://saxon.sf.net/feature/resultDocumentThreads";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>If set to true, indicates that when input is obtained from a SAX parser, the
    *                DTD-based attribute type notified by the XML parser should be used to set the type
    *                annotation of the resulting node: for example a DTD type of NMTOKENS results in a
    *                type annotation of xs:NMTOKENS. </p>
    *            <p>This option is retained for backwards compatibility (at some time in the past, it was
    *                the default), but is deprecated.</p>
    *
    **/

    public final static String RETAIN_DTD_ATTRIBUTE_TYPES =
        "http://saxon.sf.net/feature/retain-dtd-attribute-types";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied <code>SchemaURIResolver</code> will be used to resolve URIs of schema
    *                documents referenced in <code>xsl:import-schema</code> declarations in XSLT,
    *                    <code>import schema</code> in XQuery, references from one schema document to
    *                another using <code>xs:include</code> or <code>xs:import</code>, and references from
    *                an instance document to a schema using <code>xsi:schemaLocation</code>.</p>
    *
    **/

    public final static String SCHEMA_URI_RESOLVER =
        "http://saxon.sf.net/feature/schemaURIResolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The name of a class that implements the interface <code>SchemaURIResolver</code>;
    *                this class will be instantiated and the resulting instance will be used as the value
    *                of the {@link net.sf.saxon.lib.FeatureKeys#SCHEMA_URI_RESOLVER} property.</p>
    *
    **/

    public final static String SCHEMA_URI_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/schemaURIResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Indicates whether and how schema validation should be applied to source
    *                documents.</p>
    *
    **/

    public final static String SCHEMA_VALIDATION =
        "http://saxon.sf.net/feature/schema-validation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Indicates whether and how schema validation should be applied to source
    *                documents.</p>
    *
    **/

    public final static String SCHEMA_VALIDATION_MODE =
        "http://saxon.sf.net/feature/schema-validation-mode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The class will be instantiated and the resulting <code>SerializerFactory</code> will
    *                be used to create the serialization pipeline for XSLT and XQuery results.</p>
    *            <p>By subclassing the standard <code>SerializerFactory</code> it is possible to customize
    *                many aspects of the output produced by the Serializer, or to introduce new
    *                serialization methods and parameters.</p>
    *
    **/

    public final static String SERIALIZER_FACTORY_CLASS =
        "http://saxon.sf.net/feature/serializerFactoryClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>XML parser used for source documents.</p>
    *            <p>The class will be instantiated. If it is an <code>XMLReader</code> it is used
    *                directly; if it is a <code>SAXParserFactory</code> it is used to instantiate an
    *                    <code>XMLReader</code>. The resulting <code>XMLReader</code> will be used to
    *                parse source documents (that is, the principal source document plus any secondary
    *                source documents read using the <code>doc()</code>, <code>document()</code>, or
    *                    <code>collection()</code> function).</p>
    *            <p>Note that the selected parser is used only when the input is supplied in the form of
    *                a <code>StreamSource</code>; it is ignored when a <code>SAXSource</code> with a
    *                pre-initialized <code>XMLReader</code> is supplied. A consequence is that this
    *                configuration option has no effect when running transformations from an Ant script,
    *                since the Ant <code>xslt</code> task always supplies the input in the form of a
    *                    <code>SAXSource</code>.</p>
    *
    **/

    public final static String SOURCE_PARSER_CLASS =
        "http://saxon.sf.net/feature/sourceParserClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>On interfaces that allow an <code>org.xml.sax.Source</code> to be supplied, if a kind
    *                of <code>Source</code> is provided that Saxon does not recognize, it will be passed
    *                to the user-supplied <code>SourceResolver</code>, which has the opportunity to
    *                convert it to a kind of <code>Source</code> that Saxon does recognize. This allows
    *                new kinds of input to be supplied as input to Saxon's query, transformation, and
    *                validation engines.</p>
    *
    **/

    public final static String SOURCE_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/sourceResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p><code>STABLE_COLLECTION_URI</code>, if set, indicates that collections returned by
    *                the <code>fn:collection()</code> and <code>fn:uri-collection()</code> functions
    *                should be <i>stable</i>, that is, repeated calls on these functions with the same
    *                collection URI (within the scope of a single query or transformation) should return
    *                identical results.</p>
    *            <p>Setting this option may be expensive because it requires that the entire collection
    *                be saved in memory; it is rarely necessary in practice, but is required for strict
    *                conformance with the W3C specifications.</p>
    *            <p>It is also possible to indicate that a collection is stable by means of the
    *                    <code>CollectionFinder</code> API.</p>
    *
    **/

    public final static String STABLE_COLLECTION_URI =
        "http://saxon.sf.net/feature/stableCollectionUri";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p><code>STABLE_UNPARSED_TEXT</code>, if set, indicates that the results returned by
    *                repeated calls of <code>unparsed-text()</code>, <code>unparsed-text-lines()</code>,
    *                and <code>unparsed-text-available()</code> are consistent: calling these functions
    *                twice during the evaluation of a stylesheet or query will return the same
    *                results.</p>
    *            <p>Setting this option may be expensive because it requires that the file contents be
    *                saved in memory; it is rarely necessary in practice, but is required for strict
    *                conformance with the W3C specifications.</p>
    *
    **/

    public final static String STABLE_UNPARSED_TEXT =
        "http://saxon.sf.net/feature/stableUnparsedText";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p><code>STANDARD_ERROR_OUTPUT_FILE</code> is the name of a file to which Saxon will
    *                redirect output that would otherwise go to the operating system standard error
    *                stream (System.err). This is the fallback destination for various tracing and
    *                diagnostic output. In some cases a more specific mechanism exists to select the
    *                destination for particular kinds of output.</p>
    *            <p>Note that if the <code>Configuration</code> is used in more than one processing
    *                thread, the messages from different threads will be interleaved in the output file.
    *                A more selective approach is to use a different <code>ErrorListener</code> in
    *                different processing threads, and arrange for each <code>ErrorListener</code> to
    *                write to its own logging destination.</p>
    *
    **/

    public final static String STANDARD_ERROR_OUTPUT_FILE =
        "http://saxon.sf.net/feature/standardErrorOutputFile";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The <code>STREAMABILITY</code> option can be used to disable streaming.</p>
    *            <p>In earlier Saxon releases a third value "extended" was supported, to enable Saxon
    *                streaming extensions. Since nearly all these extensions found their way into the W3C
    *                specification, the distinction between "standard" and "extended" became meaningless,
    *                so the value "extended" has been dropped.</p>
    *            <p>The value "off" causes Saxon to behave as a non-streaming processor; that is, it does
    *                not analyze constructs that are declared streamable, and it processes them as if
    *                streaming were not requested. This is the only option available when using a Saxon
    *                version or license that does not enable streaming.</p>
    *            <p>The value "standard" is a misnomer. For strict adherence to W3C streamability rules,
    *                set the property <code>STRICT_STREAMABILITY</code>. The streamability rules applied
    *                by default are (in nearly all cases) identical to the W3C rules, but by default they
    *                are applied to the expression tree after type-checking and optimization, which makes
    *                some constructs streamable that would not be so otherwise.</p>
    *            <p>Whichever option is chosen, the <code>STREAMING_FALLBACK</code> option can be used to
    *                control what happens when code is deemed non-streamable; it provides a choice
    *                between throwing a static (compile-time) error, and falling back to a non-streaming
    *                implementation.</p>
    *
    **/

    public final static String STREAMABILITY =
        "http://saxon.sf.net/feature/streamability";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Causes the XSLT processor to verify that constructs that are declared streamable are
    *                in fact "guaranteed streamable" according to the W3C rules.</p>
    *            <p>Normally, Saxon performs a variety of simplifications and optimizations on the
    *                expression tree before performing streamability analysis. Sometimes these tree
    *                rewrites will turn a non-streamable expression into a streamable one. An obvious
    *                example is variable inlining: the expression <code>let $x := ./item/price return
    *                    sum($x)</code> is not streamable, but the rewritten form
    *                    <code>sum(./item/price)</code> is.</p>
    *            <p>The XSLT 3.0 specification requires conformant streaming processors to have a mode of
    *                operation in which the streamability rules are enforced as they appear in the spec,
    *                and this option enables this mode.</p>
    *            <p>This analysis is expensive, and should only be used during development when testing
    *                stylesheet code for portability. When this mode is enabled, Saxon applies the
    *                streamability rules at the earliest possible stage of processing; it then performs
    *                its normal type checking and optimization phases, before doing a second stage of
    *                streamability analysis to construct a streamed execution plan.</p>
    *
    **/

    public final static String STRICT_STREAMABILITY =
        "http://saxon.sf.net/feature/strictStreamability";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>If the <code>STREAMING_FALLBACK</code> option is set, then constructs for which
    *                streaming is requested (such as templates in a streaming mode, the
    *                    <code>xsl:source-document</code> instruction with attribute
    *                    <code>streamable="yes"</code>, and streamable accumulators) will be executed in
    *                non-streaming mode if the code is not actually streamable. A compile-time warning
    *                will always be given when the fallback option is taken.</p>
    *
    **/

    public final static String STREAMING_FALLBACK =
        "http://saxon.sf.net/feature/streamingFallback";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Indicates whether all whitespace, no whitespace, or whitespace in elements defined in
    *                a DTD or schema as having element-only content should be stripped from source
    *                documents.</p>
    *            <p>The default is "ignorable". This whitespace stripping is additional to
    *                any stripping done as a result of the <code>xsl:strip-space</code> declaration in an
    *                XSLT stylesheet.</p>
    *
    **/

    public final static String STRIP_WHITESPACE =
        "http://saxon.sf.net/feature/strip-whitespace";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>XML parser used for stylesheets and schema documents.</p>
    *            <p>The class will be instantiated. If it is an <code>XMLReader</code> it is used
    *                directly; if it is a <code>SAXParserFactory</code> it is used to instantiate an
    *                    <code>XMLReader</code>. The resulting <code>XMLReader</code> will be used to
    *                parse stylesheet documents (that is, the principal stylesheet module plus any
    *                secondary source documents read using <code>xsl:include</code> or
    *                    <code>xsl:import</code>) and also schema documents.</p>
    *
    **/

    public final static String STYLE_PARSER_CLASS =
        "http://saxon.sf.net/feature/styleParserClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This is set to true to suppress the warning otherwise issued by command-line
    *                interfaces indicating that an evaluation license is in use and is due to expire in a
    *                set number of days.</p>
    *
    **/

    public final static String SUPPRESS_EVALUATION_EXPIRY_WARNING =
        "http://saxon.sf.net/feature/suppressEvaluationExpiryWarning";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Suppresses all warnings issued by the XPath and XQuery parsers.</p>
    *            <p>Examples of warnings that are suppressed are the warning produced when keywords such
    *                as <code>true</code> and <code>return</code> are interpreted as element names.</p>
    *
    **/

    public final static String SUPPRESS_XPATH_WARNINGS =
        "http://saxon.sf.net/feature/suppressXPathWarnings";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This is set to true to suppress the warning when there is no commonality between the
    *                namespaces used in stylesheet match patterns and the namespaces used in the source
    *                document.</p>
    *
    **/

    public final static String SUPPRESS_XSLT_NAMESPACE_CHECK =
        "http://saxon.sf.net/feature/suppressXsltNamespaceCheck";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Indicates how often an XSD simple type definition must be used before Saxon generates
    *                bytecode to implement validation of input data against that type.</p>
    *            <p>By default, Saxon-EE generates Java bytecode to speed up the validation of input
    *                strings against user-defined simple types after the type has been used 100 times
    *                (during the life of a Saxon Configuration). This threshold may be changed using this
    *                configuration option. It may be useful to raise the threshold if the number of
    *                user-defined types is large, and the bytecode is creating memory pressure.</p>
    *
    **/

    public final static String THRESHOLD_FOR_COMPILING_TYPES =
        "http://saxon.sf.net/feature/thresholdForCompilingTypes";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This is set to true to cause basic timing and tracing information to be output to the
    *                standard error output stream.</p>
    *            <p>The name of the feature is poorly chosen, since much
    *                of the information that is output has nothing to do with timing, for example the
    *                names of output files for <code>xsl:result-document</code> are traced, as are the
    *                names of schema documents loaded.</p>
    *
    **/

    public final static String TIMING =
        "http://saxon.sf.net/feature/timing";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>If this option is set, Saxon will output (to the standard error output) progress
    *                information about its attempts to locate and disambiguate references to reflexive
    *                Java extension functions. This is useful for diagnostics if the XQuery or XSLT
    *                compiler is failing to locate user-written extension functions.</p>
    *
    **/

    public final static String TRACE_EXTERNAL_FUNCTIONS =
        "http://saxon.sf.net/feature/trace-external-functions";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The <code>TraceListener</code> will be notified of significant events occurring
    *                during a query or transformation, for tracing or debugging purposes.</p>
    *            <p>Setting a <code>TraceListener</code> automatically sets the
    *                    {@link net.sf.saxon.lib.FeatureKeys#COMPILE_WITH_TRACING} option.</p>
    *            <p>Avoid this option if more than one transformation or query is running concurrently:
    *                use the feature {@link net.sf.saxon.lib.FeatureKeys#TRACE_LISTENER_CLASS}
    *                instead. Alternatively, it is possible to set a <code>TraceListener</code> for an
    *                individual query or transformation.</p>
    *
    **/

    public final static String TRACE_LISTENER =
        "http://saxon.sf.net/feature/traceListener";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The class will be instantiated once for each query or transformation, and the
    *                resulting <code>TraceListener</code> will be notified of significant events
    *                occurring during that query or transformation, for tracing or debugging
    *                purposes.</p>
    *            <p>Setting a <code>TraceListener</code> automatically sets the
    *                    {@link net.sf.saxon.lib.FeatureKeys#COMPILE_WITH_TRACING} option.</p>
    *
    **/

    public final static String TRACE_LISTENER_CLASS =
        "http://saxon.sf.net/feature/traceListenerClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>When trace listening is switched on (for example by using -T on the command line),
    *                this file will be supplied to the trace listener to use as the output destination.
    *                If the option is not supplied, trace listener output is sent to the standard error
    *                stream.</p>
    *
    **/

    public final static String TRACE_LISTENER_OUTPUT_FILE =
        "http://saxon.sf.net/feature/traceListenerOutputFile";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>If this option is set, Saxon will output (to the standard error output) detailed
    *                information about the rewrites to the expression tree made by the optimizer. This
    *                information is mainly useful for internal system debugging, but it is also possible
    *                to digest it to analyze the ways in which the expression has been optimized for the
    *                purpose of performance analysis and tuning.</p>
    *
    **/

    public final static String TRACE_OPTIMIZER_DECISIONS =
        "http://saxon.sf.net/feature/trace-optimizer-decisions";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Selects an implementation of the Saxon tree model. The default is
    *                    <code>TINY_TREE</code>.</p>
    *            <p>For running XQuery Update, use the linked tree, because it is the only implementation
    *                that is updateable.</p>
    *
    **/

    public final static String TREE_MODEL =
        "http://saxon.sf.net/feature/treeModel";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Selects an implementation of the Saxon tree model. The default is
    *                    <code>tinyTree</code>.</p>
    *            <p>For running XQuery Update, use the linked tree, because it is the only implementation
    *                that is updateable.</p>
    *
    **/

    public final static String TREE_MODEL_NAME =
        "http://saxon.sf.net/feature/treeModelName";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied <code>UnparsedTextURIResolver</code> will be used to resolve
    *                (dereference) all URIs specifed in calls to the <code>unparsed-text()</code>,
    *                    <code>unparsed-text-lines()</code>, and <code>unparsed-text-available()</code>
    *                functions.</p>
    *
    **/

    public final static String UNPARSED_TEXT_URI_RESOLVER =
        "http://saxon.sf.net/feature/unparsedTextURIResolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>An instance of the specified <code>UnparsedTextURIResolver</code> class will be
    *                created, and used to resolve (dereference) all URIs specifed in calls to the
    *                    <code>unparsed-text()</code>, <code>unparsed-text-lines()</code>, and
    *                    <code>unparsed-text-available()</code> functions.</p>
    *
    **/

    public final static String UNPARSED_TEXT_URI_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/unparsedTextURIResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>An instance of the specified <code>URIResolver</code> class will be created, and used
    *                to resolve (dereference) all URIs specifed in calls to the <code>doc()</code> and
    *                    <code>document()</code> functions, as well as URIs used in
    *                    <code>xsl:include</code> and <code>xsl:import</code> and location hints for
    *                XQuery modules and XSD schema documents.</p>
    *
    **/

    public final static String URI_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/uriResolverClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option determines whether a <code>TransformerHandler</code> created with this
    *                    <code>TransformerFactory</code> or <code>Configuration</code> recognizes the
    *                JAXP-defined processing instructions <code>Result.PI_DISABLE_OUTPUT_ESCAPING</code>
    *                and <code>Result.PI_ENABLE_OUTPUT_ESCAPING</code> in the input stream as
    *                instructions to disable or to re-enable output escaping. The default value is
    *                    <b>false</b>.</p>
    *
    **/

    public final static String USE_PI_DISABLE_OUTPUT_ESCAPING =
        "http://saxon.sf.net/feature/use-pi-disable-output-escaping";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option is relevant only when the TinyTree is used; it determines whether (for a
    *                validated document) a cache will be maintained containing the typed values of nodes.</p>
    *            <p>Typed values are held in the cache only for elements and attributes whose type is
    *                other than string, untypedAtomic, or anyURI. The default value is true. Setting this
    *                value to false can reduce memory requirements at the cost of requiring recomputation
    *                of typed values on each access.</p>
    *
    **/

    public final static String USE_TYPED_VALUE_CACHE =
        "http://saxon.sf.net/feature/use-typed-value-cache";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option determines whether or not to use the <code>xsi:schemaLocation</code>
    *                    and<code> xsi:noNamespaceSchemaLocation</code> attributes in an instance
    *                document to locate a schema for validation.</p>
    *            <p>Note, these attribute are only consulted if validation is requested; the presence of
    *                one of these attributes never by itself triggers validation.</p>
    *
    **/

    public final static String USE_XSI_SCHEMA_LOCATION =
        "http://saxon.sf.net/feature/useXsiSchemaLocation";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option determines whether non-fatal validation errors in XQuery or XSLT result
    *                documents should result in comments being inserted into the result tree. The
    *                command-line flag <code>-outval:recover</code> sets both this option and the
    *                    {@link net.sf.saxon.lib.FeatureKeys#VALIDATION_WARNINGS} option.</p>
    *
    **/

    public final static String VALIDATION_COMMENTS =
        "http://saxon.sf.net/feature/validation-comments";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option indicates (if true) that errors occuring while validating a final result
    *                tree are not to be treated as fatal.</p>
    *            <p>Regardless of the setting of this option, all validation errors are reported to the
    *                    <code>error()</code> method of the <code>ErrorListener</code>, and validation is
    *                terminated if the <code>error()</code> method throws an exception, or if the error
    *                limit set in the <code>ParseOptions</code> object is reached.</p>
    *            <p>This option primarily controls what happens at the end of a validation episode. If
    *                the validation episode detected one or more validation errors, then when this option
    *                is off, an exception is thrown, which will normally result in any query or
    *                stylesheet failing with a dynamic error, and no output file being written. If the
    *                option is on, no exception is thrown, and the output is written as if validation had
    *                been successful. Note in this case that any type annotations present in a result
    *                document are unreliable.</p>
    *            <p>If this option is set when running XSLT or XQuery, it is ignored as far as input
    *                files are concerned: validation errors in input files are still fatal. However, if
    *                the option is set and a validation error occurs in a final output file, the output
    *                file is still written and the process terminates as if successful.</p>
    *            <p>The detailed interpretation of this option changed in Saxon 9.5.</p>
    *
    **/

    public final static String VALIDATION_WARNINGS =
        "http://saxon.sf.net/feature/validation-warnings";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Indicates whether a warning message should be notified (to the
    *                <code>ErrorListener</code>) if running Saxon against an XSLT stylesheet that
    *                specifies <code>version="1.0"</code>.</p>
    *            <p>From Saxon 9.8, the warning is no longer output (since XSLT 3.0 does not require
    *                it), so this option is ignored.</p>
    *
    *
    **/

    public final static String VERSION_WARNING =
        "http://saxon.sf.net/feature/version-warning";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Indicates whether source documents should have any XInclude directives expanded.</p>
    *            <p>The default is false. The option applies to all input XML documents, including
    *                stylesheets and schema documents. It can be overridden for individual documents
    *                using the {@link net.sf.saxon.lib.ParseOptions} class.</p>
    *            <p>This option relies on support in the underlying XML parser. If the XML parser does
    *                not support XInclude processing, setting this option results in a parsing failure.</p>
    *
    **/

    public final static String XINCLUDE =
        "http://saxon.sf.net/feature/xinclude-aware";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This determines the XML version used by the <code>Configuration</code>.</p>
    *            <p>Note that source documents specifying <code>xml version="1.0"</code> or
    *                    <code>"1.1"</code> are accepted regardless of this setting. The effect of this
    *                switch is to change the validation rules for types such as <code>xs:Name</code> and
    *                    <code>xs:NCName</code>, to change the characters allowed in names within XPath
    *                expressions (etc.), to change the meaning of <code>\i</code> and <code>\c</code> in
    *                regular expressions, and to determine whether the serializer allows XML 1.1
    *                documents to be constructed. </p>
    *            <p>The default is 1.0.</p>
    *            <p>SaxonCS uses the <code>System.Xml</code> parser, which does not support XML 1.1.</p>
    *
    **/

    public final static String XML_VERSION =
        "http://saxon.sf.net/feature/xml-version";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Sets the value of a parser feature flag. The feature name is any fully-qualified
    *                URI.</p>
    *            <p>For example if the parser supports a feature
    *                    <code>http://xml.org/sax/features/external-parameter-entities</code> then this
    *                can be set by setting the value of the Configuration property:
    *                    <code>http://saxon.sf.net/feature/parserFeature?uri=http%3A//xml.org/sax/features/external-parameter-entities</code>
    *                to true.</p>
    *
    **/

    public final static String XML_PARSER_FEATURE =
        "http://saxon.sf.net/feature/parserFeature?uri=";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Sets the value of a parser property flag. The property name is any fully-qualified
    *                URI.</p>
    *            <p>For example if the parser supports a property
    *                    <code>http://apache.org/xml/properties/schema/external-schemaLocation</code>
    *                then this can be set using the value of the Configuration property:
    *                    <code>http://saxon.sf.net/feature/parserProperty?uri=http%3A//apache.org/xml/properties/schema/external-schemaLocation</code>
    *                to the required value.</p>
    *
    **/

    public final static String XML_PARSER_PROPERTY =
        "http://saxon.sf.net/feature/parserProperty?uri=";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Determines whether XQuery Update syntax is accepted.</p>
    *            <p>If true, update syntax is accepted, if false, it is not accepted. Setting the value to
    *                true does not mean that the query has to use update syntax, only that it may do so.</p>
    *            <p>From Saxon 9.6, XQuery Update syntax and XQuery 3.0 syntax can be mixed, although
    *                this combination is not defined by any W3C specification at the time of writing.</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *            <p>On the command line, this option is combined with the option "discard" which
    *                indicates that updates are allowed, but the updates are not written back to
    *                filestore. This does not correspond to any option in the Java API, where writing an
    *                updated document back to filestore only happens if explicitly requested.</p>
    *
    **/

    public final static String XQUERY_ALLOW_UPDATE =
        "http://saxon.sf.net/feature/xqueryAllowUpdate";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This option defines the default value of the construction mode in the XQuery static
    *                context (overridable in the query prolog).</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *
    **/

    public final static String XQUERY_CONSTRUCTION_MODE =
        "http://saxon.sf.net/feature/xqueryConstructionMode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property defines the default namespace for elements and types that are not
    *                qualified by a namespace prefix.</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *
    **/

    public final static String XQUERY_DEFAULT_ELEMENT_NAMESPACE =
        "http://saxon.sf.net/feature/xqueryDefaultElementNamespace";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property defines the default namespace for function names that are not qualified
    *                by a namespace prefix.</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *
    **/

    public final static String XQUERY_DEFAULT_FUNCTION_NAMESPACE =
        "http://saxon.sf.net/feature/xqueryDefaultFunctionNamespace";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property defines how the empty sequence is handled in XQuery sorting (the "order
    *                by" clause). If true, <code>()</code> comes at the start of the sorted sequence; if
    *                false, it comes last.</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *
    **/

    public final static String XQUERY_EMPTY_LEAST =
        "http://saxon.sf.net/feature/xqueryEmptyLeast";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property defines the default value of the <code>inherit-namespaces</code>
    *                property in the XQuery static context.</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *
    **/

    public final static String XQUERY_INHERIT_NAMESPACES =
        "http://saxon.sf.net/feature/xqueryInheritNamespaces";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>If the value is false, then when an <code>import module</code> declaration is
    *                encountered for a module URI that is already among the known loaded modules (or
    *                modules in the process of being compiled), the <code>import module</code> is treated
    *                as a reference to the existing module. If the value is true, the system first checks
    *                whether the supplied "location hints" match the known location of the existing
    *                module, and the existing module is used only if there is a match.</p>
    *
    **/

    public final static String XQUERY_MULTIPLE_MODULE_IMPORTS =
        "http://saxon.sf.net/feature/xqueryMultipleModuleImports";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property defines whether "boundary space" (insignificant space in direct element
    *                constructors) should be retained or not.</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *
    **/

    public final static String XQUERY_PRESERVE_BOUNDARY_SPACE =
        "http://saxon.sf.net/feature/xqueryPreserveBoundarySpace";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property defines whether unused namespace declarations are retained by XQuery
    *                element copy operations.</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *
    **/

    public final static String XQUERY_PRESERVE_NAMESPACES =
        "http://saxon.sf.net/feature/xqueryPreserveNamespaces";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property defines the default expected context item type for a query.</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *
    **/

    public final static String XQUERY_REQUIRED_CONTEXT_ITEM_TYPE =
        "http://saxon.sf.net/feature/xqueryRequiredContextItemType";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>A query will automatically be schema-aware if it contains an <code>import
    *                    schema</code> declaration. This property allows a query to be marked as
    *                schema-aware even if it contains no <code>import schema</code> declaration. It is
    *                necessary for a query to be compiled as schema-aware if it is to handle typed
    *                (validated) input documents in which nodes have type annotations based on their
    *                schema-defined type.</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *
    **/

    public final static String XQUERY_SCHEMA_AWARE =
        "http://saxon.sf.net/feature/xquerySchemaAware";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The specified class is instantiated to create an <code>ErrorListener</code>, and all
    *                reports of static errors in a query will go to this <code>ErrorListener</code>.</p>
    *            <p>This option can be set for a particular XQuery compilation. When the option is set at
    *                the <code>Configuration</code> level, it acts as a default.</p>
    *            <p>In the absence of this property, the global <code>ErrorListener</code> specified as
    *                the value of the {@link net.sf.saxon.lib.FeatureKeys#ERROR_LISTENER_CLASS}
    *                property is used.</p>
    *
    **/

    public final static String XQUERY_STATIC_ERROR_LISTENER_CLASS =
        "http://saxon.sf.net/feature/xqueryStaticErrorListenerClass";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property determines the version of XQuery used by the
    *                <code>Configuration</code>.</p>
    *            <p>Indicates the version of XQuery syntax that is accepted. From Saxon 9.8, an XQuery 3.1
    *                processor is always used by default. So setting this property to a value less than 3.1 is no longer
    *                allowed. The value "4.0" enables experimental syntax extensions that are under discussion
    *                in the XML community, and subject to change.</p>
    *
    *
    **/

    public final static String XQUERY_VERSION =
        "http://saxon.sf.net/feature/xqueryVersion";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property determines the version of XML Schema used by the
    *                <code>Configuration</code>.</p>
    *            <p>From Saxon 9.8, the default is XSD 1.1. If XSD 1.0 is
    *                selected, XSD 1.1 features will be rejected, with the exception of the version
    *                control attributes that allow sections of the schema to be marked as requiring XSD
    *                1.0 or XSD 1.1.</p>
    *
    **/

    public final static String XSD_VERSION =
        "http://saxon.sf.net/feature/xsd-version";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property indicates whether assertions (XSLT 3.0 xsl:assert instructions) are
    *                enabled or disabled. They are disabled by default. Setting this property on causes
    *                assertions to be enabled at compile time for all XSLT packages compiled using the
    *                default configuration options.</p>
    *            <p>This option can be set for a particular XSLT compilation. When the option is set at
    *                the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it
    *                acts as a default.</p>
    *            <p>If assertions have been enabled at compile time for a particular package, they can
    *                still be disabled at run-time (for all packages) by setting an option on the
    *                    <code>Xslt30Transformer</code>. But if assertions were disabled at compile time,
    *                enabling them at run-time has no effect.</p>
    *
    **/

    public final static String XSLT_ENABLE_ASSERTIONS =
        "http://saxon.sf.net/feature/enableAssertions";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property indicates the name of a mode within a stylesheet in which execution
    *                (using template rules) should begin.</p>
    *            <p>This option can be set for a particular XSLT transformation. When the option is set
    *                at the <code>Configuration</code> (or on a <code>TransformerFactory</code>), it acts
    *                as a default.</p>
    *
    **/

    public final static String XSLT_INITIAL_MODE =
        "http://saxon.sf.net/feature/initialMode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property indicates the name of a named template within a stylesheet where
    *                execution should begin.</p>
    *            <p>This option can be set for a particular XSLT transformation. When the option is set
    *                at the <code>Configuration</code> level (or on a <code>TransformerFactory</code>),
    *                it acts as a default.</p>
    *            <p>Specifically, if the transformation is performed using the <code>transform()</code>
    *                method of class <code>net.sf.saxon.s9api.XsltTransformer</code>, then the transformation
    *                will proceed by calling the relevant named template, rather than by applying templates
    *                to the supplied source node. It will also affect other APIs built on top of the
    *                <code>XsltTransformer</code>, notably the JAXP transformation interface, which in turn
    *                is used by many higher-level interfaces such as Ant. Indeed, the main purpose of this
    *                configuration option is to allow named-template stylesheet invocation using the JAXP
    *                interface, which was designed without this feature in mind.</p>
    *            <p>This configuration option is ignored when using an <code>net.sf.saxon.s9api.Xslt30Transformer</code>,
    *                or other interfaces built on top of an <code>Xslt30Transformer</code>, for example the
    *                <code>net.sf.saxon.Transform</code> command line interface.</p>
    *
    **/

    public final static String XSLT_INITIAL_TEMPLATE =
        "http://saxon.sf.net/feature/initialTemplate";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property indicates whether stylesheets should be compiled with the ability to
    *                handle schema-typed input documents. By default a stylesheet is compiled to handle
    *                such input if it contains an <code>xsl:import-schema</code> instruction, and not
    *                otherwise. It is necessary for a stylesheet to be compiled as schema-aware if it is
    *                to handle typed (validated) input documents in which nodes have type annotations
    *                based on their schema-defined type.</p>
    *            <p>This option can be set for a particular XSLT compilation. When the option is set at
    *                the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it
    *                acts as a default.</p>
    *
    **/

    public final static String XSLT_SCHEMA_AWARE =
        "http://saxon.sf.net/feature/xsltSchemaAware";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The specified class is instantiated to create an <code>ErrorListener</code>, and all
    *                reports of static errors in a stylesheet will go to this
    *                <code>ErrorListener</code>.</p>
    *            <p>This option can be set for a particular XSLT compilation. When the option is set at
    *                the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it
    *                acts as a default.</p>
    *            <p>In the absence of this property, the global <code>ErrorListener</code> specified as
    *                the value of the {@link net.sf.saxon.lib.FeatureKeys#ERROR_LISTENER_CLASS}
    *                property is used.</p>
    *
    **/

    public final static String XSLT_STATIC_ERROR_LISTENER_CLASS =
        "http://saxon.sf.net/feature/stylesheetErrorListener";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property defines a <code>URIResolver</code> used when dereferencing the URIs
    *                that appear in the <code>href</code> attributes of the <code>xsl:include</code> and
    *                    <code>xsl:import</code> declarations. Note that this defaults to the setting of
    *                the global <code>URI_RESOLVER</code> property.</p>
    *            <p>This option can be set for a particular XSLT compilation. When the option is set at
    *                the <code>Configuration</code> level (or on a <code>TransformerFactory</code>), it
    *                acts as a default.</p>
    *            <p>In the absence of this property, the global <code>URIResolver</code> specified as the
    *                value of the {@link net.sf.saxon.lib.FeatureKeys#URI_RESOLVER_CLASS} property
    *                is used.</p>
    *
    **/

    public final static String XSLT_STATIC_URI_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/stylesheetURIResolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property determines the version of XSLT to be supported by default.</p>
    *            <p>From Saxon 9.8, an XSLT 3.0 processor is always used by default. So setting this
    *                property to a value less than 3.0 has no effect.</p>
    *            <p>The value 4.0 enables experimental syntax extensions, under discussion in the XML
    *            community, which are subject to change.</p>
    *
    *
    **/

    public final static String XSLT_VERSION =
        "http://saxon.sf.net/feature/xsltVersion";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This property sets a limit on the amount of backtracking performed during regular expression evaluation.</p>
    *            <p>The default is 10000000 (ten million) which typically represents an evaluation time of about ten seconds.
    *            After this time, evaluation of the regular expression will fail rather than making further attempts to find a
    *            match. If this limit is reached, it often suggests that there might be a better way of writing the regular expression.
    *            The value can be set to -1 (minus one) to mean "unlimited".</p>
    *            <p>Excessive backtracking is usually caused by nested loops in the regular expression, combined with processing
    *            of long input strings. Try to ensure that when nested loops are used, there is an unambiguous condition that causes
    *            the inner loop to terminate. For example <code>(/[^/]*)+</code> is fine (it matches a sequence of path segments separated
    *                by <code>/</code> characters), because the presence of <code>/</code> forces the inner loop to terminate. By contrast,
    *                <code>(/.*)+</code> matches the same input, but in many different ways, which could lead to excessive backtracking
    *            to no useful purpose.</p>
    *
    **/

    public final static String REGEX_BACKTRACKING_LIMIT =
        "http://saxon.sf.net/feature/regexBacktrackingLimit";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The XSD 1.1 specification states that XPath version 2.0 is used for expressions appearing in assertions and type
    *                alternatives. This option allows XPath 3.0 or 3.1 to be used instead.</p>
    *            <p>The recognized values are the integers 20, 30, and 31 representing versions 2.0, 3.0, and 3.1 respectively.</p>
    *
    **/

    public final static String XPATH_VERSION_FOR_XSD =
        "http://saxon.sf.net/feature/xpathVersionForXsd";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The XSLT 3.0 specification states that processors are required to support XPath 3.0 expressions within stylesheets, together
    *                with some extensions (maps) selected from the XPath 3.1 specification. Support for the full syntax of XPath 3.1 is
    *                optional, but it is the default in Saxon. This option allows a different XPath language level to be selected.</p>
    *            <p>The integer values 20, 30, and 31 denote XPath 2.0, 3.0, and 3.1 respectively, while the value 305 denotes XPath 3.0
    *                with the extensions defined in the XSLT 3.0 specification.</p>
    *
    **/

    public final static String XPATH_VERSION_FOR_XSLT =
        "http://saxon.sf.net/feature/xpathVersionForXslt";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Saxon-EE performs inlining of user-defined functions that are sufficiently simple: they must not be recursive,
    *                and they must be below a certain size. This option defines the size.</p>
    *            <p>The value is (roughly) the number of nodes in the expression tree representing the function body. This
    *                includes both explicit subexpressions, and subexpressions added by Saxon itself to perform implicit
    *                operations such as type checking or conversion of function arguments. The default value is 100.</p>
    *
    **/

    public final static String THRESHOLD_FOR_FUNCTION_INLINING =
        "http://saxon.sf.net/feature/thresholdForFunctionInlining";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>Saxon-EE generates bytecode to give faster execution of frequently-evaluated subexpressions.
    *                Bytecode is generated when a candidate expression has been evaluated a certain number of
    *                times, controlled by this parameter.
    *            </p>
    *            <p>Setting this parameter to 0 (or any negative value) has the effect of disabling bytecode
    *                generation completely. Setting the parameter to a positive value has the effect of enabling
    *                bytecode generation if it is not already enabled. Setting the value to 1 (one) causes bytecode
    *                to be generated for candidate expressions the first time it is executed.</p>
    *
    **/

    public final static String THRESHOLD_FOR_HOTSPOT_BYTE_CODE =
        "http://saxon.sf.net/feature/thresholdForHotspotByteCode";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The value is a comma-separated list of permitted protocols. A protocol is the
    *                scheme portion of a URI, or in the case of the JAR protocol, "jar"
    *                plus the scheme portion separated by colon. The value "all" gives access
    *                to all protocols (which is the default). The value "" (empty string) disallows
    *                all external resource access. (The format is thus the same as for
    *                <code>XMLConstants.ACCESS_EXTERNAL_SCHEMA</code> and similar attributes.)
    *            </p>
    *            <p>The value constrains access by Saxon (but not by underlying software, such
    *                as the XML parser) to resources including the following:</p>
    *
    *            <ul>
    *                <li>Stylesheet modules</li>
    *                <li>Schema documents</li>
    *                <li>Query modules</li>
    *                <li>Documents referenced from a stylesheet or query using functions such
    *                    as <code>fn:doc</code>, <code>fn:document</code>, <code>fn:unparsed-text</code>,
    *                    <code>fn:collection</code>, <code>fn:json-doc</code>, <code>fn:transform</code>, or by the
    *                    <code>xsl:source-document</code> instruction.</li>
    *                <li>Resources obtained using Saxon-supplied extension functions such as
    *                    those in the EXPath file library (but it does not affect user-supplied
    *                    extension functions).</li>
    *            </ul>
    *            <p>The constraint applies to the URI used to request
    *                the resource; the constraint is applied by the standard URI resolvers, but if
    *                user-supplied resolvers are used (such as a <code>URIResolver</code>), they can decide
    *                whether to apply the restrictions or not.</p>
    *            <p>The constraint applies to URIs used as locations or location hints, not to URIs used as names. So
    *            for XSD it applies to a schemaLocation, not a targetNamespace; for XQuery it applies to module
    *            location hints, not to module URIs. In the case of XSLT packages, resolution from a package name
    *            to a location is always under user/application control, so Saxon imposes no restrictions.</p>
    *            <p>The format is the same as for <code>XMLConstants.ACCESS_EXTERNAL_SCHEMA</code>: either <code>"all"</code> to allow
    *                all schemes/protocols, or a comma-separated list of scheme names such as <code>"http"</code>, <code>"file"</code>, <code>"ftp"</code>.
    *                For a JAR file scheme, use the format <code>"jar:<i>scheme</i>"</code>, for example <code>"jar:file"</code>. A zero-length
    *                string disallows all schemes.</p>
    *
    **/

    public final static String ALLOWED_PROTOCOLS =
        "http://saxon.sf.net/feature/allowedProtocols";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>By default, Saxon attempts to ensure that the run-time code contains no links to the original source stylesheet tree.
    *                This allows the garbage collector to free memory.
    *            </p>
    *            <p>If this option is set, then <code>Location</code> objects held in the run-time expression tree may contain a link
    *                to an element node in the source stylesheet, enabling a user-written <code>ErrorListener</code> to produce
    *                improved diagnostics. This may be an appropriate setting to use, for example, in an IDE.</p>
    *            <p>Links to source nodes are not retained in an exported SEF file, regardless of this setting.</p>
    *
    **/

    public final static String RETAIN_NODE_FOR_DIAGNOSTICS =
        "http://saxon.sf.net/feature/retainNodeForDiagnostics";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *      <p>The W3C XSD specification (both 1.0 and 1.1) states that an unresolved
    *        reference to an absent schema component does not automatically make the schema
    *        invalid; the schema should be usable for validation provided that the missing
    *        components are not actually needed in a particular validation episode.
    *      </p>
    *      <p>However, the W3C XSD conformance tests treat such an unresolved reference
    *      as an error; the test is expected to report the schema as invalid. And this
    *      is the way most schema processors actually operate, and probably what most
    *      users would expect.</p>
    *      <p>By default, the Saxon schema processor reports an unresolved reference
    *      as an error in the schema.</p>
    *      <p>If this option is set, then Saxon attempts to repair the schema so that
    *      it is usable for validation, by substituting the missing components with default
    *      components: for example if an attribute declaration refers to a type that has
    *      not been defined, then <code>xs:error</code> is substituted, making any instance
    *      of the attribute invalid.</p>
    *
    **/

    public final static String ALLOW_UNRESOLVED_SCHEMA_COMPONENTS =
        "http://saxon.sf.net/feature/allowUnresolvedSchemaComponents";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>This is used by the standard Collection Finder and may not be relevant
    *                if a custom Collection Finder is in use.
    *            </p>
    *            <p>If the absolutized URI passed to the collection() function matches
    *            this pattern, then the URI will be treated as a reference to a ZIP file
    *            (and will therefore fail if the URI does not resolve to a resource that can
    *            be opened as a ZIP file).</p>
    *
    *
    **/

    public final static String ZIP_URI_PATTERN =
        "http://saxon.sf.net/feature/zipUriPattern";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied implementation of <code>ResourceResolver</code> is used to
    *            resolve URIs. The default implementation uses XML Catalog files.
    *            The Saxon resource resolver is used by the entity resolver, URI resolver,
    *            unparsed text resolver, and other resolvers that resolve URIs to resources.</p>
    *
    **/

    public final static String RESOURCE_RESOLVER =
        "http://saxon.sf.net/feature/saxon-resource-resolver";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


    /**
    *            <p>The supplied class is instantiated and the resulting instance is used as the value of
    *                the {@link net.sf.saxon.lib.FeatureKeys#RESOURCE_RESOLVER} property.</p>
    *
    **/

    public final static String RESOURCE_RESOLVER_CLASS =
        "http://saxon.sf.net/feature/saxon-resource-resolver-class";

// AUTO-GENERATED FROM FeatureKeys.xml - DO NOT EDIT THIS FILE


}
