/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.value.BooleanValue;

public class Lang
extends SystemFunctionCall
implements Callable {
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        if (this.argument.length == 1) {
            if (contextInfo == null) {
                XPathException err = new XPathException("The context item for lang() is absent");
                err.setErrorCode("XPDY0002");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
            if (contextInfo instanceof AtomicType) {
                XPathException err = new XPathException("The context item for lang() is not a node");
                err.setErrorCode("XPTY0004");
                err.setIsTypeError(true);
                err.setLocator(this);
                throw err;
            }
        }
        return super.typeCheck(visitor, contextInfo);
    }

    public BooleanValue evaluateItem(XPathContext c) throws XPathException {
        NodeInfo target = this.argument.length > 1 ? (NodeInfo)this.argument[1].evaluateItem(c) : this.getAndCheckContextItem(c);
        Item arg0Val = this.argument[0].evaluateItem(c);
        String testLang = arg0Val == null ? "" : arg0Val.getStringValue();
        boolean b = Lang.isLang(testLang, target);
        return BooleanValue.get(b);
    }

    public int getIntrinsicDependencies() {
        return this.argument.length == 1 ? 2 : 0;
    }

    public static boolean isLang(String arglang, NodeInfo target) {
        String doclang = null;
        NodeInfo node = target;
        while (node != null && (doclang = node.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang")) == null) {
            if ((node = node.getParent()) != null) continue;
            return false;
        }
        if (doclang == null) {
            return false;
        }
        while (!arglang.equalsIgnoreCase(doclang)) {
            int hyphen = doclang.lastIndexOf("-");
            if (hyphen < 0) {
                return false;
            }
            doclang = doclang.substring(0, hyphen);
        }
        return true;
    }

    public BooleanValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        NodeInfo target = arguments.length > 1 ? (NodeInfo)arguments[1].head() : this.getAndCheckContextItem(context);
        Item arg0Val = arguments[0].head();
        String testLang = arg0Val == null ? "" : arg0Val.getStringValue();
        return BooleanValue.get(Lang.isLang(testLang, target));
    }

    private NodeInfo getAndCheckContextItem(XPathContext context) throws XPathException {
        Item current = context.getContextItem();
        if (current == null) {
            XPathException err = new XPathException("The context item for lang() is absent");
            err.setErrorCode("XPDY0002");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        if (!(current instanceof NodeInfo)) {
            XPathException err = new XPathException("The context item for lang() is not a node");
            err.setErrorCode("XPTY0004");
            err.setLocator(this);
            err.setXPathContext(context);
            throw err;
        }
        NodeInfo target = (NodeInfo)current;
        return target;
    }
}

