/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Arrays;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.OperandUsage;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class Concat
extends SystemFunction {
    protected Sequence resultIfEmpty(int arg) {
        return null;
    }

    public OperandRole[] getOperandRoles() {
        OperandRole[] roles = new OperandRole[this.getArity()];
        OperandRole operandRole = new OperandRole(0, OperandUsage.ABSORPTION);
        for (int i = 0; i < this.getArity(); ++i) {
            roles[i] = operandRole;
        }
        return roles;
    }

    public FunctionItemType getFunctionItemType() {
        Object[] argTypes = new SequenceType[this.getArity()];
        Arrays.fill(argTypes, SequenceType.OPTIONAL_ATOMIC);
        return new SpecificFunctionType((SequenceType[])argTypes, SequenceType.SINGLE_STRING);
    }

    public StringValue call(XPathContext context, Sequence[] arguments) throws XPathException {
        FastStringBuffer fsb = new FastStringBuffer(64);
        for (Sequence arg : arguments) {
            Item item = arg.head();
            if (item == null) continue;
            fsb.append(item.getStringValueCS());
        }
        return new StringValue(fsb);
    }

    public SequenceType getRequiredType(int arg) {
        return this.getDetails().argumentTypes[0];
    }
}

