/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasePackageLoader {
    private static final Map<CacheKey, Set<String>> CACHE = new HashMap<CacheKey, Set<String>>();
    private static final Logger LOG = LoggerFactory.getLogger(BasePackageLoader.class);

    private BasePackageLoader() {
    }

    public static Set<String> loadBasePackages(String source) {
        return BasePackageLoader.loadBasePackages(source, Thread.currentThread().getContextClassLoader());
    }

    public static Set<String> loadBasePackages(String source, ClassLoader classLoader) {
        HashSet<String> basePackages;
        CacheKey cacheKey = new CacheKey(source, classLoader);
        if (CACHE.containsKey(cacheKey)) {
            basePackages = CACHE.get(cacheKey);
        } else {
            basePackages = new HashSet();
            BasePackageLoader.fillBasePackages(basePackages, source, classLoader);
            CACHE.put(cacheKey, basePackages);
        }
        return basePackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fillBasePackages(Set<String> basePackages, String source, ClassLoader classLoader) {
        try {
            Enumeration<URL> resources = classLoader.getResources(source);
            while (resources.hasMoreElements()) {
                URL resourceUrl = resources.nextElement();
                BufferedReader reader = new BufferedReader(new InputStreamReader(resourceUrl.openStream(), "UTF-8"));
                try {
                    BasePackageLoader.fillBasePackages(basePackages, reader);
                }
                finally {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            LOG.warn("Exception occurred when trying to load base packages from " + source, (Throwable)e);
        }
    }

    static void fillBasePackages(Set<String> basePackages, BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            if ((line = line.split("#")[0].trim()).equals("")) continue;
            basePackages.add(line);
        }
    }

    private static class CacheKey {
        private final String source;
        private final ClassLoader classLoader;

        CacheKey(String source, ClassLoader classLoader) {
            this.source = source;
            this.classLoader = classLoader;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.classLoader == null ? 0 : this.classLoader.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.classLoader == null ? other.classLoader != null : !this.classLoader.equals(other.classLoader)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }
    }
}

