/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import net.sf.testng.databinding.util.ConstructorMatcher;

public class Constructors {
    private Constructors() {
    }

    public static <T> Constructor<T> getMatchingConstructor(Class<? extends T> clazz, ConstructorMatcher matcher) throws NoSuchMethodException {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            Type[] parameterTypes = constructor.getGenericParameterTypes();
            if (!matcher.matches(parameterTypes)) continue;
            return constructor;
        }
        throw new NoSuchMethodException("The expected constructor could not be found on the " + clazz);
    }

    public static boolean hasMatchingConstructor(Class<?> clazz, ConstructorMatcher matcher) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (!matcher.matches(constructor.getGenericParameterTypes())) continue;
            return true;
        }
        return false;
    }
}

