/*
 * Decompiled with CFR 0.152.
 */
package net.sf.testng.databinding.util;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static Properties removeKeyPrefix(Properties source, String prefix) {
        Properties target = new Properties();
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            String key = entry.getKey().toString();
            if (!key.startsWith(prefix)) continue;
            key = key.substring(prefix.length());
            target.setProperty(key, entry.getValue().toString());
        }
        return target;
    }

    public static void copyProperties(Properties source, Properties target) {
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            target.put(entry.getKey(), entry.getValue());
        }
    }

    public static KeyExtractor getAllKeysFrom(Properties source) {
        return new KeyExtractor(source);
    }

    public static class KeyExtractor {
        private Properties source;

        private KeyExtractor(Properties source) {
            this.source = source;
        }

        public String[] startingWith(String prefix) {
            ArrayList<String> keys = new ArrayList<String>();
            for (Object key : this.source.keySet()) {
                if (!key.toString().startsWith(prefix)) continue;
                keys.add(key.toString());
            }
            return keys.toArray(new String[0]);
        }
    }
}

