/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.httpclient.resource;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import org.apache.hc.core5.http.ClassicHttpResponse;

public class ConnectionClosingInputStream
extends InputStream {
    @Nonnull
    private final ClassicHttpResponse response;
    @Nonnull
    private final InputStream stream;

    public ConnectionClosingInputStream(@Nonnull ClassicHttpResponse httpResponse) throws IOException {
        this.response = httpResponse;
        InputStream str = this.response.getEntity().getContent();
        assert (str != null);
        this.stream = str;
    }

    @Override
    public int available() throws IOException {
        return this.stream.available();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
        this.response.close();
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.stream.mark(readLimit);
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.stream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.stream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.stream.skip(n);
    }
}

