/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.httpclient.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractIdentifiedInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.httpclient.resource.ConnectionClosingInputStream;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.cache.HttpCacheContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class HTTPResource
extends AbstractIdentifiedInitializableComponent
implements Resource,
BeanNameAware,
InitializingBean,
net.shibboleth.shared.resource.Resource {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(HTTPResource.class);
    @Nonnull
    private final HttpClient httpClient;
    @Nonnull
    private final URL resourceURL;
    @Nullable
    private HttpClientContextHandler httpClientContextHandler;

    public HTTPResource(@Nonnull @ParameterName(name="client") HttpClient client, @Nonnull @ParameterName(name="url") @NotEmpty String url) throws IOException {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
        String trimmedAddress = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)url), (String)"Provided URL cannot be null or empty");
        this.resourceURL = new URL(trimmedAddress);
    }

    public HTTPResource(@Nonnull @ParameterName(name="") HttpClient client, @Nonnull @ParameterName(name="url") URL url) throws IOException {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
        this.resourceURL = (URL)Constraint.isNotNull((Object)url, (String)"Provided URL cannot be null or empty");
    }

    public void setHttpClientContextHandler(@Nonnull HttpClientContextHandler handler) {
        this.checkSetterPreconditions();
        this.httpClientContextHandler = handler;
    }

    @Nonnull
    protected HttpCacheContext buildHttpClientContext() {
        HttpCacheContext result = HttpCacheContext.create();
        assert (result != null);
        return result;
    }

    protected void reportCachingStatus(@Nonnull HttpCacheContext context) {
        CacheResponseStatus responseStatus = context.getCacheResponseStatus();
        if (null == responseStatus) {
            this.log.debug("Non caching client provided");
            return;
        }
        switch (responseStatus) {
            case CACHE_HIT: {
                this.log.debug("A response was generated from the cache with no requests sent upstream");
                break;
            }
            case CACHE_MODULE_RESPONSE: {
                this.log.debug("The response was generated directly by the caching module");
                break;
            }
            case CACHE_MISS: {
                this.log.debug("The response came from an upstream server");
                break;
            }
            case VALIDATED: {
                this.log.debug("The response was generated from the cache after validating the entry with the origin server");
                break;
            }
            default: {
                this.log.info("Unknown status {}", (Object)responseStatus.toString());
            }
        }
    }

    @Nonnull
    public InputStream getInputStream() throws IOException {
        HttpGet httpGet = new HttpGet(this.resourceURL.toExternalForm());
        HttpCacheContext context = this.buildHttpClientContext();
        HttpClientContextHandler contextHandler = this.httpClientContextHandler;
        if (contextHandler != null) {
            this.log.debug("Invoking HttpClientContextHandler prior to execution");
            contextHandler.invokeBefore((HttpClientContext)context, (ClassicHttpRequest)httpGet);
        }
        this.log.debug("Attempting to get data from remote resource '{}'", (Object)this.resourceURL);
        ClassicHttpResponse response = this.httpClient.executeOpen(null, (ClassicHttpRequest)httpGet, (HttpContext)context);
        if (contextHandler != null) {
            this.log.debug("Invoking HttpClientContextHandler after execution");
            try {
                contextHandler.invokeAfter((HttpClientContext)context, (ClassicHttpRequest)httpGet);
            }
            catch (Throwable e) {
                this.closeResponse(response);
                throw e;
            }
        }
        this.reportCachingStatus(context);
        int httpStatusCode = response.getCode();
        if (httpStatusCode != 200) {
            String errMsg = "Non-ok status code " + httpStatusCode + " returned from remote resource " + this.resourceURL;
            this.log.error(errMsg);
            this.closeResponse(response);
            throw new IOException(errMsg);
        }
        return new ConnectionClosingInputStream(response);
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    public void setBeanName(@Nonnull String name) {
        this.setId(name);
    }

    public boolean exists() {
        HttpResponse response;
        this.log.debug("Attempting to fetch remote resource as '{}'", (Object)this.resourceURL);
        try {
            response = this.getResourceHeaders();
        }
        catch (IOException e) {
            return false;
        }
        int httpStatusCode = response.getCode();
        return httpStatusCode == 200;
    }

    public boolean isFile() {
        return false;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isOpen() {
        return false;
    }

    @Nonnull
    public URL getURL() throws IOException {
        return this.resourceURL;
    }

    @Nonnull
    public URI getURI() throws IOException {
        try {
            URI result = this.resourceURL.toURI();
            assert (result != null);
            return result;
        }
        catch (URISyntaxException ex) {
            throw new IOException("Invalid URI [" + this.resourceURL + "]", ex);
        }
    }

    @Nonnull
    public File getFile() throws IOException {
        throw new FileNotFoundException("HTTPResource cannot be resolved to absolute file path because it does not reside in the file system: " + this.resourceURL);
    }

    @Nonnull
    protected HttpResponse getResourceHeaders() throws IOException {
        HttpGet httpRequest = new HttpGet(this.resourceURL.toExternalForm());
        ClassicHttpResponse httpResponse = null;
        try {
            HttpCacheContext context = this.buildHttpClientContext();
            HttpClientContextHandler contextHandler = this.httpClientContextHandler;
            if (contextHandler != null) {
                this.log.debug("Invoking HttpClientContextHandler prior to execution");
                contextHandler.invokeBefore((HttpClientContext)context, (ClassicHttpRequest)httpRequest);
            }
            httpResponse = this.httpClient.executeOpen(null, (ClassicHttpRequest)httpRequest, (HttpContext)context);
            if (contextHandler != null) {
                this.log.debug("Invoking HttpClientContextHandler after execution");
                contextHandler.invokeAfter((HttpClientContext)context, (ClassicHttpRequest)httpRequest);
            }
            this.reportCachingStatus(context);
            EntityUtils.consume((HttpEntity)httpResponse.getEntity());
            ClassicHttpResponse classicHttpResponse = httpResponse;
            this.closeResponse(httpResponse);
            return classicHttpResponse;
        }
        catch (IOException e) {
            try {
                throw new IOException("Error contacting remote resource " + this.resourceURL.toString(), e);
            }
            catch (Throwable throwable) {
                this.closeResponse(httpResponse);
                throw throwable;
            }
        }
    }

    @Nullable
    protected String getResponseHeader(String what) throws IOException {
        this.log.debug("Attempting to fetch remote resource as '{}'", (Object)this.resourceURL);
        HttpResponse response = this.getResourceHeaders();
        int httpStatusCode = response.getCode();
        if (httpStatusCode != 200) {
            String errMsg = "Non-ok status code " + httpStatusCode + " returned from remote resource " + this.resourceURL;
            this.log.error(errMsg);
            throw new IOException(errMsg);
        }
        Header httpHeader = response.getFirstHeader(what);
        if (httpHeader != null) {
            return httpHeader.getValue();
        }
        return null;
    }

    public long contentLength() throws IOException {
        String response = this.getResponseHeader("Content-Length");
        if (null != response) {
            return Long.parseLong(response);
        }
        String errMsg = "Response from remote resource " + this.resourceURL.toString() + " did not contain a Content-Length header";
        this.log.error(errMsg);
        throw new IOException(errMsg);
    }

    public long lastModified() throws IOException {
        String response = this.getResponseHeader("Last-Modified");
        if (null != response) {
            return DateUtils.parseStandardDate((String)response).toEpochMilli();
        }
        String errMsg = "Response from remote resource " + this.resourceURL.toString() + " did not contain a Last-Modified header";
        this.log.error(errMsg);
        throw new IOException(errMsg);
    }

    @Nonnull
    public HTTPResource createRelative(@Nonnull String relativePath) throws IOException {
        return this.createRelative(relativePath, null);
    }

    @Nonnull
    public HTTPResource createRelative(@Nonnull String relativePath, @Nullable HttpClientContextHandler handler) throws IOException {
        String path = relativePath.startsWith("/") ? relativePath.substring(1) : relativePath;
        HTTPResource result = new HTTPResource(this.httpClient, new URL(this.resourceURL, path));
        if (handler != null) {
            result.setHttpClientContextHandler(handler);
        }
        try {
            result.setId(this.getId() + "_" + relativePath);
            result.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new IOException(e);
        }
        return result;
    }

    @Nonnull
    public net.shibboleth.shared.resource.Resource createRelativeResource(@Nonnull String relativePath) throws IOException {
        return this.createRelative(relativePath);
    }

    @Nullable
    public String getFilename() {
        return new File(this.resourceURL.getFile()).getName();
    }

    @Nonnull
    public String getDescription() {
        StringBuilder builder = new StringBuilder("HTTPResource [").append(this.resourceURL.toString()).append(']');
        String result = builder.toString();
        assert (result != null);
        return result;
    }

    protected void closeResponse(@Nullable ClassicHttpResponse response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (IOException e) {
            this.log.error("Error closing HTTP response from '{}'", (Object)this.resourceURL.toExternalForm(), (Object)e);
        }
    }
}

