/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.shared.testing;

import javax.annotation.Nonnull;

import net.shibboleth.shared.primitive.NonnullSupplier;

/**
 * Implementaion of {@link NonnullSupplier} which returns an unchanging
 * value.
 * 
 * @param <T> type of supplier
 */
public final class ConstantSupplier<T> implements NonnullSupplier<T> {

    /** The value we will return. */
    @Nonnull private final T theValue;
    
    /**
     * Constructor.
     *
     * @param value the value to set
     */
    public ConstantSupplier(@Nonnull final T value) {
        theValue = value;
    }
    /** {@inheritDoc} */
    @Override
    @Nonnull public T get() {
        return theValue;
    }

}