/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.testing;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.hsqldb.jdbc.JDBCDataSource;
import org.slf4j.Logger;

public final class DatabaseTestingSupport {
    @Nonnull
    private static Logger log = LoggerFactory.getLogger(DatabaseTestingSupport.class);

    private DatabaseTestingSupport() {
    }

    public static void InitializeDataSource(@Nullable String initializingSQLFile, @Nonnull DataSource source) {
        String sql = DatabaseTestingSupport.ReadSqlFromFile(initializingSQLFile);
        if (sql == null) {
            return;
        }
        DatabaseTestingSupport.ExecuteUpdate(sql, source);
    }

    @Nullable
    protected static String ReadSqlFromFile(@Nullable String initializingSQLFile) {
        String sql;
        String file = StringSupport.trimOrNull((String)initializingSQLFile);
        if (null == file) {
            return null;
        }
        InputStream is = DatabaseTestingSupport.class.getResourceAsStream(file);
        if (null == is) {
            log.warn("Could not locate SQL file called {} ", (Object)file);
            return null;
        }
        try {
            sql = StringSupport.trimOrNull((String)CharStreams.toString((Readable)new InputStreamReader(is)));
        }
        catch (IOException e) {
            log.warn("Could not read SQL file called {}.", (Object)file);
            return null;
        }
        if (null == sql) {
            log.warn("SQL file called {} was empty.", (Object)file);
            return null;
        }
        return sql;
    }

    protected static void ExecuteUpdate(@Nullable String sql, DataSource source) {
        log.debug("Applying SQL: \n {}", (Object)sql);
        try {
            Connection dbConn = source.getConnection();
            Statement statement = dbConn.createStatement();
            statement.executeUpdate(sql);
        }
        catch (SQLException e) {
            log.warn("Could not contact data source {} or execute commands", (Object)source, (Object)e);
            return;
        }
    }

    @Nonnull
    public static DataSource GetMockDataSource(@Nonnull String initializingSQLFile, @Nonnull String identifier) {
        return DatabaseTestingSupport.GetDataSourceFromUrl(initializingSQLFile, "jdbc:hsqldb:mem:" + identifier);
    }

    @Nonnull
    public static DataSource GetDataSourceFromHsqlServer(@Nonnull String initializingSQLFile, @Nonnull String server) {
        return DatabaseTestingSupport.GetDataSourceFromUrl(initializingSQLFile, "jdbc:hsqldb:hsql:" + server);
    }

    public static void InitializeDataSourceFromFile(String sqlFile, DataSource source) {
        String[] statements;
        String sql = DatabaseTestingSupport.ReadSqlFromFile(sqlFile);
        assert (sql != null);
        for (String statement : statements = sql.split(";")) {
            DatabaseTestingSupport.ExecuteUpdate(statement.trim(), source);
        }
    }

    @Nonnull
    protected static DataSource GetDataSourceFromUrl(@Nonnull String initializingSQLFile, @Nonnull String JdbcUri) {
        JDBCDataSource jdbcSource = new JDBCDataSource();
        jdbcSource.setUrl(JdbcUri);
        jdbcSource.setUser("SA");
        jdbcSource.setPassword("");
        DatabaseTestingSupport.InitializeDataSource(initializingSQLFile, (DataSource)jdbcSource);
        return jdbcSource;
    }
}

