/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.testing;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.listener.InMemoryRequestHandler;
import com.unboundid.ldap.listener.InMemorySASLBindHandler;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldif.LDIFReader;
import com.unboundid.util.ssl.SSLUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.annotation.constraint.Positive;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.core.io.Resource;

public class InMemoryDirectory {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InMemoryDirectory.class);
    @Nonnull
    private final InMemoryDirectoryServer directoryServer;
    @Nonnull
    private final CustomServerSocketFactory customServerSocketFactory;

    public InMemoryDirectory(@ParameterName(name="baseDNs") @Nonnull String[] baseDNs, @ParameterName(name="ldif") @Nonnull Resource ldif, @ParameterName(name="port") @Positive int port) {
        Constraint.isNotNull((Object)ldif, (String)"LDIF resource cannot be null");
        try {
            InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(baseDNs);
            this.customServerSocketFactory = new CustomServerSocketFactory();
            InMemoryListenerConfig listenerConfig = new InMemoryListenerConfig("default", InetAddress.getByName("localhost"), port, (ServerSocketFactory)this.customServerSocketFactory, null, null);
            config.setListenerConfigs(new InMemoryListenerConfig[]{listenerConfig});
            config.addAdditionalBindCredentials("cn=Directory Manager", "password");
            this.addSuccessSaslBindHandlers(config);
            this.directoryServer = new InMemoryDirectoryServer(config);
            this.directoryServer.importFromLDIF(true, new LDIFReader(ldif.getInputStream()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating directory server", e);
        }
    }

    public InMemoryDirectory(@ParameterName(name="baseDNs") @Nonnull String[] baseDNs, @ParameterName(name="ldif") @Nonnull Resource ldif, @ParameterName(name="port") @Positive int port, @ParameterName(name="keystore") @Nonnull Resource keystore, @ParameterName(name="truststore") @Nonnull Optional<Resource> truststore) {
        Constraint.isNotNull((Object)ldif, (String)"LDIF resource cannot be null");
        try {
            InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(baseDNs);
            KeyManager[] keyManagers = InMemoryDirectory.getKeyManagerFactory(keystore).getKeyManagers();
            TrustManager[] trustManagers = truststore.isPresent() ? InMemoryDirectory.getTrustManagerFactory(truststore.get()).getTrustManagers() : null;
            SSLUtil sslUtil = new SSLUtil(keyManagers, trustManagers);
            this.customServerSocketFactory = new CustomServerSocketFactory();
            InMemoryListenerConfig listenerConfig = new InMemoryListenerConfig("default", InetAddress.getByName("localhost"), port, (ServerSocketFactory)this.customServerSocketFactory, null, sslUtil.createSSLSocketFactory());
            config.setListenerConfigs(new InMemoryListenerConfig[]{listenerConfig});
            config.addAdditionalBindCredentials("cn=Directory Manager", "password");
            this.addSuccessSaslBindHandlers(config);
            this.directoryServer = new InMemoryDirectoryServer(config);
            this.directoryServer.importFromLDIF(true, new LDIFReader(ldif.getInputStream()));
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating directory server", e);
        }
    }

    private void addSuccessSaslBindHandlers(InMemoryDirectoryServerConfig config) {
        config.addSASLBindHandler(new InMemorySASLBindHandler(){

            public String getSASLMechanismName() {
                return "DIGEST-MD5";
            }

            public BindResult processSASLBind(InMemoryRequestHandler handler, int messageID, DN bindDN, ASN1OctetString credentials, List<Control> controls) {
                return new BindResult(new LDAPResult(messageID, ResultCode.SUCCESS));
            }
        });
        config.addSASLBindHandler(new InMemorySASLBindHandler(){

            public String getSASLMechanismName() {
                return "EXTERNAL";
            }

            public BindResult processSASLBind(InMemoryRequestHandler handler, int messageID, DN bindDN, ASN1OctetString credentials, List<Control> controls) {
                return new BindResult(new LDAPResult(messageID, ResultCode.SUCCESS));
            }
        });
    }

    public long openConnectionCount() {
        return this.customServerSocketFactory.sockets.stream().filter(s -> !s.isClosed()).count();
    }

    public void start() {
        try {
            this.directoryServer.startListening();
        }
        catch (LDAPException e) {
            throw new RuntimeException(e);
        }
        this.log.info("In-memory directory server started");
    }

    public void stop(boolean closeConnections) {
        this.directoryServer.shutDown(closeConnections);
        this.log.info("In-memory directory server stopped");
    }

    private static KeyManagerFactory getKeyManagerFactory(Resource keystore) throws GeneralSecurityException, IOException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(InMemoryDirectory.loadKeyStore(keystore, "changeit"), "changeit".toCharArray());
        return keyManagerFactory;
    }

    private static TrustManagerFactory getTrustManagerFactory(Resource keystore) throws GeneralSecurityException, IOException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(InMemoryDirectory.loadKeyStore(keystore, "changeit"));
        return trustManagerFactory;
    }

    private static KeyStore loadKeyStore(Resource keystore, String password) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(keystore.getInputStream(), password.toCharArray());
        return ks;
    }

    private static class CustomServerSocketFactory
    extends ServerSocketFactory {
        @Nonnull
        private List<Socket> sockets = new ArrayList<Socket>();

        private CustomServerSocketFactory() {
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return new CustomServerSocket(port, 50, null);
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog) throws IOException {
            return new CustomServerSocket(port, backlog, null);
        }

        @Override
        public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
            return new CustomServerSocket(port, backlog, ifAddress);
        }

        private class CustomServerSocket
        extends ServerSocket {
            public CustomServerSocket(int port, int backlog, InetAddress bindAddr) throws IOException {
                super(port, backlog, bindAddr);
            }

            @Override
            public Socket accept() throws IOException {
                Socket socket = super.accept();
                CustomServerSocketFactory.this.sockets.add(socket);
                return socket;
            }
        }
    }
}

