/*
 * Licensed to the University Corporation for Advanced Internet Development, 
 * Inc. (UCAID) under one or more contributor license agreements.  See the 
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache 
 * License, Version 2.0 (the "License"); you may not use this file except in 
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.utilities.java.support.resolver;

/**
 * A resolver that takes a {@link Criterion} and selects data based on upon it.
 * 
 * Note because selection is based upon the {@link Criterion} received, the resolver must understand the various
 * {@link Criterion} implementations which may be passed in.
 * 
 * @param <ProductType> the type of objects produced by this resolver
 */
public interface CriteriaBasedResolver<ProductType> extends Resolver<ProductType, Criterion> {

}