/*
 * Licensed to the University Corporation for Advanced Internet Development, 
 * Inc. (UCAID) under one or more contributor license agreements.  See the 
 * NOTICE file distributed with this work for additional information regarding
 * copyright ownership. The UCAID licenses this file to You under the Apache 
 * License, Version 2.0 (the "License"); you may not use this file except in 
 * compliance with the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.utilities.java.support.resolver;

import com.google.common.base.Predicate;

/**
 * A resolver that searches over a collection of data and selects items based on a given {@link Predicate}.
 * 
 * Note because selection is done using a {@link Predicate}, the structure of the data within the resolver must be known
 * to the {@link Predicate} implementation.
 * 
 * @param <ProductType> the type of objects produced by this resolver
 */
public interface PredicateBasedResolver<ProductType> extends Resolver<ProductType, Predicate> {

}