/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.httpclient;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.httpclient.HttpClientSupport;
import net.shibboleth.utilities.java.support.httpclient.RequestConnectionClose;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.util.CharsetUtils;

public class HttpClientBuilder {
    private InetAddress socketLocalAddress;
    private int socketTimeout;
    private int socketBufferSize;
    private int connectionTimeout;
    private boolean connectionDisregardSslCertificate;
    private boolean connectionCloseAfterResponse;
    private boolean connectionStalecheck;
    private String connectionProxyHost;
    private int connectionProxyPort;
    private String connectionProxyUsername;
    private String connectionProxyPassword;
    private boolean httpFollowRedirects;
    private String httpContentCharSet;
    private org.apache.http.impl.client.HttpClientBuilder apacheBuilder;

    public HttpClientBuilder() {
        this(org.apache.http.impl.client.HttpClientBuilder.create());
    }

    public HttpClientBuilder(@Nonnull org.apache.http.impl.client.HttpClientBuilder builder) {
        Constraint.isNotNull(builder, "Apache HttpClientBuilder may not be null");
        this.apacheBuilder = builder;
        this.resetDefaults();
    }

    public void resetDefaults() {
        this.socketLocalAddress = null;
        this.socketTimeout = 5000;
        this.socketBufferSize = 8192;
        this.connectionTimeout = 5000;
        this.connectionDisregardSslCertificate = false;
        this.connectionCloseAfterResponse = true;
        this.connectionStalecheck = false;
        this.connectionProxyHost = null;
        this.connectionProxyPort = 8080;
        this.connectionProxyUsername = null;
        this.connectionProxyPassword = null;
        this.httpFollowRedirects = true;
        this.httpContentCharSet = "UTF-8";
    }

    public InetAddress getSocketLocalAddress() {
        return this.socketLocalAddress;
    }

    public void setSocketLocalAddress(InetAddress address) {
        this.socketLocalAddress = address;
    }

    public void setSocketLocalAddress(String ipOrHost) throws UnknownHostException {
        this.socketLocalAddress = InetAddress.getByName(Constraint.isNotNull(ipOrHost, "IP or hostname may not be null"));
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void setSocketBufferSize(int size) {
        this.socketBufferSize = (int)Constraint.isGreaterThan(0L, size, "Socket buffer size must be greater than 0");
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int timeout) {
        this.connectionTimeout = timeout;
    }

    public boolean isConnectionDisregardSslCertificate() {
        return this.connectionDisregardSslCertificate;
    }

    public void setConnectionDisregardSslCertificate(boolean disregard) {
        this.connectionDisregardSslCertificate = disregard;
    }

    public boolean isConnectionCloseAfterResponse() {
        return this.connectionCloseAfterResponse;
    }

    public void setConnectionCloseAfterResponse(boolean close) {
        this.connectionCloseAfterResponse = close;
    }

    public boolean isConnectionStalecheck() {
        return this.connectionStalecheck;
    }

    public void setConnectionStalecheck(boolean check) {
        this.connectionStalecheck = check;
    }

    public String getConnectionProxyHost() {
        return this.connectionProxyHost;
    }

    public void setConnectionProxyHost(String host) {
        this.connectionProxyHost = StringSupport.trimOrNull(host);
    }

    public int getConnectionProxyPort() {
        return this.connectionProxyPort;
    }

    public void setConnectionProxyPort(int port) {
        this.connectionProxyPort = (int)Constraint.numberInRangeExclusive(0L, 65536L, port, "Proxy port must be between 0 and 65536, exclusive");
    }

    public String getConnectionProxyUsername() {
        return this.connectionProxyUsername;
    }

    public void setConnectionProxyUsername(String usename) {
        this.connectionProxyUsername = usename;
    }

    public String getConnectionProxyPassword() {
        return this.connectionProxyPassword;
    }

    public void setConnectionProxyPassword(String password) {
        this.connectionProxyPassword = password;
    }

    public boolean isHttpFollowRedirects() {
        return this.httpFollowRedirects;
    }

    public void setHttpFollowRedirects(boolean followRedirects) {
        this.httpFollowRedirects = followRedirects;
    }

    public String getHttpContentCharSet() {
        return this.httpContentCharSet;
    }

    public void setHttpContentCharSet(String charSet) {
        this.httpContentCharSet = charSet;
    }

    public final HttpClient buildClient() throws Exception {
        this.decorateApacheBuilder();
        return this.getApacheBuilder().build();
    }

    protected void decorateApacheBuilder() throws Exception {
        org.apache.http.impl.client.HttpClientBuilder builder = this.getApacheBuilder();
        if (this.connectionDisregardSslCertificate) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)HttpClientSupport.buildNoTrustSSLConnectionSocketFactory());
        }
        if (this.connectionCloseAfterResponse) {
            builder.addInterceptorLast((HttpRequestInterceptor)new RequestConnectionClose());
        }
        RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
        if (this.socketLocalAddress != null) {
            requestConfigBuilder.setLocalAddress(this.socketLocalAddress);
        }
        if (this.socketTimeout > 0) {
            requestConfigBuilder.setSocketTimeout(this.socketTimeout);
        }
        if (this.connectionTimeout > 0) {
            requestConfigBuilder.setConnectTimeout(this.connectionTimeout);
        }
        requestConfigBuilder.setStaleConnectionCheckEnabled(this.connectionStalecheck);
        requestConfigBuilder.setRedirectsEnabled(this.httpFollowRedirects);
        if (this.connectionProxyHost != null) {
            HttpHost proxyHost = new HttpHost(this.connectionProxyHost, this.connectionProxyPort);
            requestConfigBuilder.setProxy(proxyHost);
            if (this.connectionProxyUsername != null && this.connectionProxyPassword != null) {
                BasicCredentialsProvider credProvider = new BasicCredentialsProvider();
                credProvider.setCredentials(new AuthScope(this.connectionProxyHost, this.connectionProxyPort), (Credentials)new UsernamePasswordCredentials(this.connectionProxyUsername, this.connectionProxyPassword));
                builder.setDefaultCredentialsProvider((CredentialsProvider)credProvider);
            }
        }
        ConnectionConfig.Builder connectionConfigBuilder = ConnectionConfig.custom();
        connectionConfigBuilder.setBufferSize(this.socketBufferSize);
        if (this.httpContentCharSet != null) {
            connectionConfigBuilder.setCharset(CharsetUtils.get((String)this.httpContentCharSet));
        }
        builder.setDefaultRequestConfig(requestConfigBuilder.build());
        builder.setDefaultConnectionConfig(connectionConfigBuilder.build());
    }

    protected org.apache.http.impl.client.HttpClientBuilder getApacheBuilder() {
        return this.apacheBuilder;
    }
}

