/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.rdfxml.parser;

import java.util.List;
import java.util.logging.Logger;
import org.coode.owlapi.rdfxml.parser.ListItemTranslator;
import org.coode.owlapi.rdfxml.parser.OWLRDFConsumer;
import org.coode.owlapi.rdfxml.parser.OptimisedListTranslator;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.vocab.SWRLVocabulary;

public class SWRLAtomListItemTranslator
implements ListItemTranslator<SWRLAtom> {
    private static final Logger logger = Logger.getLogger(SWRLAtomListItemTranslator.class.getName());
    private OWLRDFConsumer consumer;
    protected OWLDataFactory dataFactory;

    public SWRLAtomListItemTranslator(OWLRDFConsumer consumer) {
        this.consumer = consumer;
        this.dataFactory = consumer.getDataFactory();
    }

    @Override
    public SWRLAtom translate(IRI firstObject) {
        if (this.consumer.isSWRLBuiltInAtom(firstObject)) {
            IRI builtInIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.BUILT_IN.getIRI(), true);
            IRI mainIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.ARGUMENTS.getIRI(), true);
            OptimisedListTranslator<SWRLDArgument> listTranslator = new OptimisedListTranslator<SWRLDArgument>(this.consumer, new SWRLAtomDObjectListItemTranslator());
            List<SWRLDArgument> args = listTranslator.translateList(mainIRI);
            return this.dataFactory.getSWRLBuiltInAtom(builtInIRI, args);
        }
        if (this.consumer.isSWRLClassAtom(firstObject)) {
            SWRLIArgument iObject = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            IRI classIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.CLASS_PREDICATE.getIRI(), true);
            if (classIRI == null) {
                throw new OWLRuntimeException("Don't know how to translate SWRL Atom: class IRI is null " + firstObject);
            }
            OWLClassExpression desc = this.consumer.translateClassExpression(classIRI);
            return this.dataFactory.getSWRLClassAtom(desc, iObject);
        }
        if (this.consumer.isSWRLDataRangeAtom(firstObject)) {
            SWRLDArgument dObject = this.translateSWRLAtomDObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            IRI dataRangeIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.DATA_RANGE.getIRI(), true);
            if (dataRangeIRI == null) {
                throw new OWLRuntimeException("Don't know how to translate SWRL Atom: data range IRI is null " + firstObject);
            }
            OWLDataRange dataRange = this.consumer.translateDataRange(dataRangeIRI);
            return this.dataFactory.getSWRLDataRangeAtom(dataRange, dObject);
        }
        if (this.consumer.isSWRLDataValuedPropertyAtom(firstObject)) {
            SWRLIArgument arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            SWRLDArgument arg2 = this.translateSWRLAtomDObject(firstObject, SWRLVocabulary.ARGUMENT_2.getIRI());
            IRI dataPropertyIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), true);
            if (dataPropertyIRI == null) {
                throw new OWLRuntimeException("Don't know how to translate SWRL Atom: data property IRI is null " + firstObject);
            }
            OWLDataPropertyExpression prop = this.consumer.translateDataPropertyExpression(dataPropertyIRI);
            return this.dataFactory.getSWRLDataPropertyAtom(prop, arg1, arg2);
        }
        if (this.consumer.isSWRLIndividualPropertyAtom(firstObject)) {
            SWRLIArgument arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            SWRLIArgument arg2 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_2.getIRI());
            IRI objectPropertyIRI = this.consumer.getResourceObject(firstObject, SWRLVocabulary.PROPERTY_PREDICATE.getIRI(), true);
            if (objectPropertyIRI == null) {
                throw new OWLRuntimeException("Don't know how to translate SWRL Atom: object property IRI is null " + firstObject);
            }
            OWLObjectPropertyExpression prop = this.consumer.translateObjectPropertyExpression(objectPropertyIRI);
            return this.dataFactory.getSWRLObjectPropertyAtom(prop, arg1, arg2);
        }
        if (this.consumer.isSWRLSameAsAtom(firstObject)) {
            SWRLIArgument arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            SWRLIArgument arg2 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_2.getIRI());
            return this.dataFactory.getSWRLSameIndividualAtom(arg1, arg2);
        }
        if (this.consumer.isSWRLDifferentFromAtom(firstObject)) {
            SWRLIArgument arg1 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_1.getIRI());
            SWRLIArgument arg2 = this.translateSWRLAtomIObject(firstObject, SWRLVocabulary.ARGUMENT_2.getIRI());
            return this.dataFactory.getSWRLDifferentIndividualsAtom(arg1, arg2);
        }
        throw new OWLRuntimeException("Don't know how to translate SWRL Atom: " + firstObject);
    }

    @Override
    public SWRLAtom translate(OWLLiteral firstObject) {
        throw new OWLRuntimeException("Unexpected literal in atom list: " + firstObject);
    }

    private SWRLIArgument translateSWRLAtomIObject(IRI mainIRI, IRI argPredicateIRI) {
        IRI argIRI = this.consumer.getResourceObject(mainIRI, argPredicateIRI, true);
        if (argIRI != null) {
            if (this.consumer.isSWRLVariable(argIRI)) {
                return this.dataFactory.getSWRLVariable(argIRI);
            }
            return this.dataFactory.getSWRLIndividualArgument(this.consumer.getOWLIndividual(argIRI));
        }
        throw new OWLRuntimeException("Cannot translate SWRL Atom I-Object for " + argPredicateIRI + " Triple not found.");
    }

    private SWRLDArgument translateSWRLAtomDObject(IRI mainIRI, IRI argPredicateIRI) {
        IRI argIRI = this.consumer.getResourceObject(mainIRI, argPredicateIRI, true);
        if (argIRI != null) {
            if (!this.consumer.isSWRLVariable(argIRI)) {
                logger.info("Expected SWRL variable for SWRL Data Object: " + argIRI + "(possibly untyped)");
            }
            return this.dataFactory.getSWRLVariable(argIRI);
        }
        OWLLiteral con = this.consumer.getLiteralObject(mainIRI, argPredicateIRI, true);
        if (con != null) {
            return this.dataFactory.getSWRLLiteralArgument(con);
        }
        throw new IllegalStateException("Could not translate SWRL Atom D-Object");
    }

    private class SWRLAtomDObjectListItemTranslator
    implements ListItemTranslator<SWRLDArgument> {
        @Override
        public SWRLDArgument translate(IRI firstObject) {
            return SWRLAtomListItemTranslator.this.dataFactory.getSWRLVariable(firstObject);
        }

        @Override
        public SWRLDArgument translate(OWLLiteral firstObject) {
            return SWRLAtomListItemTranslator.this.dataFactory.getSWRLLiteralArgument(firstObject);
        }
    }
}

