/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.latex;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.coode.owlapi.latex.LatexBracketChecker;
import org.coode.owlapi.latex.LatexWriter;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.util.SimpleShortFormProvider;

public class LatexObjectVisitor
implements OWLObjectVisitor {
    public static final String AND = "\\ensuremath{\\sqcap}";
    public static final String OR = "\\ensuremath{\\sqcup}";
    public static final String NOT = "\\ensuremath{\\lnot}";
    public static final String ALL = "\\ensuremath{\\forall}";
    public static final String SOME = "\\ensuremath{\\exists}";
    public static final String HASVALUE = "\\ensuremath{hasValue}";
    public static final String MIN = "\\ensuremath{\\geq}";
    public static final String MAX = "\\ensuremath{\\leq}";
    public static final String EQUAL = "\\ensuremath{=}";
    public static final String SUBCLASS = "\\ensuremath{\\sqsubseteq}";
    public static final String EQUIV = "\\ensuremath{\\equiv}";
    public static final String NOT_EQUIV = "\\ensuremath{\\not\\equiv}";
    public static final String TOP = "\\ensuremath{\\top}";
    public static final String BOTTOM = "\\ensuremath{\\bot}";
    public static final String SELF = "\\ensuremath{\\Self}";
    public static final String CIRC = "\\ensuremath{\\circ}";
    private OWLObject subject;
    private LatexWriter writer;
    private boolean prettyPrint = true;
    private OWLDataFactory df;
    private ShortFormProvider shortFormProvider;

    public LatexObjectVisitor(LatexWriter writer, OWLDataFactory df) {
        this.writer = writer;
        this.df = df;
        this.shortFormProvider = new SimpleShortFormProvider();
        this.subject = df.getOWLThing();
    }

    public void setSubject(OWLObject subject) {
        this.subject = subject;
    }

    public void setShortFormProvider(ShortFormProvider shortFormProvder) {
        this.shortFormProvider = shortFormProvder;
    }

    private void writeSpace() {
        this.writer.writeSpace();
    }

    private void write(Object o) {
        this.writer.write(o);
    }

    private void writeOpenBrace() {
        this.writer.writeOpenBrace();
    }

    private void writeCloseBrace() {
        this.writer.writeCloseBrace();
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    @Override
    public void visit(OWLObjectIntersectionOf node) {
        Iterator<OWLClassExpression> it = node.getOperands().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(AND);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLDataAllValuesFrom node) {
        this.write(ALL);
        this.writeSpace();
        ((OWLDataPropertyExpression)node.getProperty()).accept(this);
        this.writeSpace();
        ((OWLDataRange)node.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLDataExactCardinality desc) {
        this.write(EQUAL);
        this.writeSpace();
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataMaxCardinality desc) {
        this.write(MAX);
        this.writeSpace();
        this.write(desc.getCardinality());
        this.writeSpace();
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataMinCardinality desc) {
        this.write(MIN);
        this.writeSpace();
        this.write(desc.getCardinality());
        this.writeSpace();
        ((OWLDataPropertyExpression)desc.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataSomeValuesFrom node) {
        this.write(SOME);
        this.writeSpace();
        ((OWLDataPropertyExpression)node.getProperty()).accept(this);
        this.writeSpace();
        ((OWLDataRange)node.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLDataHasValue node) {
        this.write(HASVALUE);
        this.writeSpace();
        ((OWLDataPropertyExpression)node.getProperty()).accept(this);
        this.writeSpace();
        ((OWLLiteral)node.getValue()).accept(this);
    }

    @Override
    public void visit(OWLObjectAllValuesFrom node) {
        this.write(ALL);
        this.writeSpace();
        ((OWLObjectPropertyExpression)node.getProperty()).accept(this);
        this.writeSpace();
        this.writeNested((OWLClassExpression)node.getFiller());
    }

    @Override
    public void visit(OWLObjectExactCardinality desc) {
        this.write(EQUAL);
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.writeSpace();
        this.writeNested((OWLClassExpression)desc.getFiller());
    }

    @Override
    public void visit(OWLObjectMaxCardinality desc) {
        this.write(MAX);
        this.writeSpace();
        this.write(desc.getCardinality());
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.writeSpace();
        this.writeNested((OWLClassExpression)desc.getFiller());
    }

    @Override
    public void visit(OWLObjectMinCardinality desc) {
        this.write(MIN);
        this.writeSpace();
        this.write(desc.getCardinality());
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.writeSpace();
        this.writeNested((OWLClassExpression)desc.getFiller());
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom node) {
        this.write(SOME);
        this.writeSpace();
        ((OWLObjectPropertyExpression)node.getProperty()).accept(this);
        this.writeSpace();
        this.writeNested((OWLClassExpression)node.getFiller());
    }

    @Override
    public void visit(OWLObjectHasValue node) {
        this.write(SOME);
        this.writeSpace();
        ((OWLObjectPropertyExpression)node.getProperty()).accept(this);
        this.writeSpace();
        this.writeOpenBrace();
        ((OWLIndividual)node.getValue()).accept(this);
        this.writeCloseBrace();
    }

    @Override
    public void visit(OWLObjectComplementOf node) {
        this.write(NOT);
        this.writeNested(node.getOperand());
    }

    @Override
    public void visit(OWLObjectUnionOf node) {
        Iterator<OWLClassExpression> it = node.getOperands().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLClass node) {
        this.write(this.escapeName(this.shortFormProvider.getShortForm(node)));
    }

    @Override
    public void visit(OWLObjectOneOf node) {
        Iterator<OWLIndividual> it = node.getIndividuals().iterator();
        while (it.hasNext()) {
            this.writeOpenBrace();
            it.next().accept(this);
            this.writeCloseBrace();
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLDataProperty entity) {
        this.write(this.escapeName(this.shortFormProvider.getShortForm(entity)));
    }

    @Override
    public void visit(OWLObjectProperty entity) {
        this.write(this.escapeName(this.shortFormProvider.getShortForm(entity)));
    }

    @Override
    public void visit(OWLNamedIndividual entity) {
        this.write(this.escapeName(this.shortFormProvider.getShortForm(entity)));
    }

    @Override
    public void visit(OWLObjectHasSelf desc) {
        this.write(SOME);
        this.writeSpace();
        ((OWLObjectPropertyExpression)desc.getProperty()).accept(this);
        this.writeSpace();
        this.write(SELF);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() != 2) {
            for (OWLClassExpression left : axiom.getClassExpressions()) {
                for (OWLClassExpression right : axiom.getClassExpressions()) {
                    if (left == right) continue;
                    if (left.equals(this.subject)) {
                        left.accept(this);
                        this.writeSpace();
                        this.write(SUBCLASS);
                        this.writeSpace();
                        this.write(NOT);
                        this.writeSpace();
                        right.accept(this);
                    } else {
                        right.accept(this);
                        this.writeSpace();
                        this.write(SUBCLASS);
                        this.writeSpace();
                        this.write(NOT);
                        this.writeSpace();
                        left.accept(this);
                    }
                    this.writer.writeNewLine();
                }
            }
        } else {
            OWLClassExpression rhs;
            OWLClassExpression lhs;
            Iterator<OWLClassExpression> it = axiom.getClassExpressions().iterator();
            OWLClassExpression descA = it.next();
            OWLClassExpression descB = it.next();
            if (descA.equals(this.subject)) {
                lhs = descA;
                rhs = descB;
            } else {
                lhs = descB;
                rhs = descA;
            }
            lhs.accept(this);
            this.writeSpace();
            this.write(SUBCLASS);
            this.writeSpace();
            this.write(NOT);
            this.writeSpace();
            rhs.accept(this);
        }
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() > 2) {
            HashSet<Set<OWLClassExpression>> rendered = new HashSet<Set<OWLClassExpression>>();
            for (OWLClassExpression left : axiom.getClassExpressions()) {
                for (OWLClassExpression right : axiom.getClassExpressions()) {
                    Set<OWLClassExpression> cur;
                    if (left == right || rendered.contains(cur = CollectionFactory.createSet(left, right))) continue;
                    rendered.add(cur);
                    left.accept(this);
                    this.writeSpace();
                    this.write(EQUIV);
                    this.writeSpace();
                    right.accept(this);
                }
            }
        } else if (axiom.getClassExpressions().size() == 2) {
            OWLClassExpression rhs;
            OWLClassExpression lhs;
            Iterator<OWLClassExpression> it = axiom.getClassExpressions().iterator();
            OWLClassExpression descA = it.next();
            OWLClassExpression descB = it.next();
            if (this.subject.equals(descA)) {
                lhs = descA;
                rhs = descB;
            } else {
                lhs = descB;
                rhs = descA;
            }
            lhs.accept(this);
            this.writeSpace();
            this.write(EQUIV);
            this.writeSpace();
            rhs.accept(this);
        }
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.setPrettyPrint(false);
        axiom.getSubClass().accept(this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getSuperClass().accept(this);
        this.writeSpace();
        this.setPrettyPrint(true);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getIndividual().accept(this);
        this.writeSpace();
        this.write(":");
        this.writeSpace();
        axiom.getClassExpression().accept(this);
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.write("AsymmetricProperty");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write("(");
        axiom.getSubject().accept(this);
        this.writeSpace();
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), this.df.getTopDatatype()).accept(this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getDomain().accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), (OWLDataRange)axiom.getRange()).accept(this);
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        axiom.getSubProperty();
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
        this.write("Declaration");
        axiom.getEntity().accept(this);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        Iterator<OWLIndividual> it = axiom.getIndividuals().iterator();
        while (it.hasNext()) {
            this.write("\\{");
            it.next().accept(this);
            this.write("\\}");
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(NOT_EQUIV);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        Iterator it = axiom.getProperties().iterator();
        while (it.hasNext()) {
            ((OWLDataPropertyExpression)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(NOT_EQUIV);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.write("DisjointObjectProperties");
        this.writeSpace();
        for (OWLObjectPropertyExpression p : axiom.getProperties()) {
            p.accept(this);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.write("DisjointUnion");
        this.writeSpace();
        for (OWLClassExpression p : axiom.getClassExpressions()) {
            p.accept(this);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.write("Annotation");
        axiom.getSubject().accept(this);
        this.writeSpace();
        axiom.getProperty().accept(this);
        this.writeSpace();
        axiom.getValue().accept(this);
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        Iterator it = axiom.getProperties().iterator();
        while (it.hasNext()) {
            ((OWLDataPropertyExpression)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(NOT_EQUIV);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        Iterator it = axiom.getProperties().iterator();
        while (it.hasNext()) {
            ((OWLObjectPropertyExpression)it.next()).accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(EQUIV);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLDataMaxCardinality(1, (OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    public void visit(OWLImportsDeclaration axiom) {
        this.write("ImportsDeclaration");
        axiom.getIRI().accept(this);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        OWLObjectInverseOf prop = this.df.getOWLObjectInverseOf((OWLObjectPropertyExpression)axiom.getProperty());
        this.df.getOWLObjectMaxCardinality(1, prop).accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.write(axiom.getFirstProperty());
        this.writeSpace();
        this.write(EQUIV);
        this.writeSpace();
        this.write(axiom.getSecondProperty());
        this.write("\\ensuremath{^-}");
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.write("IrreflexiveObjectProperty");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.write(NOT);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(", ");
        ((OWLLiteral)axiom.getObject()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.write(NOT);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(", ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write("(");
        axiom.getSubject().accept(this);
        this.write(", ");
        ((OWLIndividual)axiom.getObject()).accept(this);
        this.write(")");
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        Iterator<OWLObjectPropertyExpression> it = axiom.getPropertyChain().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(CIRC);
            this.writeSpace();
        }
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.df.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), this.df.getOWLThing()).accept(this);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getDomain().accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.write(TOP);
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        this.df.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)axiom.getRange()).accept(this);
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        axiom.getSubProperty();
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.write("ReflexiveProperty");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        Iterator<OWLIndividual> it = axiom.getIndividuals().iterator();
        while (it.hasNext()) {
            this.write("\\{");
            it.next().accept(this);
            this.write("\\}");
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(EQUIV);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.writeSpace();
        this.write(EQUIV);
        this.writeSpace();
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
        this.write("\\ensuremath{^-}");
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.write("Datatype");
        axiom.getDatatype().accept(this);
        this.write(EQUIV);
        axiom.getDataRange().accept(this);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.write("TransitiveProperty");
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(SWRLRule rule) {
        this.write("SWRLRule");
        for (SWRLAtom a : rule.getHead()) {
            a.accept(this);
        }
        this.write("\\rightarrow");
        for (SWRLAtom a : rule.getBody()) {
            a.accept(this);
        }
    }

    @Override
    public void visit(SWRLVariable node) {
        this.write(node.getIRI());
    }

    private void writeNested(OWLClassExpression classExpression) {
        this.openBracket(classExpression);
        classExpression.accept(this);
        this.closeBracket(classExpression);
    }

    private void writeNested(OWLObject expression) {
        expression.accept(this);
    }

    private void openBracket(OWLClassExpression classExpression) {
        if (LatexBracketChecker.requiresBracket(classExpression)) {
            this.write("(");
        }
    }

    private void closeBracket(OWLClassExpression classExpression) {
        if (LatexBracketChecker.requiresBracket(classExpression)) {
            this.write(")");
        }
    }

    private String escapeName(String name) {
        return name.replace("_", "\\_");
    }

    @Override
    public void visit(OWLOntology ontology) {
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        property.getInverse().accept(this);
        this.write("\\ensuremath{^-}");
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.write(NOT);
        this.writeNested(node.getDataRange());
    }

    @Override
    public void visit(OWLDataOneOf node) {
        Iterator<OWLLiteral> it = node.getValues().iterator();
        while (it.hasNext()) {
            this.writeOpenBrace();
            it.next().accept(this);
            this.writeCloseBrace();
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.write("Facet");
        this.write(node.getFacet());
        node.getFacetValue().accept(this);
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.write("DatatypeRestriction");
        node.getDatatype().accept(this);
        for (OWLFacetRestriction r : node.getFacetRestrictions()) {
            this.writeSpace();
            r.accept(this);
        }
    }

    @Override
    public void visit(OWLDatatype node) {
        this.write("Datatype");
        this.write(node.getIRI());
    }

    @Override
    public void visit(OWLLiteral node) {
        this.write("\"");
        this.write(node.getLiteral());
        this.write("\"\\^\\^");
        this.write(node.getDatatype().getIRI());
    }

    @Override
    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept(this);
    }

    @Override
    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept(this);
    }

    @Override
    public void visit(SWRLBuiltInAtom node) {
        node.getPredicate().accept(this);
        for (SWRLDArgument d : node.getArguments()) {
            this.writeSpace();
            d.accept(this);
        }
    }

    @Override
    public void visit(SWRLClassAtom node) {
        ((SWRLIArgument)node.getArgument()).accept(this);
    }

    @Override
    public void visit(SWRLDataRangeAtom node) {
        node.getPredicate().accept(this);
    }

    @Override
    public void visit(SWRLDataPropertyAtom node) {
        node.getPredicate().accept(this);
    }

    @Override
    public void visit(SWRLDifferentIndividualsAtom node) {
        for (SWRLArgument a : node.getAllArguments()) {
            this.writeSpace();
            a.accept(this);
        }
    }

    @Override
    public void visit(SWRLObjectPropertyAtom node) {
        node.getPredicate().accept(this);
    }

    @Override
    public void visit(SWRLSameIndividualAtom node) {
        for (SWRLArgument a : node.getAllArguments()) {
            this.writeSpace();
            a.accept(this);
        }
    }

    @Override
    public void visit(OWLAnnotationProperty property) {
        this.write("AnnotationProperty");
        property.getIRI().accept(this);
    }

    @Override
    public void visit(OWLAnnotation annotation) {
        this.write("Annotation");
        annotation.getProperty().getIRI().accept(this);
        annotation.getValue().accept(this);
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.write("Domain");
        axiom.getProperty().getIRI().accept(this);
        this.writeSpace();
        axiom.getDomain().accept(this);
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.write("Range");
        axiom.getProperty().getIRI().accept(this);
        this.writeSpace();
        axiom.getRange().accept(this);
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        axiom.getSubProperty();
        this.writeSpace();
        this.write(SUBCLASS);
        this.writeSpace();
        axiom.getSuperProperty().accept(this);
    }

    public void visit(OWLAnnotationValue value) {
        value.accept(new OWLAnnotationValueVisitor(){

            @Override
            public void visit(IRI iri) {
                iri.accept(LatexObjectVisitor.this);
            }

            @Override
            public void visit(OWLAnonymousIndividual individual) {
                individual.accept(LatexObjectVisitor.this);
            }

            @Override
            public void visit(OWLLiteral literal) {
                literal.accept(LatexObjectVisitor.this);
            }
        });
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
        this.write("HasKey");
        axiom.getClassExpression().accept(this);
        for (OWLPropertyExpression<?, ?> p : axiom.getPropertyExpressions()) {
            this.writeSpace();
            p.accept(this);
        }
    }

    @Override
    public void visit(OWLDataIntersectionOf node) {
        Iterator<OWLDataRange> it = node.getOperands().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(AND);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLDataUnionOf node) {
        Iterator<OWLDataRange> it = node.getOperands().iterator();
        while (it.hasNext()) {
            it.next().accept(this);
            if (!it.hasNext()) continue;
            this.writeSpace();
            this.write(OR);
            this.writeSpace();
        }
    }

    @Override
    public void visit(OWLAnonymousIndividual individual) {
        this.write(individual.getID().toString());
    }

    @Override
    public void visit(IRI iri) {
        this.write(iri.getFragment());
    }
}

