/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.macro;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.coode.owlapi.manchesterowlsyntax.OntologyAxiomPair;
import org.obolibrary.macro.AbstractMacroExpansionVisitor;
import org.obolibrary.macro.ManchesterSyntaxTool;
import org.semanticweb.owlapi.expression.ParserException;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class MacroExpansionVisitor {
    protected static final Logger log = Logger.getLogger(MacroExpansionVisitor.class.getName());
    private OWLOntology inputOntology;
    private OWLOntologyManager manager;
    private Visitor visitor;
    protected ManchesterSyntaxTool manchesterSyntaxTool;

    public MacroExpansionVisitor(OWLOntology inputOntology) {
        this.inputOntology = inputOntology;
        this.visitor = new Visitor(inputOntology);
        this.manchesterSyntaxTool = new ManchesterSyntaxTool(inputOntology);
        this.manager = inputOntology.getOWLOntologyManager();
    }

    public OWLOntology expandAll() {
        HashSet<OWLAxiom> newAxioms = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> rmAxioms = new HashSet<OWLAxiom>();
        Iterator<OWLAxiom> iterator = this.inputOntology.getAxioms().iterator();
        while (iterator.hasNext()) {
            OWLAxiom ax;
            OWLAxiom exAx = ax = iterator.next();
            if (ax instanceof OWLSubClassOfAxiom) {
                exAx = this.visitor.visit((OWLSubClassOfAxiom)ax);
            } else if (ax instanceof OWLEquivalentClassesAxiom) {
                exAx = this.visitor.visit((OWLEquivalentClassesAxiom)ax);
            } else if (ax instanceof OWLClassAssertionAxiom) {
                exAx = this.visitor.visit((OWLClassAssertionAxiom)ax);
            } else if (ax instanceof OWLAnnotationAssertionAxiom) {
                for (OWLAxiom expandedAx : this.expand((OWLAnnotationAssertionAxiom)ax)) {
                    if (ax.equals(expandedAx)) continue;
                    newAxioms.add(expandedAx);
                    rmAxioms.add(ax);
                }
            }
            if (ax.equals(exAx)) continue;
            newAxioms.add(exAx);
            rmAxioms.add(ax);
        }
        this.manager.addAxioms(this.inputOntology, newAxioms);
        this.manager.removeAxioms(this.inputOntology, rmAxioms);
        return this.inputOntology;
    }

    private Set<OWLAxiom> expand(OWLAnnotationAssertionAxiom ax) {
        OWLAnnotationProperty prop = ax.getProperty();
        String expandTo = (String)this.visitor.expandAssertionToMap.get(prop.getIRI());
        HashSet<OWLAxiom> setAx = new HashSet<OWLAxiom>();
        if (expandTo != null) {
            IRI axValIRI = (IRI)ax.getValue();
            OWLClass axValClass = this.visitor.dataFactory.getOWLClass(axValIRI);
            if (this.inputOntology.getDeclarationAxioms(axValClass).size() == 0) {
                OWLDeclarationAxiom newAx = this.visitor.dataFactory.getOWLDeclarationAxiom(axValClass);
                this.manager.addAxiom(this.inputOntology, newAx);
                this.manchesterSyntaxTool = new ManchesterSyntaxTool(this.inputOntology);
            }
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Template to Expand" + expandTo);
            }
            expandTo = expandTo.replaceAll("\\?X", this.manchesterSyntaxTool.getId((IRI)ax.getSubject()));
            expandTo = expandTo.replaceAll("\\?Y", this.manchesterSyntaxTool.getId(axValIRI));
            if (log.isLoggable(Level.WARNING)) {
                log.log(Level.WARNING, "Expanding " + expandTo);
            }
            try {
                Set<OntologyAxiomPair> setAxp = this.manchesterSyntaxTool.parseManchesterExpressionFrames(expandTo);
                for (OntologyAxiomPair axp : setAxp) {
                    setAx.add(axp.getAxiom());
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return setAx;
    }

    public void dispose() {
        this.manchesterSyntaxTool.dispose();
    }

    private class Visitor
    extends AbstractMacroExpansionVisitor {
        Visitor(OWLOntology inputOntology) {
            super(inputOntology, log);
        }

        @Override
        protected OWLClassExpression expandOWLObjSomeVal(OWLClassExpression filler, OWLObjectPropertyExpression p) {
            return this.expandObject(filler, p);
        }

        @Override
        protected OWLClassExpression expandOWLObjHasVal(OWLObjectHasValue desc, OWLIndividual filler, OWLObjectPropertyExpression p) {
            OWLClassExpression result = this.expandObject(filler, p);
            if (result != null) {
                result = this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)desc.getProperty(), result);
            }
            return result;
        }

        OWLClassExpression expandObject(Object filler, OWLObjectPropertyExpression p) {
            OWLClassExpression result = null;
            IRI iri = ((OWLObjectProperty)p).getIRI();
            IRI templateVal = null;
            if (this.expandExpressionMap.containsKey(iri)) {
                OWLIndividual ind;
                Set<OWLIndividual> inds;
                if (filler instanceof OWLObjectOneOf && (inds = ((OWLObjectOneOf)filler).getIndividuals()).size() == 1 && (ind = inds.iterator().next()) instanceof OWLNamedIndividual) {
                    templateVal = ((OWLNamedObject)((Object)ind)).getIRI();
                }
                if (filler instanceof OWLNamedObject) {
                    templateVal = ((OWLNamedObject)filler).getIRI();
                }
                if (templateVal != null) {
                    String tStr = (String)this.expandExpressionMap.get(iri);
                    String exStr = tStr.replaceAll("\\?Y", MacroExpansionVisitor.this.manchesterSyntaxTool.getId(templateVal));
                    try {
                        result = MacroExpansionVisitor.this.manchesterSyntaxTool.parseManchesterExpression(exStr);
                    }
                    catch (ParserException e) {
                        this.log.log(Level.SEVERE, e.getMessage(), e);
                    }
                }
            }
            return result;
        }
    }
}

