/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.debugging;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.util.CollectionFactory;

public class DebuggerClassExpressionGenerator
implements OWLAxiomVisitor {
    private final OWLDataFactory dataFactory;
    private OWLClassExpression desc;

    public DebuggerClassExpressionGenerator(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public OWLClassExpression getDebuggerClassExpression() {
        return this.desc;
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        OWLObjectComplementOf complement = this.dataFactory.getOWLObjectComplementOf(axiom.getSuperClass());
        this.desc = this.dataFactory.getOWLObjectIntersectionOf(CollectionFactory.createSet(axiom.getSubClass(), complement));
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        OWLDataSomeValuesFrom sub = this.dataFactory.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)axiom.getProperty(), this.dataFactory.getTopDatatype());
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(sub, axiom.getDomain());
        ax.accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        OWLObjectSomeValuesFrom sub = this.dataFactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), this.dataFactory.getOWLThing());
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(sub, axiom.getDomain());
        ax.accept(this);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        OWLObjectAllValuesFrom sup = this.dataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)axiom.getRange());
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(this.dataFactory.getOWLThing(), sup);
        ax.accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        OWLNamedIndividual ind = this.dataFactory.getOWLNamedIndividual(IRI.create("http://debugger.com#", "A" + System.nanoTime()));
        OWLObjectHasValue sub = this.dataFactory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getSubProperty(), ind);
        OWLObjectHasValue sup = this.dataFactory.getOWLObjectHasValue((OWLObjectPropertyExpression)axiom.getSuperProperty(), ind);
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(sub, sup);
        ax.accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
    }

    @Override
    public void visit(OWLDeclarationAxiom axiom) {
    }

    @Override
    public void visit(OWLAnnotationAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        OWLObjectOneOf sub = this.dataFactory.getOWLObjectOneOf(Collections.singleton(axiom.getIndividual()));
        OWLSubClassOfAxiom ax = this.dataFactory.getOWLSubClassOfAxiom(sub, axiom.getClassExpression());
        ax.accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (axiom.getClassExpressions().size() == 2 && axiom.getClassExpressions().contains(this.dataFactory.getOWLNothing())) {
            for (OWLClassExpression c : axiom.getClassExpressions()) {
                if (c.isOWLNothing()) continue;
                this.desc = c;
                return;
            }
        }
        Set<OWLClassExpression> clses = axiom.getClassExpressions();
        Iterator<OWLClassExpression> it = clses.iterator();
        OWLClassExpression descC = it.next();
        OWLObjectComplementOf notC = this.dataFactory.getOWLObjectComplementOf(descC);
        OWLClassExpression descD = it.next();
        OWLObjectComplementOf notD = this.dataFactory.getOWLObjectComplementOf(descD);
        OWLObjectIntersectionOf left = this.dataFactory.getOWLObjectIntersectionOf(CollectionFactory.createSet(descC, notD));
        OWLObjectIntersectionOf right = this.dataFactory.getOWLObjectIntersectionOf(CollectionFactory.createSet(notC, descD));
        this.desc = this.dataFactory.getOWLObjectUnionOf(CollectionFactory.createSet(left, right));
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
    }

    @Override
    public void visit(SWRLRule rule) {
    }

    @Override
    public void visit(OWLHasKeyAxiom axiom) {
    }

    @Override
    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
    }

    @Override
    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
    }

    @Override
    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
    }

    @Override
    public void visit(OWLDatatypeDefinitionAxiom axiom) {
    }
}

