/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class ZipDocumentTarget
implements OWLOntologyDocumentTarget {
    private final File file;

    public ZipDocumentTarget(File file) {
        this.file = file;
    }

    @Override
    public boolean isWriterAvailable() {
        return false;
    }

    @Override
    public Writer getWriter() {
        throw new OWLRuntimeException("Writer not available.  getWriter() should not be called if isWriterAvailable() returns false.");
    }

    @Override
    public boolean isOutputStreamAvailable() {
        return true;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        File parentFile = this.file.getAbsoluteFile().getParentFile();
        if (parentFile.exists() || parentFile.mkdirs()) {
            ZipOutputStream os = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(this.file)));
            os.putNextEntry(new ZipEntry("ontology.txt"));
            return os;
        }
        throw new IOException("Could not create directories: " + parentFile);
    }

    @Override
    public boolean isDocumentIRIAvailable() {
        return false;
    }

    @Override
    public IRI getDocumentIRI() {
        throw new OWLRuntimeException("IRI not available.  getDocumentIRI() should not be called if isDocumentIRIAvailable() returns false.");
    }
}

