/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.reasoner;

import java.io.Serializable;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class TimedConsoleProgressMonitor
implements ReasonerProgressMonitor,
Serializable {
    private static final long serialVersionUID = 30411L;
    private int lastPercentage = 0;
    private long lastTime;
    private long beginTime;

    @Override
    public void reasonerTaskStarted(String taskName) {
        System.out.print(taskName);
        System.out.println(" ...");
        this.beginTime = this.lastTime = System.nanoTime();
    }

    @Override
    public void reasonerTaskStopped() {
        System.out.println("    ... finished in " + (double)(System.nanoTime() - this.beginTime) / 1000000.0);
        this.lastPercentage = 0;
    }

    @Override
    public void reasonerTaskProgressChanged(int value, int max) {
        int percent;
        long time = System.nanoTime();
        if (max > 0 && this.lastPercentage != (percent = value * 100 / max)) {
            System.out.println("    " + percent + "%\t" + (time - this.lastTime) / 1000000L);
            this.lastTime = time;
            this.lastPercentage = percent;
        }
    }

    @Override
    public void reasonerTaskBusy() {
        System.out.println("    busy ...");
    }
}

