/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWLXMLVocabulary;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class AutoIRIMapper
extends DefaultHandler
implements OWLOntologyIRIMapper,
Serializable {
    private static final long serialVersionUID = 30406L;
    private final Set<String> fileExtensions;
    private boolean mapped;
    private final boolean recursive;
    private final Map<String, OntologyRootElementHandler> handlerMap;
    private final Map<IRI, IRI> ontologyIRI2PhysicalURIMap;
    private Map<String, IRI> oboFileMap;
    private final String directoryPath;
    private String currentFilePath;
    private transient SAXParserFactory parserFactory;
    private transient File directory;
    private transient File currentFile;

    public AutoIRIMapper(File rootDirectory, boolean recursive) {
        this.directory = rootDirectory;
        this.directoryPath = this.directory.getAbsolutePath();
        this.recursive = recursive;
        this.ontologyIRI2PhysicalURIMap = new HashMap<IRI, IRI>();
        this.oboFileMap = new HashMap<String, IRI>();
        this.fileExtensions = new HashSet<String>();
        this.fileExtensions.add("owl");
        this.fileExtensions.add("xml");
        this.fileExtensions.add("rdf");
        this.fileExtensions.add("omn");
        this.mapped = false;
        this.handlerMap = new HashMap<String, OntologyRootElementHandler>();
        this.handlerMap.put((Object)((Object)Namespaces.RDF) + "RDF", new RDFXMLOntologyRootElementHandler());
        this.handlerMap.put(OWLXMLVocabulary.ONTOLOGY.toString(), new OWLXMLOntologyRootElementHandler());
    }

    protected SAXParserFactory getParserFactory() {
        if (this.parserFactory == null) {
            this.parserFactory = SAXParserFactory.newInstance();
            this.parserFactory.setNamespaceAware(true);
        }
        return this.parserFactory;
    }

    protected File getDirectory() {
        if (this.directory == null) {
            this.directory = new File(this.directoryPath);
        }
        return this.directory;
    }

    protected File getCurrentFile() {
        if (this.currentFile == null && this.currentFilePath != null) {
            this.currentFile = new File(this.currentFilePath);
        }
        return this.currentFile;
    }

    public Set<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(Set<String> extensions) {
        this.fileExtensions.clear();
        this.fileExtensions.addAll(extensions);
    }

    public Set<IRI> getOntologyIRIs() {
        if (!this.mapped) {
            this.mapFiles();
        }
        return new HashSet<IRI>(this.ontologyIRI2PhysicalURIMap.keySet());
    }

    public void update() {
        this.mapFiles();
    }

    @Override
    public IRI getDocumentIRI(IRI ontologyIRI) {
        int lastSepIndex;
        String name;
        IRI documentIRI;
        String path;
        if (!this.mapped) {
            this.mapFiles();
        }
        if (ontologyIRI.toString().endsWith(".obo") && (path = ontologyIRI.toURI().getPath()) != null && (documentIRI = this.oboFileMap.get(name = path.substring((lastSepIndex = path.lastIndexOf(47)) + 1, path.length()))) != null) {
            return documentIRI;
        }
        return this.ontologyIRI2PhysicalURIMap.get(ontologyIRI);
    }

    private void mapFiles() {
        this.mapped = true;
        this.ontologyIRI2PhysicalURIMap.clear();
        this.processFile(this.getDirectory());
    }

    private void processFile(File f) {
        if (f.isHidden()) {
            return;
        }
        File[] files = f.listFiles();
        if (files != null) {
            block0: for (File file : files) {
                if (file.isDirectory() && this.recursive) {
                    this.processFile(file);
                    continue;
                }
                if (file.getName().endsWith(".obo")) {
                    this.oboFileMap.put(file.getName(), IRI.create(file));
                    continue;
                }
                if (file.getName().endsWith(".omn")) {
                    this.parseManchesterSyntaxFile(file);
                    continue;
                }
                for (String ext : this.fileExtensions) {
                    if (!file.getName().endsWith(ext)) continue;
                    this.parseFile(file);
                    continue block0;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(File file) {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            try {
                this.currentFile = file;
                this.currentFilePath = file.getAbsolutePath();
                SAXParser parser = this.getParserFactory().newSAXParser();
                parser.parse(is, (DefaultHandler)this);
            }
            catch (ParserConfigurationException e) {
                throw new OWLRuntimeException(e);
            }
            catch (SAXException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        catch (FileNotFoundException e) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void parseManchesterSyntaxFile(File file) {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = br.readLine();
            IRI ontologyIRI = null;
            while (line != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, " \r\n", false);
                line = br.readLine();
                while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken();
                    if (!tok.startsWith("<") || !tok.endsWith(">")) continue;
                    ontologyIRI = IRI.create(tok.substring(1, tok.length() - 1));
                    this.ontologyIRI2PhysicalURIMap.put(ontologyIRI, IRI.create(file));
                    break;
                }
                if (ontologyIRI == null) continue;
                break;
            }
        }
        catch (IOException e) {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        OntologyRootElementHandler handler = this.handlerMap.get(uri + localName);
        if (handler != null) {
            IRI ontologyIRI = handler.handle(attributes);
            if (ontologyIRI != null) {
                this.ontologyIRI2PhysicalURIMap.put(ontologyIRI, IRI.create(this.getCurrentFile()));
            }
            throw new SAXException();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AutoURIMapper: (");
        sb.append(this.ontologyIRI2PhysicalURIMap.size());
        sb.append(" ontologies)\n");
        for (IRI iri : this.ontologyIRI2PhysicalURIMap.keySet()) {
            sb.append("    ");
            sb.append(iri.toQuotedString());
            sb.append(" -> ");
            sb.append(this.ontologyIRI2PhysicalURIMap.get(iri));
            sb.append("\n");
        }
        return sb.toString();
    }

    private static class OWLXMLOntologyRootElementHandler
    implements OntologyRootElementHandler,
    Serializable {
        private static final long serialVersionUID = 30406L;

        @Override
        public IRI handle(Attributes attributes) {
            String ontURI = attributes.getValue(Namespaces.OWL.toString(), "ontologyIRI");
            if (ontURI == null) {
                ontURI = attributes.getValue(Namespaces.OWL.toString(), "ontologyIRI");
            }
            if (ontURI == null) {
                return null;
            }
            return IRI.create(ontURI);
        }
    }

    private static class RDFXMLOntologyRootElementHandler
    implements OntologyRootElementHandler,
    Serializable {
        private static final long serialVersionUID = 30406L;

        @Override
        public IRI handle(Attributes attributes) {
            String baseValue = attributes.getValue(Namespaces.XML.toString(), "base");
            if (baseValue == null) {
                return null;
            }
            return IRI.create(baseValue);
        }
    }

    private static interface OntologyRootElementHandler {
        public IRI handle(Attributes var1);
    }
}

