/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.util.StructureWalker;

public class OWLObjectWalker<O extends OWLObject> {
    protected OWLOntology ontology;
    private final Collection<O> objects;
    protected OWLObjectVisitorEx<?> visitor;
    protected final boolean visitDuplicates;
    protected OWLAxiom ax;
    protected OWLAnnotation annotation;
    private final List<OWLClassExpression> classExpressionPath = new ArrayList<OWLClassExpression>();
    private final List<OWLDataRange> dataRangePath = new ArrayList<OWLDataRange>();
    private StructureWalker<O> walker = new StructureWalker(this);

    public OWLObjectWalker(Set<O> objects) {
        this(objects, true);
    }

    public OWLObjectWalker(Set<O> objects, boolean visitDuplicates) {
        this.objects = new ArrayList<O>(objects);
        this.visitDuplicates = visitDuplicates;
    }

    public void setStructureWalker(StructureWalker<O> walker) {
        this.walker = walker;
    }

    public void walkStructure(OWLObjectVisitorEx<?> v) {
        this.visitor = v;
        for (OWLObject o : this.objects) {
            o.accept(this.walker);
        }
    }

    public OWLOntology getOntology() {
        return this.ontology;
    }

    public OWLAxiom getAxiom() {
        return this.ax;
    }

    public OWLAnnotation getAnnotation() {
        return this.annotation;
    }

    public List<OWLClassExpression> getClassExpressionPath() {
        return new ArrayList<OWLClassExpression>(this.classExpressionPath);
    }

    public boolean isFirstClassExpressionInPath(OWLClassExpression classExpression) {
        return !this.classExpressionPath.isEmpty() && this.classExpressionPath.get(0).equals(classExpression);
    }

    protected void pushClassExpression(OWLClassExpression ce) {
        this.classExpressionPath.add(ce);
    }

    protected void popClassExpression() {
        if (!this.classExpressionPath.isEmpty()) {
            this.classExpressionPath.remove(this.classExpressionPath.size() - 1);
        }
    }

    public List<OWLDataRange> getDataRangePath() {
        return new ArrayList<OWLDataRange>(this.dataRangePath);
    }

    protected void pushDataRange(OWLDataRange dr) {
        this.dataRangePath.add(dr);
    }

    protected void popDataRange() {
        if (!this.dataRangePath.isEmpty()) {
            this.dataRangePath.remove(this.dataRangePath.size() - 1);
        }
    }

    public void setAxiom(OWLAxiom axiom) {
        this.ax = axiom;
    }

    public void setAnnotation(OWLAnnotation node) {
        this.annotation = node;
    }
}

