/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.vocab;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.HasPrefixedName;
import org.semanticweb.owlapi.model.HasShortForm;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.Namespaces;

public enum DublinCoreVocabulary implements HasShortForm,
HasIRI,
HasPrefixedName
{
    CONTRIBUTOR("contributor"),
    COVERAGE("coverage"),
    CREATOR("creator"),
    DATE("date"),
    DESCRIPTION("description"),
    FORMAT("format"),
    IDENTIFIER("identifier"),
    LANGUAGE("language"),
    PUBLISHER("publisher"),
    RELATION("relation"),
    RIGHTS("rights"),
    SOURCE("source"),
    SUBJECT("subject"),
    TITLE("title"),
    TYPE("type");

    private final String shortName;
    private final String qname;
    private final IRI iri;
    @Deprecated
    public static final String NAME_SPACE = "http://purl.org/dc/elements/1.1/";
    public static final Set<IRI> ALL_URIS;

    private DublinCoreVocabulary(String name) {
        this.shortName = name;
        this.qname = Namespaces.DC.getPrefixName() + ":" + name;
        this.iri = IRI.create(NAME_SPACE, name);
    }

    @Deprecated
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getShortForm() {
        return this.shortName;
    }

    @Deprecated
    public String getQName() {
        return this.qname;
    }

    @Deprecated
    public URI getURI() {
        return this.iri.toURI();
    }

    @Override
    public IRI getIRI() {
        return this.iri;
    }

    public String toString() {
        return this.iri.toString();
    }

    @Override
    public String getPrefixedName() {
        return this.qname;
    }

    static {
        ALL_URIS = new HashSet<IRI>();
        for (DublinCoreVocabulary v : DublinCoreVocabulary.values()) {
            ALL_URIS.add(v.getIRI());
        }
    }
}

