/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.semanticweb.owlapi.io.FileDocumentSource;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.OWLOntologyStorageIOException;
import org.semanticweb.owlapi.io.OntologyIRIMappingNotFoundException;
import org.semanticweb.owlapi.io.StreamDocumentSource;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.DefaultChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.DefaultImpendingChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.ImmutableOWLOntologyChangeException;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.ImpendingOWLOntologyChangeListener;
import org.semanticweb.owlapi.model.MissingImportEvent;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingImportListener;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeBroadcastStrategy;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeProgressListener;
import org.semanticweb.owlapi.model.OWLOntologyChangeVetoException;
import org.semanticweb.owlapi.model.OWLOntologyChangesVetoedListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyDocumentAlreadyExistsException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyFactoryNotFoundException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyIRIMappingNotFoundException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyManagerProperties;
import org.semanticweb.owlapi.model.OWLOntologyRenameException;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyStorer;
import org.semanticweb.owlapi.model.OWLOntologyStorerNotFoundException;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.NonMappingOntologyIRIMapper;

public class OWLOntologyManagerImpl
implements OWLOntologyManager,
OWLOntologyFactory.OWLOntologyCreationHandler,
Serializable {
    private static final long serialVersionUID = 30406L;
    private static final Logger logger = Logger.getLogger(OWLOntologyManagerImpl.class.getName());
    protected Map<OWLOntologyID, OWLOntology> ontologiesByID;
    protected Map<OWLOntologyID, IRI> documentIRIsByID;
    protected Map<OWLOntologyID, OWLOntologyFormat> ontologyFormatsByOntology;
    protected Map<OWLImportsDeclaration, OWLOntologyID> ontologyIDsByImportsDeclaration;
    protected List<OWLOntologyIRIMapper> documentMappers;
    protected List<OWLOntologyFactory> ontologyFactories;
    protected List<OWLOntologyStorer> ontologyStorers;
    private boolean broadcastChanges;
    protected int loadCount = 0;
    protected int importsLoadCount = 0;
    @Deprecated
    protected boolean silentMissingImportsHandling;
    protected final Set<IRI> importedIRIs;
    protected final OWLDataFactory dataFactory;
    protected Map<OWLOntologyID, Set<OWLOntology>> importsClosureCache;
    protected final OWLOntologyManagerProperties properties;
    protected List<MissingImportListener> missingImportsListeners;
    protected List<OWLOntologyLoaderListener> loaderListeners;
    protected List<OWLOntologyChangeProgressListener> progressListeners;
    protected final AtomicLong autoGeneratedURICounter = new AtomicLong();
    protected OWLOntologyChangeBroadcastStrategy defaultChangeBroadcastStrategy;
    protected final ImpendingOWLOntologyChangeBroadcastStrategy defaultImpendingChangeBroadcastStrategy;
    private final Map<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy> listenerMap = new IdentityHashMap<OWLOntologyChangeListener, OWLOntologyChangeBroadcastStrategy>();
    private final Map<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy> impendingChangeListenerMap = new IdentityHashMap<ImpendingOWLOntologyChangeListener, ImpendingOWLOntologyChangeBroadcastStrategy>();
    private final List<OWLOntologyChangesVetoedListener> vetoListeners = new ArrayList<OWLOntologyChangesVetoedListener>();

    public OWLOntologyManagerImpl(OWLDataFactory dataFactory) {
        this.dataFactory = dataFactory;
        this.properties = new OWLOntologyManagerProperties();
        this.ontologiesByID = new HashMap<OWLOntologyID, OWLOntology>();
        this.documentIRIsByID = new HashMap<OWLOntologyID, IRI>();
        this.ontologyFormatsByOntology = new HashMap<OWLOntologyID, OWLOntologyFormat>();
        this.documentMappers = new ArrayList<OWLOntologyIRIMapper>();
        this.ontologyFactories = new ArrayList<OWLOntologyFactory>();
        this.ontologyIDsByImportsDeclaration = new HashMap<OWLImportsDeclaration, OWLOntologyID>();
        this.installDefaultURIMappers();
        this.installDefaultOntologyFactories();
        this.broadcastChanges = true;
        this.ontologyStorers = new ArrayList<OWLOntologyStorer>();
        this.importsClosureCache = new HashMap<OWLOntologyID, Set<OWLOntology>>();
        this.missingImportsListeners = new ArrayList<MissingImportListener>();
        this.loaderListeners = new ArrayList<OWLOntologyLoaderListener>();
        this.progressListeners = new ArrayList<OWLOntologyChangeProgressListener>();
        this.defaultChangeBroadcastStrategy = new DefaultChangeBroadcastStrategy();
        this.defaultImpendingChangeBroadcastStrategy = new DefaultImpendingChangeBroadcastStrategy();
        this.importedIRIs = new HashSet<IRI>();
    }

    @Deprecated
    public OWLOntologyManagerProperties getProperties() {
        return this.properties;
    }

    @Override
    public OWLDataFactory getOWLDataFactory() {
        return this.dataFactory;
    }

    @Override
    public Set<OWLOntology> getOntologies() {
        return new HashSet<OWLOntology>(this.ontologiesByID.values());
    }

    @Override
    public Set<OWLOntology> getOntologies(OWLAxiom axiom) {
        HashSet<OWLOntology> result = new HashSet<OWLOntology>(this.ontologiesByID.size());
        for (OWLOntology ont : this.getOntologies()) {
            if (!ont.containsAxiom(axiom)) continue;
            result.add(ont);
        }
        return result;
    }

    public boolean contains(OWLOntology ontology) {
        return this.ontologiesByID.containsValue(ontology);
    }

    @Override
    public boolean contains(IRI ontologyIRI) {
        if (ontologyIRI == null) {
            throw new NullPointerException("Ontology IRI cannot be null");
        }
        for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
            if (!ontologyIRI.equals(nextOntologyID.getOntologyIRI())) continue;
            return true;
        }
        for (OWLOntologyID ont : this.ontologiesByID.keySet()) {
            if (!ontologyIRI.equals(ont.getVersionIRI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(OWLOntologyID id) {
        if (this.ontologiesByID.containsKey(id)) {
            return true;
        }
        for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
            if (id.isAnonymous() || !id.getOntologyIRI().equals(nextOntologyID.getOntologyIRI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsVersion(IRI ontologyVersionIRI) {
        for (OWLOntologyID ont : this.ontologiesByID.keySet()) {
            if (!ontologyVersionIRI.equals(ont.getVersionIRI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLOntologyID> getOntologyIDsByVersion(IRI ontologyVersionIRI) {
        TreeSet<OWLOntologyID> result = new TreeSet<OWLOntologyID>();
        for (OWLOntologyID ont : this.ontologiesByID.keySet()) {
            if (!ontologyVersionIRI.equals(ont.getVersionIRI())) continue;
            result.add(ont);
        }
        return result;
    }

    @Override
    public OWLOntology getOntology(IRI ontologyIRI) {
        OWLOntologyID ontologyID = new OWLOntologyID(ontologyIRI);
        OWLOntology result = this.ontologiesByID.get(ontologyID);
        if (result == null) {
            for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                if (!ontologyIRI.equals(nextOntologyID.getVersionIRI()) && !ontologyIRI.equals(nextOntologyID.getOntologyIRI()) && !ontologyIRI.equals(nextOntologyID.getDefaultDocumentIRI())) continue;
                result = this.ontologiesByID.get(nextOntologyID);
            }
        }
        return result;
    }

    @Override
    public OWLOntology getOntology(OWLOntologyID ontologyID) {
        OWLOntology result = this.ontologiesByID.get(ontologyID);
        if (result == null) {
            for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                if (!ontologyID.getOntologyIRI().equals(nextOntologyID.getOntologyIRI())) continue;
                result = this.ontologiesByID.get(nextOntologyID);
            }
        }
        if (result == null) {
            IRI documentIRI = this.getDocumentIRIFromMappers(ontologyID, true);
            if (documentIRI == null) {
                documentIRI = !ontologyID.isAnonymous() ? ontologyID.getDefaultDocumentIRI() : IRI.generateDocumentIRI();
                Collection<IRI> existingDocumentIRIs = this.documentIRIsByID.values();
                while (existingDocumentIRIs.contains(documentIRI)) {
                    documentIRI = IRI.generateDocumentIRI();
                }
            }
            if (this.documentIRIsByID.values().contains(documentIRI)) {
                throw new RuntimeException(new OWLOntologyDocumentAlreadyExistsException(documentIRI));
            }
        }
        return result;
    }

    @Override
    public Set<OWLOntology> getVersions(IRI ontology) {
        HashSet<OWLOntology> onts = new HashSet<OWLOntology>();
        for (OWLOntology ont : this.getOntologies()) {
            if (!ontology.equals(ont.getOntologyID().getOntologyIRI())) continue;
            onts.add(ont);
        }
        return onts;
    }

    @Override
    public OWLOntology getImportedOntology(OWLImportsDeclaration declaration) {
        OWLOntologyID ontologyID = this.ontologyIDsByImportsDeclaration.get(declaration);
        if (ontologyID == null) {
            return null;
        }
        return this.getOntology(ontologyID);
    }

    @Override
    public Set<OWLOntology> getDirectImports(OWLOntology ontology) throws UnknownOWLOntologyException {
        if (!this.contains(ontology)) {
            throw new UnknownOWLOntologyException(ontology.getOntologyID());
        }
        HashSet<OWLOntology> imports = new HashSet<OWLOntology>();
        for (OWLImportsDeclaration axiom : ontology.getImportsDeclarations()) {
            OWLOntology importedOntology = this.getImportedOntology(axiom);
            if (importedOntology == null) continue;
            imports.add(importedOntology);
        }
        return imports;
    }

    @Override
    public Set<OWLOntology> getImports(OWLOntology ontology) throws UnknownOWLOntologyException {
        if (!this.contains(ontology)) {
            throw new UnknownOWLOntologyException(ontology.getOntologyID());
        }
        HashSet<OWLOntology> result = new HashSet<OWLOntology>();
        this.getImports(ontology, result);
        return result;
    }

    private void getImports(OWLOntology ont, Set<OWLOntology> result) {
        for (OWLOntology directImport : this.getDirectImports(ont)) {
            if (!result.add(directImport)) continue;
            this.getImports(directImport, result);
        }
    }

    @Override
    public Set<OWLOntology> getImportsClosure(OWLOntology ontology) {
        Set<OWLOntology> ontologies = this.importsClosureCache.get(ontology.getOntologyID());
        if (ontologies == null) {
            ontologies = new HashSet<OWLOntology>();
            this.getImportsClosure(ontology, ontologies);
            this.importsClosureCache.put(ontology.getOntologyID(), ontologies);
        }
        return CollectionFactory.getCopyOnRequestSetFromMutableCollection(ontologies);
    }

    private void getImportsClosure(OWLOntology ontology, Set<OWLOntology> ontologies) {
        ontologies.add(ontology);
        for (OWLOntology ont : this.getDirectImports(ontology)) {
            if (ontologies.contains(ont)) continue;
            this.getImportsClosure(ont, ontologies);
        }
    }

    @Override
    public List<OWLOntology> getSortedImportsClosure(OWLOntology ontology) throws UnknownOWLOntologyException {
        ArrayList<OWLOntology> importsClosure = new ArrayList<OWLOntology>();
        this.getSortedImportsClosure(ontology, importsClosure, new HashSet<OWLOntology>());
        return importsClosure;
    }

    private void getSortedImportsClosure(OWLOntology ontology, List<OWLOntology> imports, Set<OWLOntology> marker) {
        if (!marker.contains(ontology)) {
            imports.add(ontology);
            marker.add(ontology);
            for (OWLOntology imported : this.getDirectImports(ontology)) {
                this.getSortedImportsClosure(imported, imports, marker);
            }
        }
    }

    private boolean isChangeApplicable(OWLOntologyChange change) {
        return this.properties.isLoadAnnotationAxioms() || !change.isAddAxiom() || !(change.getAxiom() instanceof OWLAnnotationAxiom);
    }

    private List<OWLOntologyChange> enactChangeApplication(OWLOntologyChange change) {
        if (!this.isChangeApplicable(change)) {
            return Collections.emptyList();
        }
        OWLOntology ont = change.getOntology();
        if (!(ont instanceof OWLMutableOntology)) {
            throw new ImmutableOWLOntologyChangeException(change);
        }
        this.checkForOntologyIDChange(change);
        List<OWLOntologyChange> appliedChanges = ((OWLMutableOntology)ont).applyChange(change);
        this.checkForImportsChange(change);
        return appliedChanges;
    }

    @Override
    public List<OWLOntologyChange> applyChanges(List<? extends OWLOntologyChange> changes) {
        try {
            this.broadcastImpendingChanges(changes);
        }
        catch (OWLOntologyChangeVetoException e) {
            this.broadcastOntologyChangesVetoed(changes, e);
            return Collections.emptyList();
        }
        ArrayList<OWLOntologyChange> appliedChanges = new ArrayList<OWLOntologyChange>(changes.size() + 2);
        this.fireBeginChanges(changes.size());
        for (OWLOntologyChange oWLOntologyChange : changes) {
            appliedChanges.addAll(this.enactChangeApplication(oWLOntologyChange));
            this.fireChangeApplied(oWLOntologyChange);
        }
        this.fireEndChanges();
        this.broadcastChanges(appliedChanges);
        return appliedChanges;
    }

    @Override
    public List<OWLOntologyChange> addAxiom(OWLOntology ont, OWLAxiom axiom) {
        return this.addAxioms(ont, Collections.singleton(axiom));
    }

    @Override
    public List<OWLOntologyChange> addAxioms(OWLOntology ont, Set<? extends OWLAxiom> axioms) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>(axioms.size() + 2);
        for (OWLAxiom oWLAxiom : axioms) {
            changes.add(new AddAxiom(ont, oWLAxiom));
        }
        return this.applyChanges(changes);
    }

    @Override
    public List<OWLOntologyChange> removeAxiom(OWLOntology ont, OWLAxiom axiom) {
        return this.removeAxioms(ont, Collections.singleton(axiom));
    }

    @Override
    public List<OWLOntologyChange> removeAxioms(OWLOntology ont, Set<? extends OWLAxiom> axioms) {
        ArrayList<RemoveAxiom> changes = new ArrayList<RemoveAxiom>(axioms.size() + 2);
        for (OWLAxiom oWLAxiom : axioms) {
            changes.add(new RemoveAxiom(ont, oWLAxiom));
        }
        return this.applyChanges(changes);
    }

    @Override
    public List<OWLOntologyChange> applyChange(OWLOntologyChange change) {
        return this.applyChanges(Arrays.asList(change));
    }

    private void checkForImportsChange(OWLOntologyChange change) {
        if (change.isImportChange()) {
            this.resetImportsClosureCache();
            if (change instanceof AddImport) {
                OWLImportsDeclaration addImportDeclaration = ((AddImport)change).getImportDeclaration();
                boolean found = false;
                IRI iri = addImportDeclaration.getIRI();
                for (OWLOntologyID oWLOntologyID : this.ontologiesByID.keySet()) {
                    if (!iri.equals(oWLOntologyID.getDefaultDocumentIRI()) && !iri.equals(oWLOntologyID.getOntologyIRI()) && !iri.equals(oWLOntologyID.getVersionIRI())) continue;
                    found = true;
                    this.ontologyIDsByImportsDeclaration.put(addImportDeclaration, oWLOntologyID);
                }
                if (!found) {
                    for (Map.Entry entry : this.documentIRIsByID.entrySet()) {
                        if (!((IRI)entry.getValue()).equals(iri)) continue;
                        this.ontologyIDsByImportsDeclaration.put(addImportDeclaration, (OWLOntologyID)entry.getKey());
                    }
                }
            } else {
                OWLImportsDeclaration importDeclaration = ((RemoveImport)change).getImportDeclaration();
                this.ontologyIDsByImportsDeclaration.remove(importDeclaration);
                this.importedIRIs.remove(importDeclaration.getIRI());
            }
        }
    }

    private void checkForOntologyIDChange(OWLOntologyChange change) {
        if (change instanceof SetOntologyID) {
            SetOntologyID setID = (SetOntologyID)change;
            OWLOntology existingOntology = this.ontologiesByID.get(((SetOntologyID)change).getNewOntologyID());
            if (existingOntology != null && !change.getOntology().equals(existingOntology) && !change.getOntology().getAxioms().equals(existingOntology.getAxioms())) {
                throw new OWLOntologyRenameException(change, ((SetOntologyID)change).getNewOntologyID());
            }
            this.renameOntology(setID.getOriginalOntologyID(), setID.getNewOntologyID());
            this.resetImportsClosureCache();
        }
    }

    @Override
    public void ontologyCreated(OWLOntology ontology) {
        this.addOntology(ontology);
    }

    @Override
    public void setOntologyFormat(OWLOntology ontology, OWLOntologyFormat format) {
        OWLOntologyID ontologyID = ontology.getOntologyID();
        this.ontologyFormatsByOntology.put(ontologyID, format);
    }

    @Override
    public OWLOntologyFormat getOntologyFormat(OWLOntology ontology) {
        OWLOntologyID ontologyID = ontology.getOntologyID();
        return this.ontologyFormatsByOntology.get(ontologyID);
    }

    @Override
    public OWLOntology createOntology() throws OWLOntologyCreationException {
        return this.createOntology(new OWLOntologyID());
    }

    @Override
    public OWLOntology createOntology(IRI ontologyIRI) throws OWLOntologyCreationException {
        return this.createOntology(new OWLOntologyID(ontologyIRI));
    }

    @Deprecated
    public OWLOntology createOntology(IRI ontologyIRI, IRI versionIRI) throws OWLOntologyCreationException {
        return this.createOntology(new OWLOntologyID(ontologyIRI, versionIRI));
    }

    @Override
    public OWLOntology createOntology(OWLOntologyID ontologyID) throws OWLOntologyCreationException {
        OWLOntology ontology = this.ontologiesByID.get(ontologyID);
        if (ontology != null) {
            throw new OWLOntologyAlreadyExistsException(ontologyID);
        }
        IRI documentIRI = this.getDocumentIRIFromMappers(ontologyID, true);
        if (documentIRI == null) {
            documentIRI = !ontologyID.isAnonymous() ? ontologyID.getDefaultDocumentIRI() : IRI.generateDocumentIRI();
            Collection<IRI> existingDocumentIRIs = this.documentIRIsByID.values();
            while (existingDocumentIRIs.contains(documentIRI)) {
                documentIRI = IRI.generateDocumentIRI();
            }
        }
        if (this.documentIRIsByID.values().contains(documentIRI)) {
            throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
        }
        for (OWLOntologyFactory factory : this.ontologyFactories) {
            if (!factory.canCreateFromDocumentIRI(documentIRI)) continue;
            this.documentIRIsByID.put(ontologyID, documentIRI);
            return factory.createOWLOntology(ontologyID, documentIRI, this);
        }
        throw new OWLOntologyFactoryNotFoundException(documentIRI);
    }

    @Override
    public OWLOntology createOntology(IRI ontologyIRI, Set<OWLOntology> ontologies) throws OWLOntologyCreationException {
        return this.createOntology(ontologyIRI, ontologies, false);
    }

    @Override
    public OWLOntology createOntology(IRI ontologyIRI, Set<OWLOntology> ontologies, boolean copyLogicalAxiomsOnly) throws OWLOntologyCreationException {
        if (this.contains(ontologyIRI)) {
            throw new OWLOntologyAlreadyExistsException(new OWLOntologyID(ontologyIRI));
        }
        OWLOntology ont = this.createOntology(ontologyIRI);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (OWLOntology ontology : ontologies) {
            if (copyLogicalAxiomsOnly) {
                axioms.addAll(ontology.getLogicalAxioms());
                continue;
            }
            axioms.addAll(ontology.getAxioms());
        }
        this.addAxioms(ont, axioms);
        return ont;
    }

    @Override
    public OWLOntology createOntology(Set<OWLAxiom> axioms, IRI iri) throws OWLOntologyCreationException {
        if (this.contains(iri)) {
            throw new OWLOntologyAlreadyExistsException(new OWLOntologyID(iri));
        }
        OWLOntology ont = this.createOntology(iri);
        this.addAxioms(ont, axioms);
        return ont;
    }

    @Override
    public OWLOntology createOntology(Set<OWLAxiom> axioms) throws OWLOntologyCreationException {
        return this.createOntology(axioms, this.getNextAutoGeneratedIRI());
    }

    protected IRI getNextAutoGeneratedIRI() {
        return IRI.create("owlapi:ontology:ont" + this.autoGeneratedURICounter.getAndIncrement());
    }

    @Override
    public OWLOntology loadOntology(IRI ontologyIRI) throws OWLOntologyCreationException {
        return this.loadOntology(ontologyIRI, false, new OWLOntologyLoaderConfiguration());
    }

    protected OWLOntology loadOntology(IRI ontologyIRI, boolean allowExists, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        OWLOntology ontByID = null;
        for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
            if (!ontologyIRI.equals(nextOntologyID.getOntologyIRI())) continue;
            ontByID = this.ontologiesByID.get(nextOntologyID);
        }
        if (ontByID == null) {
            for (OWLOntologyID nextOntologyID : this.ontologiesByID.keySet()) {
                if (!ontologyIRI.equals(nextOntologyID.getVersionIRI())) continue;
                ontByID = this.ontologiesByID.get(nextOntologyID);
            }
        }
        if (ontByID != null) {
            return ontByID;
        }
        OWLOntologyID id = new OWLOntologyID(ontologyIRI);
        IRI documentIRI = this.getDocumentIRIFromMappers(id, true);
        if (documentIRI != null) {
            if (this.documentIRIsByID.values().contains(documentIRI) && !allowExists) {
                throw new OWLOntologyDocumentAlreadyExistsException(documentIRI);
            }
            OWLOntology ontByDocumentIRI = this.getOntologyByDocumentIRI(documentIRI);
            if (ontByDocumentIRI != null) {
                return ontByDocumentIRI;
            }
        } else {
            throw new OntologyIRIMappingNotFoundException(ontologyIRI);
        }
        return this.loadOntology(ontologyIRI, new IRIDocumentSource(documentIRI), configuration);
    }

    private OWLOntology getOntologyByDocumentIRI(IRI documentIRI) {
        for (OWLOntologyID ontID : this.documentIRIsByID.keySet()) {
            IRI docIRI = this.documentIRIsByID.get(ontID);
            if (docIRI == null || !docIRI.equals(documentIRI)) continue;
            return this.getOntology(ontID);
        }
        return null;
    }

    @Override
    public OWLOntology loadOntologyFromOntologyDocument(IRI documentIRI) throws OWLOntologyCreationException {
        return this.loadOntology(null, new IRIDocumentSource(documentIRI), new OWLOntologyLoaderConfiguration());
    }

    @Override
    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource documentSource) throws OWLOntologyCreationException {
        return this.loadOntology(null, documentSource, new OWLOntologyLoaderConfiguration());
    }

    @Override
    public OWLOntology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource documentSource, OWLOntologyLoaderConfiguration config) throws OWLOntologyCreationException {
        return this.loadOntology(null, documentSource, config);
    }

    @Override
    public OWLOntology loadOntologyFromOntologyDocument(File file) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument(new FileDocumentSource(file));
    }

    @Override
    public OWLOntology loadOntologyFromOntologyDocument(InputStream inputStream) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument(new StreamDocumentSource(inputStream));
    }

    /*
     * Exception decompiling
     */
    protected OWLOntology loadOntology(IRI ontologyIRI, OWLOntologyDocumentSource documentSource, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void removeOntology(OWLOntology ontology) {
        this.removeOntology(ontology.getOntologyID());
    }

    @Override
    public void removeOntology(OWLOntologyID ontologyID) {
        this.ontologiesByID.remove(ontologyID);
        this.ontologyFormatsByOntology.remove(ontologyID);
        this.documentIRIsByID.remove(ontologyID);
        this.resetImportsClosureCache();
    }

    private void addOntology(OWLOntology ont) {
        this.ontologiesByID.put(ont.getOntologyID(), ont);
        this.resetImportsClosureCache();
    }

    @Override
    public IRI getOntologyDocumentIRI(OWLOntology ontology) throws UnknownOWLOntologyException {
        if (!this.contains(ontology)) {
            throw new UnknownOWLOntologyException(ontology.getOntologyID());
        }
        return this.documentIRIsByID.get(ontology.getOntologyID());
    }

    @Override
    public void setOntologyDocumentIRI(OWLOntology ontology, IRI documentIRI) throws UnknownOWLOntologyException {
        if (!this.ontologiesByID.containsKey(ontology.getOntologyID())) {
            throw new UnknownOWLOntologyException(ontology.getOntologyID());
        }
        this.documentIRIsByID.put(ontology.getOntologyID(), documentIRI);
    }

    private void renameOntology(OWLOntologyID oldID, OWLOntologyID newID) {
        IRI documentIRI;
        OWLOntology ont = this.ontologiesByID.get(oldID);
        if (ont == null) {
            return;
        }
        this.ontologiesByID.remove(oldID);
        this.ontologiesByID.put(newID, ont);
        if (this.ontologyFormatsByOntology.containsKey(oldID)) {
            this.ontologyFormatsByOntology.put(newID, this.ontologyFormatsByOntology.remove(oldID));
        }
        if ((documentIRI = this.documentIRIsByID.remove(oldID)) != null) {
            this.documentIRIsByID.put(newID, documentIRI);
        }
        this.resetImportsClosureCache();
    }

    protected void resetImportsClosureCache() {
        this.importsClosureCache.clear();
    }

    @Override
    public void saveOntology(OWLOntology ontology) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        OWLOntologyFormat format = this.getOntologyFormat(ontology);
        this.saveOntology(ontology, format);
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLOntologyFormat ontologyFormat) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        IRI documentIRI = this.getOntologyDocumentIRI(ontology);
        this.saveOntology(ontology, ontologyFormat, documentIRI);
    }

    @Override
    public void saveOntology(OWLOntology ontology, IRI documentIRI) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        OWLOntologyFormat format = this.getOntologyFormat(ontology);
        this.saveOntology(ontology, format, documentIRI);
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLOntologyFormat ontologyFormat, IRI documentIRI) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        try {
            for (OWLOntologyStorer storer : this.ontologyStorers) {
                if (!storer.canStoreOntology(ontologyFormat)) continue;
                storer.storeOntology(ontology, documentIRI, ontologyFormat);
                return;
            }
            throw new OWLOntologyStorerNotFoundException(ontologyFormat);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageIOException(e);
        }
    }

    @Override
    public void saveOntology(OWLOntology ontology, OutputStream outputStream) throws OWLOntologyStorageException {
        this.saveOntology(ontology, new StreamDocumentTarget(outputStream));
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLOntologyFormat ontologyFormat, OutputStream outputStream) throws OWLOntologyStorageException {
        this.saveOntology(ontology, ontologyFormat, new StreamDocumentTarget(outputStream));
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        this.saveOntology(ontology, this.getOntologyFormat(ontology), documentTarget);
    }

    @Override
    public void saveOntology(OWLOntology ontology, OWLOntologyFormat ontologyFormat, OWLOntologyDocumentTarget documentTarget) throws OWLOntologyStorageException, UnknownOWLOntologyException {
        try {
            for (OWLOntologyStorer storer : this.ontologyStorers) {
                if (!storer.canStoreOntology(ontologyFormat)) continue;
                storer.storeOntology(ontology, documentTarget, ontologyFormat);
                return;
            }
            throw new OWLOntologyStorerNotFoundException(ontologyFormat);
        }
        catch (IOException e) {
            throw new OWLOntologyStorageIOException(e);
        }
    }

    @Override
    public void addOntologyStorer(OWLOntologyStorer storer) {
        this.ontologyStorers.add(0, storer);
    }

    @Override
    public void removeOntologyStorer(OWLOntologyStorer storer) {
        this.ontologyStorers.remove(storer);
    }

    @Override
    public void addIRIMapper(OWLOntologyIRIMapper mapper) {
        this.documentMappers.add(0, mapper);
    }

    @Override
    public void clearIRIMappers() {
        this.documentMappers.clear();
    }

    @Override
    public void removeIRIMapper(OWLOntologyIRIMapper mapper) {
        this.documentMappers.remove(mapper);
    }

    @Override
    public void addOntologyFactory(OWLOntologyFactory factory) {
        this.ontologyFactories.add(0, factory);
        factory.setOWLOntologyManager(this);
    }

    @Override
    public void removeOntologyFactory(OWLOntologyFactory factory) {
        this.ontologyFactories.remove(factory);
    }

    @Override
    public Collection<OWLOntologyFactory> getOntologyFactories() {
        return new ArrayList<OWLOntologyFactory>(this.ontologyFactories);
    }

    private IRI getDocumentIRIFromMappers(OWLOntologyID ontologyID, boolean quiet) {
        IRI defIRI = ontologyID.getDefaultDocumentIRI();
        if (defIRI == null) {
            return null;
        }
        for (OWLOntologyIRIMapper mapper : this.documentMappers) {
            IRI documentIRI = mapper.getDocumentIRI(defIRI);
            if (documentIRI == null) continue;
            return documentIRI;
        }
        if (!quiet) {
            throw new OWLOntologyIRIMappingNotFoundException(ontologyID.getDefaultDocumentIRI());
        }
        return null;
    }

    protected void installDefaultURIMappers() {
        this.addIRIMapper(new NonMappingOntologyIRIMapper());
    }

    protected void installDefaultOntologyFactories() {
    }

    @Override
    public void addOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.listenerMap.put(listener, this.defaultChangeBroadcastStrategy);
    }

    protected void broadcastChanges(List<? extends OWLOntologyChange> changes) {
        if (!this.broadcastChanges) {
            return;
        }
        for (OWLOntologyChangeListener listener : new ArrayList<OWLOntologyChangeListener>(this.listenerMap.keySet())) {
            OWLOntologyChangeBroadcastStrategy strategy = this.listenerMap.get(listener);
            if (strategy == null) continue;
            try {
                strategy.broadcastChanges(listener, changes);
            }
            catch (Throwable e) {
                logger.warning("BADLY BEHAVING LISTENER: " + e);
                e.printStackTrace();
            }
        }
    }

    protected void broadcastImpendingChanges(List<? extends OWLOntologyChange> changes) throws OWLOntologyChangeVetoException {
        if (!this.broadcastChanges) {
            return;
        }
        for (ImpendingOWLOntologyChangeListener listener : new ArrayList<ImpendingOWLOntologyChangeListener>(this.impendingChangeListenerMap.keySet())) {
            ImpendingOWLOntologyChangeBroadcastStrategy strategy = this.impendingChangeListenerMap.get(listener);
            if (strategy == null) continue;
            strategy.broadcastChanges(listener, changes);
        }
    }

    @Override
    public void setDefaultChangeBroadcastStrategy(OWLOntologyChangeBroadcastStrategy strategy) {
        this.defaultChangeBroadcastStrategy = strategy != null ? strategy : new DefaultChangeBroadcastStrategy();
    }

    @Override
    public void addOntologyChangeListener(OWLOntologyChangeListener listener, OWLOntologyChangeBroadcastStrategy strategy) {
        this.listenerMap.put(listener, strategy);
    }

    @Override
    public void addImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener listener) {
        this.impendingChangeListenerMap.put(listener, this.defaultImpendingChangeBroadcastStrategy);
    }

    @Override
    public void removeImpendingOntologyChangeListener(ImpendingOWLOntologyChangeListener listener) {
        this.impendingChangeListenerMap.remove(listener);
    }

    @Override
    public void removeOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.listenerMap.remove(listener);
    }

    @Override
    public void addOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener listener) {
        this.vetoListeners.add(listener);
    }

    @Override
    public void removeOntologyChangesVetoedListener(OWLOntologyChangesVetoedListener listener) {
        this.vetoListeners.remove(listener);
    }

    private void broadcastOntologyChangesVetoed(List<? extends OWLOntologyChange> changes, OWLOntologyChangeVetoException veto) {
        for (OWLOntologyChangesVetoedListener listener : new ArrayList<OWLOntologyChangesVetoedListener>(this.vetoListeners)) {
            listener.ontologyChangesVetoed(changes, veto);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OWLOntology loadImports(OWLImportsDeclaration declaration, OWLOntologyLoaderConfiguration configuration) throws OWLOntologyCreationException {
        ++this.importsLoadCount;
        OWLOntology ont = null;
        try {
            ont = this.loadOntology(declaration.getIRI(), true, configuration);
        }
        catch (OWLOntologyCreationException e) {
            if (configuration.getMissingImportHandlingStrategy() == MissingImportHandlingStrategy.THROW_EXCEPTION && !this.isSilentMissingImportsHandling()) {
                throw e;
            }
            MissingImportEvent evt = new MissingImportEvent(declaration.getIRI(), e);
            this.fireMissingImportEvent(evt);
        }
        finally {
            --this.importsLoadCount;
        }
        return ont;
    }

    @Override
    public void makeLoadImportRequest(OWLImportsDeclaration declaration) throws UnloadableImportException {
        this.makeLoadImportRequest(declaration, new OWLOntologyLoaderConfiguration());
    }

    @Override
    public void makeLoadImportRequest(OWLImportsDeclaration declaration, OWLOntologyLoaderConfiguration configuration) throws UnloadableImportException {
        IRI iri = declaration.getIRI();
        if (!configuration.isIgnoredImport(iri) && !this.importedIRIs.contains(iri)) {
            this.importedIRIs.add(iri);
            try {
                OWLOntology ont = this.loadImports(declaration, configuration);
                if (ont != null) {
                    this.ontologyIDsByImportsDeclaration.put(declaration, ont.getOntologyID());
                }
            }
            catch (OWLOntologyCreationException e) {
                throw new UnloadableImportException(e, declaration);
            }
        }
    }

    @Override
    public void setSilentMissingImportsHandling(boolean b) {
        this.silentMissingImportsHandling = b;
    }

    @Override
    public boolean isSilentMissingImportsHandling() {
        return this.silentMissingImportsHandling;
    }

    @Override
    public void addMissingImportListener(MissingImportListener listener) {
        this.missingImportsListeners.add(listener);
    }

    @Override
    public void removeMissingImportListener(MissingImportListener listener) {
        this.missingImportsListeners.remove(listener);
    }

    protected void fireMissingImportEvent(MissingImportEvent evt) {
        for (MissingImportListener listener : new ArrayList<MissingImportListener>(this.missingImportsListeners)) {
            listener.importMissing(evt);
        }
    }

    @Override
    public void addOntologyLoaderListener(OWLOntologyLoaderListener listener) {
        this.loaderListeners.add(listener);
    }

    @Override
    public void removeOntologyLoaderListener(OWLOntologyLoaderListener listener) {
        this.loaderListeners.remove(listener);
    }

    protected void fireStartedLoadingEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported) {
        for (OWLOntologyLoaderListener listener : new ArrayList<OWLOntologyLoaderListener>(this.loaderListeners)) {
            listener.startedLoadingOntology(new OWLOntologyLoaderListener.LoadingStartedEvent(ontologyID, documentIRI, imported));
        }
    }

    protected void fireFinishedLoadingEvent(OWLOntologyID ontologyID, IRI documentIRI, boolean imported, OWLOntologyCreationException ex) {
        for (OWLOntologyLoaderListener listener : new ArrayList<OWLOntologyLoaderListener>(this.loaderListeners)) {
            listener.finishedLoadingOntology(new OWLOntologyLoaderListener.LoadingFinishedEvent(ontologyID, documentIRI, imported, ex));
        }
    }

    @Override
    public void addOntologyChangeProgessListener(OWLOntologyChangeProgressListener listener) {
        this.progressListeners.add(listener);
    }

    @Override
    public void removeOntologyChangeProgessListener(OWLOntologyChangeProgressListener listener) {
        this.progressListeners.remove(listener);
    }

    protected void fireBeginChanges(int size) {
        try {
            if (!this.broadcastChanges) {
                return;
            }
            for (OWLOntologyChangeProgressListener lsnr : this.progressListeners) {
                lsnr.begin(size);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void fireEndChanges() {
        try {
            if (!this.broadcastChanges) {
                return;
            }
            for (OWLOntologyChangeProgressListener lsnr : this.progressListeners) {
                lsnr.end();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void fireChangeApplied(OWLOntologyChange change) {
        try {
            if (!this.broadcastChanges) {
                return;
            }
            if (this.progressListeners.isEmpty()) {
                return;
            }
            for (OWLOntologyChangeProgressListener lsnr : this.progressListeners) {
                lsnr.appliedChange(change);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

