/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owlapi.modularity;

import com.clarkparsia.owlapi.modularity.locality.LocalityClass;
import com.clarkparsia.owlapi.modularity.locality.SyntacticLocalityEvaluator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.modularity.OntologySegmenter;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import uk.ac.manchester.cs.owlapi.modularity.ModuleType;

public class SyntacticLocalityModuleExtractor
implements OntologySegmenter {
    private static final Logger logger = Logger.getLogger(SyntacticLocalityModuleExtractor.class.getName());
    ModuleType moduleType;
    final OntologyAxiomSet ontologyAxiomSet;
    final OWLOntology rootOntology;
    final OWLOntology ontology;
    final OWLOntologyManager manager;

    private OWLOntology createOntology(OWLOntologyManager man, OWLOntology ont, Set<OWLAxiom> axs) {
        try {
            return man.createOntology(axs);
        }
        catch (OWLOntologyCreationException e) {
            return ont;
        }
    }

    public SyntacticLocalityModuleExtractor(OWLOntologyManager man, OWLOntology ont, Set<OWLAxiom> axs, ModuleType moduleType) {
        this.setModuleType(moduleType);
        this.manager = man;
        this.rootOntology = ont;
        this.ontologyAxiomSet = new OntologyAxiomSet(axs);
        this.ontology = this.createOntology(man, ont, axs);
    }

    public SyntacticLocalityModuleExtractor(OWLOntologyManager man, OWLOntology ont, ModuleType moduleType) {
        HashSet<OWLAxiom> axs = new HashSet<OWLAxiom>(ont.getAxioms());
        for (OWLOntology importedOnt : ont.getImportsClosure()) {
            axs.addAll(importedOnt.getAxioms());
        }
        this.setModuleType(moduleType);
        this.manager = man;
        this.rootOntology = ont;
        this.ontologyAxiomSet = new OntologyAxiomSet(axs);
        this.ontology = this.createOntology(man, ont, axs);
    }

    public void setModuleType(ModuleType moduleType) {
        this.moduleType = moduleType;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }

    boolean[] extractLogicalAxioms(boolean[] subOnt, Set<OWLEntity> signature, LocalityClass localityClass, boolean verbose) {
        boolean[] mod = this.ontologyAxiomSet.getSubset(false);
        boolean[] q2 = this.ontologyAxiomSet.cloneSubset(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        int loopNumber = 0;
        while (change) {
            change = false;
            ++loopNumber;
            if (verbose) {
                logger.info("  Loop " + loopNumber);
            }
            for (int i = 0; i < q2.length; ++i) {
                if (!q2[i]) continue;
                if (!sle.isLocal(this.ontologyAxiomSet.getAxiom(i), signature)) {
                    if (verbose) {
                        logger.info("      Non-local axiom:   " + this.minusOntologyURI(this.ontologyAxiomSet.getAxiom(i).toString()));
                    }
                    mod[i] = true;
                    q2[i] = false;
                    int oldSize = signature.size();
                    signature.addAll(this.ontologyAxiomSet.getAxiom(i).getSignature());
                    if (signature.size() <= oldSize) continue;
                    change = true;
                    if (!verbose) continue;
                    logger.info("    New signature:   " + signature);
                    continue;
                }
                if (!verbose) continue;
                logger.info("      Local axiom:       " + this.minusOntologyURI(this.ontologyAxiomSet.getAxiom(i).toString()));
            }
        }
        return mod;
    }

    Set<OWLAxiom> extract(Set<OWLAxiom> subOnt, Set<OWLEntity> signature, LocalityClass localityClass, boolean verbose) {
        HashSet<OWLAxiom> mod = new HashSet<OWLAxiom>();
        HashSet<OWLAxiom> q2 = new HashSet<OWLAxiom>(subOnt);
        SyntacticLocalityEvaluator sle = new SyntacticLocalityEvaluator(localityClass);
        boolean change = true;
        int loopNumber = 0;
        while (change) {
            change = false;
            ++loopNumber;
            if (verbose) {
                logger.info("  Loop " + loopNumber);
            }
            HashSet<OWLAxiom> q2remove = new HashSet<OWLAxiom>();
            for (OWLAxiom ax : q2) {
                if (!sle.isLocal(ax, signature)) {
                    if (verbose) {
                        logger.info("      Non-local axiom:   " + this.minusOntologyURI(ax.toString()));
                    }
                    mod.add(ax);
                    q2remove.add(ax);
                    int oldSize = signature.size();
                    signature.addAll(ax.getSignature());
                    if (signature.size() <= oldSize) continue;
                    change = true;
                    if (!verbose) continue;
                    logger.info("    New signature:   " + signature);
                    continue;
                }
                if (!verbose) continue;
                logger.info("      Local axiom:       " + this.minusOntologyURI(ax.toString()));
            }
            q2.removeAll(q2remove);
        }
        return mod;
    }

    Set<OWLAxiom> enrich(Set<OWLAxiom> module, Set<OWLEntity> sig, boolean verbose) {
        HashSet<OWLAxiom> enrichedModule = new HashSet<OWLAxiom>(module);
        if (verbose) {
            logger.info("\nEnriching with declaration axioms, annotation axioms, same/different individual axioms ...");
        }
        if (this.ontology != null) {
            for (OWLEntity entity : sig) {
                Set<OWLDeclarationAxiom> declarationAxioms = this.ontology.getDeclarationAxioms(entity);
                enrichedModule.addAll(declarationAxioms);
                if (verbose) {
                    for (OWLDeclarationAxiom oWLDeclarationAxiom : declarationAxioms) {
                        logger.info("  Added entity declaration axiom:   " + this.minusOntologyURI(oWLDeclarationAxiom.toString()));
                    }
                }
                Set<OWLAnnotationAssertionAxiom> entityAnnotationAxioms = entity.getAnnotationAssertionAxioms(this.ontology);
                enrichedModule.addAll(entityAnnotationAxioms);
                if (!verbose) continue;
                for (OWLAnnotationAssertionAxiom entityAnnotationAxiom : entityAnnotationAxioms) {
                    logger.info("  Added entity annotation axiom:   " + this.minusOntologyURI(entityAnnotationAxiom.toString()));
                }
            }
        }
        if (this.ontology != null) {
            for (OWLEntity entity : sig) {
                if (!OWLNamedIndividual.class.isAssignableFrom(entity.getClass())) continue;
                OWLIndividual individual = (OWLIndividual)((Object)entity);
                Set<OWLSameIndividualAxiom> sameIndividualAxioms = this.ontology.getSameIndividualAxioms(individual);
                enrichedModule.addAll(sameIndividualAxioms);
                if (verbose) {
                    for (OWLSameIndividualAxiom sameIndividualAxiom : sameIndividualAxioms) {
                        logger.info("  Added same individual axiom:   " + this.minusOntologyURI(sameIndividualAxiom.toString()));
                    }
                }
                Set<OWLDifferentIndividualsAxiom> set = this.ontology.getDifferentIndividualAxioms(individual);
                enrichedModule.addAll(set);
                if (!verbose) continue;
                for (OWLDifferentIndividualsAxiom differentIndividualsAxiom : set) {
                    logger.info("  Added different individual axiom:   " + this.minusOntologyURI(differentIndividualsAxiom.toString()));
                }
            }
        }
        return enrichedModule;
    }

    String minusOntologyURI(String s) {
        String uri = this.manager.getOntologyDocumentIRI(this.rootOntology).toString() + "#";
        return s.replace(uri, "").replace("<", "").replace(">", "");
    }

    void outputSignature(String preamble, Set<OWLEntity> sig, boolean verbose) {
        if (verbose) {
            logger.info(preamble);
            for (OWLEntity ent : sig) {
                logger.info("  " + this.minusOntologyURI(ent.toString()));
            }
        }
    }

    Set<OWLAxiom> extractUnnestedModule(Set<OWLEntity> sig, LocalityClass cls, boolean verbose) {
        this.outputSignature("\nExtracting " + (Object)((Object)cls) + " module for the following seed signature ... ", sig, verbose);
        boolean[] subOnt = this.ontologyAxiomSet.getSubset(true);
        HashSet<OWLEntity> signature = new HashSet<OWLEntity>(sig);
        boolean[] module = this.extractLogicalAxioms(subOnt, signature, cls, verbose);
        Set<OWLAxiom> moduleAsSet = this.ontologyAxiomSet.toSet(module);
        return this.enrich(moduleAsSet, signature, verbose);
    }

    /*
     * WARNING - void declaration
     */
    Set<OWLClass> SuperOrSubClasses(int superOrSubClassLevel, boolean superVsSub, OWLReasoner reasoner, Set<OWLClass> classesInSig) {
        HashSet<OWLClass> superOrSubClasses = new HashSet<OWLClass>();
        if (superOrSubClassLevel < 0) {
            for (OWLClassExpression oWLClassExpression : classesInSig) {
                NodeSet<OWLClass> nodes = superVsSub ? reasoner.getSuperClasses(oWLClassExpression, false) : reasoner.getSubClasses(oWLClassExpression, false);
                superOrSubClasses.addAll(nodes.getFlattened());
            }
        } else if (superOrSubClassLevel > 0) {
            LinkedList<OWLClass> linkedList = new LinkedList<OWLClass>(classesInSig);
            LinkedList<OWLClass> suClassesToBeAdded = new LinkedList<OWLClass>();
            for (int i = 0; i < superOrSubClassLevel; ++i) {
                void var7_10;
                void toBeSuClassedNow = var7_10;
                LinkedList<OWLClass> linkedList2 = new LinkedList<OWLClass>();
                for (OWLClassExpression oWLClassExpression : toBeSuClassedNow) {
                    Set<OWLClass> suClasses = superVsSub ? reasoner.getSuperClasses(oWLClassExpression, true).getFlattened() : reasoner.getSubClasses(oWLClassExpression, true).getFlattened();
                    for (OWLClass suClass : suClasses) {
                        if (classesInSig.contains(suClass) || suClassesToBeAdded.contains(suClass)) continue;
                        linkedList2.add(suClass);
                        suClassesToBeAdded.add(suClass);
                    }
                }
            }
            superOrSubClasses.addAll(suClassesToBeAdded);
        }
        return superOrSubClasses;
    }

    Set<OWLEntity> enrichSignature(Set<OWLEntity> sig, int superClassLevel, int subClassLevel, OWLReasoner reasoner) {
        HashSet<OWLEntity> enrichedSig = new HashSet<OWLEntity>(sig);
        HashSet<OWLClass> classesInSig = new HashSet<OWLClass>();
        for (OWLEntity ent : sig) {
            if (!OWLClass.class.isAssignableFrom(ent.getClass())) continue;
            classesInSig.add((OWLClass)ent);
        }
        if (superClassLevel != 0) {
            enrichedSig.addAll(this.SuperOrSubClasses(superClassLevel, true, reasoner, classesInSig));
        }
        if (subClassLevel != 0) {
            enrichedSig.addAll(this.SuperOrSubClasses(subClassLevel, false, reasoner, classesInSig));
        }
        return enrichedSig;
    }

    @Override
    public Set<OWLAxiom> extract(Set<OWLEntity> sig) {
        return this.extract(sig, 0, 0, null, false);
    }

    @Override
    public Set<OWLAxiom> extract(Set<OWLEntity> sig, int superClassLevel, int subClassLevel, OWLReasoner reasoner) {
        return this.extract(sig, superClassLevel, subClassLevel, reasoner, false);
    }

    public Set<OWLAxiom> extract(Set<OWLEntity> sig, int superClassLevel, int subClassLevel, OWLReasoner reasoner, boolean verbose) {
        Set<OWLEntity> enrichedSig = this.enrichSignature(sig, superClassLevel, subClassLevel, reasoner);
        switch (this.moduleType) {
            case TOP: {
                return this.extractUnnestedModule(enrichedSig, LocalityClass.TOP_TOP, verbose);
            }
            case BOT: {
                return this.extractUnnestedModule(enrichedSig, LocalityClass.BOTTOM_BOTTOM, verbose);
            }
            case STAR: {
                boolean[] subOnt = this.ontologyAxiomSet.getSubset(true);
                boolean nextStepNecessary = true;
                boolean inFirstStep = true;
                LocalityClass localityClass = LocalityClass.BOTTOM_BOTTOM;
                HashSet<OWLEntity> seedSig = new HashSet<OWLEntity>(enrichedSig);
                while (nextStepNecessary) {
                    this.outputSignature("\nExtracting " + (Object)((Object)localityClass) + " module for the following seed signature: ", enrichedSig, verbose);
                    int previousModuleSize = this.ontologyAxiomSet.subsetCardinality(subOnt);
                    seedSig = new HashSet<OWLEntity>(enrichedSig);
                    subOnt = this.extractLogicalAxioms(subOnt, seedSig, localityClass, verbose);
                    if (this.ontologyAxiomSet.subsetCardinality(subOnt) == previousModuleSize && !inFirstStep) {
                        nextStepNecessary = false;
                    }
                    inFirstStep = false;
                    if (localityClass == LocalityClass.BOTTOM_BOTTOM) {
                        localityClass = LocalityClass.TOP_TOP;
                        continue;
                    }
                    localityClass = LocalityClass.BOTTOM_BOTTOM;
                }
                Set<OWLAxiom> moduleAsSet = this.ontologyAxiomSet.toSet(subOnt);
                return this.enrich(moduleAsSet, seedSig, verbose);
            }
        }
        throw new RuntimeException("Unsupported module type: " + (Object)((Object)this.moduleType));
    }

    @Override
    public OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI iri) throws OWLOntologyCreationException {
        return this.extractAsOntology(signature, iri, 0, 0, null, false);
    }

    @Override
    public OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI iri, int superClassLevel, int subClassLevel, OWLReasoner reasoner) throws OWLOntologyCreationException {
        return this.extractAsOntology(signature, iri, superClassLevel, subClassLevel, reasoner, false);
    }

    OWLOntology extractAsOntology(Set<OWLEntity> signature, IRI iri, int superClassLevel, int subClassLevel, OWLReasoner reasoner, boolean verbose) throws OWLOntologyCreationException {
        Set<OWLAxiom> axs = this.extract(signature, superClassLevel, subClassLevel, reasoner, verbose);
        OWLOntology newOnt = this.manager.createOntology(iri);
        LinkedList<AddAxiom> addaxs = new LinkedList<AddAxiom>();
        for (OWLAxiom ax : axs) {
            addaxs.add(new AddAxiom(newOnt, ax));
        }
        this.manager.applyChanges(addaxs);
        return newOnt;
    }

    static class OntologyAxiomSet {
        final OWLAxiom[] ax;

        public OntologyAxiomSet(Set<OWLAxiom> axs) {
            this.ax = axs.toArray(new OWLAxiom[axs.size()]);
        }

        public int size() {
            return this.ax.length;
        }

        public OWLAxiom getAxiom(int i) {
            return this.ax[i];
        }

        public OWLAxiom[] getAllAxioms() {
            OWLAxiom[] toReturn = new OWLAxiom[this.ax.length];
            System.arraycopy(this.ax, 0, toReturn, 0, this.ax.length);
            return toReturn;
        }

        public Set<OWLAxiom> getAxiomSet(boolean[] isIn) {
            HashSet<OWLAxiom> gas = new HashSet<OWLAxiom>();
            for (int i = 0; i < isIn.length; ++i) {
                if (!isIn[i]) continue;
                gas.add(this.ax[i]);
            }
            return gas;
        }

        public boolean[] getSubset(boolean init) {
            boolean[] subset = new boolean[this.ax.length];
            for (int i = 0; i < this.ax.length; ++i) {
                subset[i] = init;
            }
            return subset;
        }

        public boolean[] cloneSubset(boolean[] oldSubset) {
            boolean[] newSubset = new boolean[this.ax.length];
            System.arraycopy(oldSubset, 0, newSubset, 0, this.ax.length);
            return newSubset;
        }

        public int subsetCardinality(boolean[] subset) {
            int card = 0;
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                ++card;
            }
            return card;
        }

        public Set<OWLAxiom> toSet(boolean[] subset) {
            HashSet<OWLAxiom> axs = new HashSet<OWLAxiom>();
            for (int i = 0; i < this.ax.length; ++i) {
                if (!subset[i]) continue;
                axs.add(this.ax[i]);
            }
            return axs;
        }
    }
}

