/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.manchestersyntax.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.annotation.Nonnull;
import javax.inject.Provider;
import org.semanticweb.owlapi.OWLAPIConfigProvider;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormat;
import org.semanticweb.owlapi.formats.ManchesterSyntaxDocumentFormatFactory;
import org.semanticweb.owlapi.io.AbstractOWLParser;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntax;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxParserException;
import org.semanticweb.owlapi.manchestersyntax.parser.ManchesterOWLSyntaxParserImpl;
import org.semanticweb.owlapi.manchestersyntax.renderer.ParserException;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;

public class ManchesterOWLSyntaxOntologyParser
extends AbstractOWLParser {
    private static final long serialVersionUID = 40000L;
    private static final String COMMENT_START_CHAR = "#";
    private static final String DEFAULT_FILE_ENCODING = "UTF-8";

    @Override
    @Nonnull
    public String getName() {
        return "ManchesterOWLSyntaxOntologyParser";
    }

    @Override
    public OWLDocumentFormatFactory getSupportedFormat() {
        return new ManchesterSyntaxDocumentFormatFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OWLDocumentFormat parse(OWLOntologyDocumentSource documentSource, OWLOntology ontology, OWLOntologyLoaderConfiguration configuration) throws IOException {
        try {
            ManchesterSyntaxDocumentFormat format = new ManchesterSyntaxDocumentFormat();
            try (BufferedReader br = null;){
                String line;
                br = documentSource.isReaderAvailable() ? new BufferedReader(documentSource.getReader()) : (documentSource.isInputStreamAvailable() ? new BufferedReader(new InputStreamReader(documentSource.getInputStream(), DEFAULT_FILE_ENCODING)) : new BufferedReader(new InputStreamReader(this.getInputStream(documentSource.getDocumentIRI(), configuration), DEFAULT_FILE_ENCODING)));
                StringBuilder sb = new StringBuilder();
                int lineCount = 1;
                boolean foundMagicNumber = false;
                while ((line = br.readLine()) != null) {
                    String trimmedLine;
                    sb.append(line);
                    sb.append('\n');
                    if (!(foundMagicNumber || (trimmedLine = line.trim()).isEmpty() || trimmedLine.startsWith(COMMENT_START_CHAR))) {
                        if (ManchesterOWLSyntaxOntologyParser.startsWithMagicNumber(line)) {
                            foundMagicNumber = true;
                        } else {
                            int startCol = line.indexOf(trimmedLine) + 1;
                            String msg = String.format("Encountered '%s' at line %s column %s.  Expected either 'Ontology:' or 'Prefix:'", trimmedLine, lineCount, startCol);
                            throw new ManchesterOWLSyntaxParserException(msg, lineCount, startCol);
                        }
                    }
                    ++lineCount;
                }
                String s = sb.toString();
                assert (s != null);
                ManchesterOWLSyntaxParserImpl parser = new ManchesterOWLSyntaxParserImpl((Provider<OWLOntologyLoaderConfiguration>)new OWLAPIConfigProvider(), ontology.getOWLOntologyManager().getOWLDataFactory());
                parser.setOntologyLoaderConfiguration(configuration);
                parser.setStringToParse(s);
                format = parser.parseOntology(ontology);
            }
            return format;
        }
        catch (ParserException e) {
            throw new ManchesterOWLSyntaxParserException(e.getMessage(), (Throwable)e, e.getLineNumber(), e.getColumnNumber());
        }
    }

    private static boolean startsWithMagicNumber(String line) {
        return line.indexOf(ManchesterOWLSyntax.PREFIX.toString()) != -1 || line.indexOf(ManchesterOWLSyntax.ONTOLOGY.toString()) != -1;
    }
}

